// plugin/vue-renderer/renderer/replace-content.js

const replaceCore = new RegExp('/src/core/', 'g')
export function replaceContent(fileName, content, vue_path, base_path) {
	if (base_path && vue_path) {
		content = content.replace(`from '/vue.js'`, `from '${base_path}/vue.js'`)
		content = content.replace(`from "vue"`, `from '${base_path}/vue.js'`)
		content = content.replace(`from '/assets/`, `from '${base_path}/assets/`)
	} else if (vue_path) {
		content = content.replace(`from '/vue.js'`, `from '${vue_path}'`)
		content = content.replace(`from "vue"`, `from '${vue_path}'`)
	} else if (fileName.indexOf('/') > 0) {
		content = content.replace(`from '/vue.js'`, `from '../../vuelib.js'`)
		content = content.replace(`from 'vue'`, `from '../../vuelib.js'`)
		content = content.replace(`from "vue"`, `from '../../vuelib.js'`)
		content = content.replace(replaceCore, `../../core/`)
	} else {
		content = content.replace(`from '/vue.js'`, `from '../vuelib.js'`)
		content = content.replace(`from 'vue'`, `from '../vuelib.js'`)
		content = content.replace(`from "vue"`, `from '../vuelib.js'`)
		content = content.replace(replaceCore, `../core/`)
	}
	if (!base_path && !vue_path) {
		content = content.replace(/import (.*)css'/g, '// import $1css')
		content = content.replace('import JsBarcode', '// import JsBarcode')
		content = content.replace('import icons from', '// import icons from')
		content = content.replace('import { Icon', '// import { Icon')
		content = content.replace('components: { Icon', '// components: { Icon')
		content = content.replace('import { currentUrl', '// import { currentUrl') // nc-util.js calls router
		content = content.replace('import gridApi', 'let gridApi // import gridApi')
		content = content.replace('import message', 'let message = {} // import message')
		content = content.replace('import { getSyncState', 'let getSyncState // import { getSyncState')
		content = content.replace('import { getMainSate', 'let getMainSate // import { getMainSate')
	}
	if (fileName.indexOf('.js') < 0) {
		fileName = fileName + '.js'
	}
	return `// ${fileName}\n` + content
}
