CREATE EXTENSION IF NOT EXISTS timescaledb;

CREATE TABLE IF NOT EXISTS audit.user_event (
    session_id uuid NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
    event_time timestamp with time zone NOT NULL DEFAULT '1970-01-01 00:00:00+00',
    event_type int,
    text_value text,
    number1 int,
    number2 int
);

SELECT create_hypertable('audit.user_event', 'event_time', chunk_time_interval => interval '3 days', create_default_indexes => false);

ALTER TABLE  audit.user_event
  SET (timescaledb.compress,
      timescaledb.compress_orderby = 'event_time',
      timescaledb.compress_segmentby = 'session_id,event_time,text_value');

SELECT add_compression_policy('audit.user_event', INTERVAL '7 days');

CREATE INDEX ON "data"."user_event"("session_id","event_time");
