--- array-util.lua
--
-- @module util
local autil = {}

local function compareMultiType(op1, op2)
	local type1, type2 = type(op1), type(op2)
	if type1 ~= type2 then -- cmp by type
		return type1 < type2
	elseif type1 == "number" or type1 == "string" then -- type2 is equal to type1
		return op1 < op2 -- comp by default
	elseif type1 == "boolean" then
		return op1 == true
	else
		return tostring(op1) < tostring(op2) -- cmp by address
	end
end

local function genOrderedIndex(t)
	local orderedIndex = {}
	for key in pairs(t) do
		table.insert(orderedIndex, key)
	end
	table.sort(orderedIndex, compareMultiType) -- ### CANGE ###
	return orderedIndex
end

local function orderedNext(t, state)
	-- Equivalent of the next function, but returns the keys in the alphabetic
	-- order. We use a temporary ordered key table that is stored in the
	-- table being iterated.

	local key = nil
	-- print("orderedNext: state = "..tostring(state) )
	if state == nil then
		-- the first time, generate the index
		t.__orderedIndex = genOrderedIndex(t)
		key = t.__orderedIndex[1]
	else
		-- fetch the next value
		for i = 1, table.getn(t.__orderedIndex) do
			if t.__orderedIndex[i] == state then
				key = t.__orderedIndex[i + 1]
			end
		end
	end

	if key then
		return key, t[key]
	end

	-- no more value to return, cleanup
	t.__orderedIndex = nil
	return
end

function autil.orderedPairs(t)
	-- Equivalent of the pairs() function on tables. Allows to iterate
	-- in order
	return orderedNext, t, nil
end

return autil
