-- base36.lua
local base36 = {}
local util = require "util"
local fmod, floor = util.fmod, math.floor
local byte, char = string.byte, string.char
local insert, concat = table.insert, table.concat

local alphabet = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"}

--[[
local function intdiv(a, b)
	if a >= 0 then
		return floor(a / b)
	else
		return math.ceil(a / b)
	end
end
]]

local byteA = byte("A")
function base36.encodeDigits(num, digits) -- same as 4D: code_UUIDGet.lua
	local divider = 36 ^ (digits - 1)
	local ret = "" -- so small than it is better to use string than table
	while divider >= 1 do
		local digit = floor(num / divider) -- intdiv
		if digit < 10 then
			ret = ret .. tostring(digit)
		else
			ret = ret .. char(digit - 10 + byteA)
		end
		num = fmod(num, divider)
		divider = divider / 36
	end
	return ret
end

function base36.encode(num)
	-- Check for number
	if type(num) ~= "number" then
		util.printError("base36 encode parameter must be a number", 1)
	end
	-- We can only accept positive numbers
	if num < 0 then
		util.printError("base36 encode parameter must be a positive number", 1)
	end
	-- Special case for numbers less than 36
	if num < 36 then
		return alphabet[num + 1]
	end
	-- Process large numbers now
	local result = {}
	local j = 0
	while num ~= 0 do
		local i = fmod(num, 36)
		j = j + 1
		insert(result, 1, alphabet[i + 1])
		num = floor(num / 36)
	end
	return concat(result)
end

function base36.decode(b36)
	return tonumber(b36, 36)
end

return base36
