--- console.lua
-- console commands
local console = {}

local ffi = require "mffi"
local util = require "util"
local utf = require "utf"
local bit = require "bit"
local C = ffi.C

function console.getKeyPressed()
	if util.fromEditor() then
		local key = io.read(1)
		return key
	end
	if util.isWin() then
		local mode = ffi.newNoAnchor("DWORD[1]")
		local count = ffi.newNoAnchor("DWORD[1]")
		local h = C.GetStdHandle(C.STD_INPUT_HANDLE)
		if ffi.isNull(h) then
			return "" -- not a console
		end
		C.GetConsoleMode(h, mode)
		C.SetConsoleMode(h, bit.band(mode[0], bit.bnot(bit.bor(C.ENABLE_LINE_INPUT, C.ENABLE_ECHO_INPUT))))
		local c = ffi.newNoAnchor("WCHAR[6]")
		C.ReadConsoleW(h, c, 2, count, nil)
		C.SetConsoleMode(h, mode[0])
		return utf.w2u(c, 6)
	else
		-- http://lua.2524044.n2.nabble.com/How-to-get-one-keystroke-without-hitting-Enter-td5858614.html
		os.execute("stty cbreak </dev/tty >/dev/tty 2>&1")
		local key = io.read(1)
		os.execute("stty -cbreak </dev/tty >/dev/tty 2>&1");
		return key
	end
end

function console.waitKeyPressed(allowedKey)
	local alloweKeyInvert = util.invertTable(allowedKey)
	local answer, key
	repeat
		if util.fromEditor() then
			key = allowedKey[1]
		else
			key = console.getKeyPressed()
		end
		key = string.lower(key)
		answer = alloweKeyInvert[key] or false
		if not answer then
			util.beep() -- why this does not beep on first wrong answer?
		end
	until answer
	return key
end

return console
