-- lib/col.lua
local column = {}

local fn = require "fn"
local recData = require"recdata".get
local recDataSet = require"recdata".set

function column.fieldChange(col, organizationId)
	local fieldChange
	local field = col and fn.iter(col):map(function(rec) -- queryParam.field = util.objectFieldToArr(col.col, "field")
		local orgPrf = rec.organization_id and rec.organization_id[organizationId or ""]
		if orgPrf then
			if orgPrf.load == false then
				return -- skip field from load
			elseif orgPrf.field then
				if fieldChange == nil then
					fieldChange = {}
				end
				fieldChange[orgPrf.field] = rec.field
				return orgPrf.field
			end
		else
			return rec.field
		end
	end):totable()
	return field, fieldChange
end

function column.convertFieldChange(data, fieldChange)
	local val
	for fldFrom, fldTo in pairs(fieldChange) do
		for _, rec in ipairs(data) do
			val = recData(rec, fldFrom)
			recDataSet(rec, fldTo, val)
			recDataSet(rec, fldFrom, nil) -- clear loaded value, less json transfer
		end
	end
end

return column
