--- convert/json_to_json.lua
-- converts json to another json using json conversion data
-- @module json_to_json
-- todo: createNotDefinedTag
local util = require "util"
local json = require "json"
local l = require"lang".l
local execute = require "execute"
local fn = require "fn"
-- local dt = require "dt"
-- local auth = require "auth"
--

local function debugKey(rec)
	local debugKey
	if rec.from_static then
		debugKey = "from_static"
	elseif rec.from_data then
		debugKey = "from_data '" .. tostring(rec.from_data) .. "'"
	elseif rec.from_function then
		debugKey = "from_function '" .. tostring(rec.from_function) .. "'"
	elseif rec.from then
		debugKey = "from '" .. tostring(rec.from) .. "'"
	else
		debugKey = "unknown from"
	end
	return debugKey
end

local function convert(convertDefinition, inJson, option, extraDataRec)
	-- convert(tagStartCallback, convertDefinition, inJson, option, extraDataRec)
	local convertJson = convertDefinition.convert
	if type(extraDataRec) ~= "table" then
		extraDataRec = {}
	end
	-- add tables to extraDataRec
	if type(inJson) == "table" then
		extraDataRec = util.tableCombine(extraDataRec, inJson, "no-error")
	end
	-- add convertDefinition extra tags to extraDataRec
	for tag, val in pairs(convertJson) do
		if tag ~= "convert" then
			extraDataRec[tag] = val
		end
	end
	local createEmptyTag = option and option.create_empty_tag or false
	local createNotDefinedTag = option and option.create_not_defined_tag or false
	local debug = option and option.debug or false
	local count = 0
	local outAll = {}
	local out = outAll
	local errorArr = {}
	local errorLoopTag = {}

	local function tagError(tag, rec, errorType)
		if rec.from then
			tag = rec.from .. " -> " .. tag -- rec.to
			-- elseif rec.to then
			-- tag = rec.from.." -> "..rec.to
		end
		local loop
		if #errorLoopTag > 0 then
			local ret = {}
			for i, rec in ipairs(errorLoopTag) do
				ret[i] = l("%s, row %d", rec.tag, rec.row)
			end
			loop = table.concat(ret, " - ")
		end
		if errorType == "mandatory" then
			if loop then
				errorArr[#errorArr + 1] = l("no data in mandatory tag '%s', %s", tag, loop)
			else
				errorArr[#errorArr + 1] = l("no data in mandatory tag '%s'", tag)
			end
		else -- never here?
			if loop then
				errorArr[#errorArr + 1] = l("'%s' error in tag '%s', %s", errorType, tag, loop)
			else
				errorArr[#errorArr + 1] = l("'%s' error in tag '%s'", errorType, tag)
			end
		end
	end

	local function addTag(rec, value)
		if rec.not_in_use == true then
			return
		end
		local tagValue
		local tag = rec.to
		count = count + 1
		if rec.array then
			out[tag] = {} -- add new tag, start a new key/value array
			out = out[tag] -- set out to point to new array
		else
			local hasValue = true
			if value == nil or value == "" then -- empty tag value
				hasValue = false
				if rec.mandatory == true then
					tagError(tag, rec, "mandatory")
				end
			end
			if debug then
				local key = debugKey(rec)
				tagValue = key .. ": '" .. tostring(value) .. "'"
				-- elseif value == nil then
				-- this would output null to json, not in use now, not a good idea
				-- mandatory null will show error message anyway
				-- tagValue = json.jsonNull() -- userdata: "NULL"
			elseif hasValue or createEmptyTag then
				tagValue = value
			end
			if tagValue then
				out[tag] = tagValue
			end
		end
	end

	local function addDataToParameter(data, parameter)
		local ret
		if parameter and type(data) == "table" or type(parameter) == "table" then
			ret = {}
			fn.iter(parameter):each(function(key)
				if data[key] then
					ret[#ret + 1] = data[key]
				else
					local outVal
					if out then
						for tag, val in pairs(out) do
							if tag == key then
								outVal = val
								break
							end
						end
					end
					if outVal then
						ret[#ret + 1] = outVal
					else
						ret[#ret + 1] = key
					end
				end
			end)
		else
			ret = parameter
		end
		return ret
	end

	local function createOut(convertArr, dataArr)
		if extraDataRec and not util.tableIsEmpty(extraDataRec) then
			dataArr = util.tableCombine(dataArr, extraDataRec, "no-error")
		end
		local err
		dataArr._used = {}
		for _, rec in ipairs(convertArr) do
			local used = true
			if rec.from_static then
				addTag(rec, rec.from_static)

				--[[
				elseif rec.from_data then
					local data = extraDataRec[rec.from_data]
					addTag(rec, data)
				]]

			elseif rec.from_function then
				local data, funcErr = execute.runFunction(rec.from_function, dataArr, dataArr, rec.parameter) -- todo: check this, is dataArr record here?
				if funcErr then
					return nil, l("error in calling function '%s':  '%s'", tostring(funcErr), rec.from_function)
				end
				if data == nil then
					if rec.from_default then
						data = rec.from_default
					else
						return nil, l("error in calling function '%s'", rec.from_function)
					end
				elseif type(data) == "table" then
					if data[1] then
						data = data[1]
					else
						data = ""
					end
				end
				addTag(rec, data)

				--[[
				elseif rec.from_if then -- not in use in new json-format

					local data, err = execute.fromIf(rec.from_function) -- pcall(allowedFunctions[rec.from_function])
					if err then
						return nil,l("error '%s' when calling from_if '%s'",err , rec.from_function)
					end
					addTag(rec, data)
				]]

			elseif rec.from_preference then
				local data
				data, err = execute.fromPreference(rec, dataArr)
				if err then
					return nil, err
				end
				addTag(rec, data)

			elseif rec.from then
				if type(rec.from) == "string" and rec.from == "" then
					addTag(rec, rec.from)
				else
					local value = execute.getTagValue(rec.from, dataArr)
					addTag(rec, value)
					if rec.array and type(value) == "table" then
						errorLoopTag[#errorLoopTag + 1] = {tag = rec.from}
						for j, dataRec in ipairs(value) do
							errorLoopTag[#errorLoopTag].row = j
							local outPrev = out -- save current array
							out[#out + 1] = {}
							out = out[#out]
							createOut(rec.array, dataRec) -- recursive call, will set out to new array
							out = outPrev -- restore current array
						end
						table.remove(errorLoopTag)
					end
				end

			elseif rec.code then
				local saveDataArr = {}
				err = execute.runCode(rec.code, dataArr, saveDataArr, option)
				if err then
					return nil, l("error in calling code '%s':  '%s'", tostring(json.toJson(rec.code)), err)
				end
				for key, val in pairs(saveDataArr) do
					local codeRec = {key, "=", val, to = rec.to} -- , base_to = rec.base_to}
					util.printError("fixConvertRec is missing")
					-- fixConvertRec(codeRec, dataArr) -- TODO: check tjis, it's undefined
					addTag(rec, codeRec)
				end

			else
				used = false
			end
			if used then
				rec._used = true
				if createNotDefinedTag then
					dataArr._used[rec.to] = true
				end
			end
		end -- for i,rec in ipairs(convertArr) do

		if createNotDefinedTag then
			-- add all the other fields that are in data but are not in definition
			local used = dataArr._used
			for key, val in pairs(dataArr) do
				if key ~= "_used" and not used[key] then
					-- local rec = {to = key}
					-- addTag(rec, val) -- (key,val)
					out[key] = val
				end
			end
			dataArr._used = nil -- remove extra bookkeeping-field from source data
		end
	end

	createOut(convertJson, inJson, "")

	--[[
	for _,prf in ipairs(convertArr) do
		for i,row in ipairs(data) do
			ret[i] = {}
			if prf.from then
				ret[i][prf.to] = row[prf.from]
			elseif prf.from_static then
				ret[i][prf.to] = prf.from_static
			elseif prf.from_function then
				if prf.from_function[1] then -- will be nilled after first error
					if type(prf.from_function[1]) ~= "function" then
						local funcName = prf.from_function[1]
						local func = _G[funcName]
						if func then
							prf.from_function[1] = func
						else
							prf.from_function[1] = loadstring('return '..funcName..'(...)')
						end
						prf.funcName = funcName
					end
					local status,val = pcall(table.unpack(prf.from_function))
					if status == false then
						val = string.format("convert from_function '%s' returned error '%s'", prf.funcName, val)
						util.printError(val)
						prf.from_function[1] = nil -- do not run again
					else
						ret[i][prf.to] = val
					end
				end
			else
				return nil,l"convert preference '%s' does not contain from, from_static or from_function"
			end
		end
	end
	]]

	local function checkNotUsedTags(convertJson)
		for _, rec in ipairs(convertJson) do
			if rec.mandatory then
				if not rec._used then
					local data = rec.from_static or rec.from_data or rec.from_function or rec.from or l "error, no 'from_static', 'from_data', 'from_function' or 'from' -tag"
					local tag = data .. " -> " .. rec.to
					errorArr[#errorArr + 1] = l("no data found for mandatory tag '%s'", tag)
				end
			end
			if rec.array then
				checkNotUsedTags(rec.array) -- recusive call
			end
			rec._used = nil -- remove extra bookkeeping-field from source data
		end
	end
	checkNotUsedTags(convertJson)

	local err
	if #errorArr > 0 then
		err = table.concat(errorArr, "\n")
	end
	return outAll, err
end

return {convert = convert}
