-- lib/coro-thread.lua
--
-- @module coroutine
local coro = {}

local util = require "util-env"
local useCoro = true
if util.from4d() then
	useCoro = false
end
local currentThread = coroutine.running -- = coro.currentThreadFunction() -- coroutine.running
local threadIdx = {}
local threadArr = {}
local threadFreeArr = {}
local remove = table.remove
local stringFormat = string.format
local index
local fromEditor = util.fromEditor()

local threadFormatLength = 2
local threadFormat = "%" .. threadFormatLength .. "d %s"
local socketFormatLength = 2
local socketFormatOut = "%" .. socketFormatLength .. "d "
local socketFormatIn = "%" .. socketFormatLength .. "d<"
local idxStr, sockNum, sockStr, threadItem

function coro.setArgument(arg, useCoroOverride) -- this MUST be called before any other coro function
	local utilEnv = require "util-env"
	if arg[3] or useCoroOverride ~= nil then
		local useCoroParam = arg[3]
		if useCoroOverride ~= nil then
			useCoroParam = useCoroOverride
		end
		useCoroParam = useCoroParam ~= "0" and useCoroParam ~= "false" and useCoroParam ~= false
		useCoro = coro.setCoro(useCoroParam)
	else
		if utilEnv.fromEditor() then
			local env = os.getenv("LUA_COROUTINE")
			if env == "true" then
				useCoro = coro.setCoro(true)
			else
				useCoro = coro.setCoro(false)
			end
		else
			useCoro = coro.setCoro(useCoro)
		end
		--[[ 	local env = util.readUpperLevelPreferenceFile(".nc-env.json", "no-db")
		if env and env.use_coroutine ~= nil and env.use_coroutine ~= useCoro then
			useCoro = coro.setCoro(env.use_coroutine)
		end ]]
		if useCoro == false then
			coro.setCoro(useCoro)
		end
	end
	if useCoro then
		print("*** using coroutine ***")
	else
		print("*** NOT using coroutine ***")
	end
end

function coro.setCoro(val) -- this MUST be called before any other coro function
	useCoro = val
	if useCoro and util.from4d() then
		useCoro = false
	end
	currentThread = coro.currentThreadFunction() -- re-set
	if useCoro then
		coro.setThreadSocket(nil)
	else
		threadIdx = {}
		threadArr = {}
		threadFreeArr = {}
	end
	return useCoro
end

function coro.useCoro(use)
	if use == false then
		return useCoro -- useCoro, false
	end
	return useCoro
end
local auth -- delay load

function coro.threadNumber()
	-- printOrig("threadIdx: ", threadIdx)
	threadItem = currentThread()
	if threadIdx[threadItem] then
		return threadIdx[threadItem].text
	end
	return "  0  0"
end

local function setThreadIdx(thread, sock, idx)
	if fromEditor and type(thread) ~= "string" then
		thread = tostring(thread)
	end
	if sock then
		if tonumber(sock.socket) > socketFormatLength then
			if #tostring(tonumber(sock.socket)) > socketFormatLength + 1 then
				socketFormatLength = #tostring(tonumber(sock.socket)) + 1
				socketFormatOut = "%" .. socketFormatLength .. "d "
				socketFormatIn = "%" .. socketFormatLength .. "d<"
				sockStr = string.rep(" ", socketFormatLength - 1) .. "0-"
			end
		end
		if sock.host then
			sockStr = stringFormat(socketFormatOut, tonumber(sock.socket))
		else
			sockStr = stringFormat(socketFormatIn, tonumber(sock.socket))
		end
	else
		sockStr = string.rep(" ", socketFormatLength - 1) .. "0-"
	end
	threadItem = threadIdx[thread]
	if threadItem == nil then
		if sock == nil then
			threadIdx[thread] = {socketIdx = {}, socketArr = {}, ixd = 0}
		else
			threadIdx[thread] = {socketIdx = {[sock] = 1}, socketArr = {sock}, ixd = 1}
		end
		threadItem = threadIdx[thread]
	else
		if threadItem.socketIdx[sock] == nil then
			threadItem.ixd = threadItem.ixd + 1
			threadItem.socketIdx[sock] = threadItem.ixd
			threadItem.socketArr[#threadItem.socketArr + 1] = sock
		end
	end
	idxStr = threadItem.text
	if idxStr then
		if idx == nil then
			idx = tonumber(idxStr:sub(1, threadFormatLength))
		end
		sockNum = tonumber(idxStr:sub(threadFormatLength + 2, threadFormatLength + socketFormatLength + 1))
		if sockNum == nil then
			util.printError("socket format error, index string: '%s', thread format length %d, socket format length %d, socket string '%s'", idxStr, threadFormatLength, socketFormatLength, idxStr:sub(threadFormatLength + 2, threadFormatLength + socketFormatLength + 1))
			sockNum = 0
		end
		if sockNum > 0 then
			if sockNum == tonumber(sock.socket) then
				coro.printError("setThreadIdx: sockNum %d == %d sock.socket", sockNum, tonumber(sock.socket))
			else
				sockStr = idxStr:sub(threadFormatLength + 2) .. sockStr
			end
		end
	elseif idx == nil then
		idx = 0
	end
	if idx > 99 then
		if #tostring(idx) > threadFormatLength then
			threadFormatLength = #tostring(idx)
			threadFormat = "%" .. threadFormatLength .. "d %s"
		end
	end
	threadItem.text = stringFormat(threadFormat, idx, sockStr)
end

local function threadId(thread)
	if thread == nil then
		return ""
	end
	if fromEditor then
		thread = tostring(thread)
	end
	if threadIdx[thread] then
		return "thread " .. tonumber(threadIdx[thread].text:sub(1, threadFormatLength))
	end
	return tostring(thread)
end
coro.threadId = threadId

function coro.currentThreadId()
	return threadId(currentThread())
end

function coro.currentSocket()
	threadItem = currentThread()
	threadItem = threadIdx[threadItem]
	if threadItem and #threadItem.socketArr > 0 then
		threadItem = threadItem.socketArr[#threadItem.socketArr]
		if threadItem.thread then
			return threadItem
		end
	end
	return nil
end

function coro.currentThreadFunction()
	if useCoro == false then
		return function()
			return ""
		end
	end
	local running = coroutine.running
	if fromEditor then
		return function(thread_)
			return tostring(thread_ or running())
		end
	end
	return function(thread_)
		return thread_ or running()
	end
end

local function treadCreated(thread, sock, oldThread)
	if useCoro then
		if #threadFreeArr > 0 then
			index = threadFreeArr[#threadFreeArr]
			remove(threadFreeArr, #threadFreeArr)
		else
			index = #threadArr + 1
		end
		threadArr[index] = thread
		setThreadIdx(thread, sock, index)
		if oldThread and oldThread ~= thread then
			if auth == nil then
				auth = require "auth"
			end
			auth.treadCreated(oldThread, thread)
		end
	end
end
coro.treadCreated = treadCreated

function coro.setThreadSocket(sock)
	local thread = sock and sock.thread or currentThread()
	if threadIdx[thread] == nil then
		treadCreated(thread, sock) -- calls setThreadIdx()
	else
		setThreadIdx(thread, sock)
	end
end

function coro.treadClosed(thread)
	if useCoro then
		thread = currentThread(thread)
		idxStr = threadIdx[thread].text
		if idxStr == nil then
			coro.printError("thread '%s' was not found from thread idx: %s", tostring(thread), threadIdx)
			return
		end
		index = tonumber(idxStr:sub(1, 3))
		threadFreeArr[#threadFreeArr + 1] = index
		threadArr[index] = "nil" -- do not resize array, is faster
		threadIdx[thread] = nil
	end
end

return coro
