-- lib/curl-ffi.lua
-- /Users/pasi/installed/C/tls/curl/include/curl/curl.h
-- see also: https://github.com/LPGhatguy/luajit-request/blob/master/luajit-request.lua
local util = require "util"
local ffi = require "mffi"

ffi.cdef [[

	/* ftp_list_parse.dylib
		ftpparse(&fp,buf,len) tries to parse one line of LIST output.
		The line is an array of len characters stored in buf.
		It should not include the terminating CR LF; so buf[len] is typically CR.
		If ftpparse() can't find a filename, it returns 0.
		If ftpparse() can find a filename, it fills in fp and returns 1.
		fp is a struct ftpparse, defined below.
		The name is an array of fp.namelen characters stored in fp.name;
		fp.name points somewhere within buf.
	*/
	struct ftpparse{
		char *name; /* not necessarily 0-terminated */
		int namelen;
		int flagtrycwd; /* 0 if cwd is definitely pointless, 1 otherwise */
		int flagtryretr; /* 0 if retr is definitely pointless, 1 otherwise */
		int sizetype;
		long size; /* number of octets */
		int mtimetype;
		time_t mtime; /* modification time */
		int idtype;
		char *id; /* not necessarily 0-terminated */
		int idlen;
	};
	int ftpparse(struct ftpparse *fp, char *buf, int len);


	/* libcurl.4.dylib */
	/* copy from here: https://github.com/LPGhatguy/luajit-request/blob/master/luajit-curl.lua */
	struct curl_slist {
		char *data;
		struct curl_slist *next;
	};
	int curl_version();
	void *curl_easy_init();
	void curl_easy_reset(void *handle);
	int curl_easy_setopt(void *curl, int option, ...);
	int curl_easy_perform(void *curl);
	void curl_easy_cleanup(void *curl);
	char *curl_escape(const char *string, int length);
	const char *curl_easy_strerror(int CURLcode);
	struct curl_slist *curl_slist_append(struct curl_slist *, const char *);
	void curl_slist_free_all(struct curl_slist *);

	struct FtpFile {
		const char *filename;
		FILE *stream;
	};

	/* see curl.inc.in */
	typedef int64_t curl_off_t;

	enum {
		CURL_HTTP_VERSION_NONE, /* setting this means we don't care, and that we'd
															 like the library to choose the best possible
															 for us! */
		CURL_HTTP_VERSION_1_0,  /* please use HTTP 1.0 in the request */
		CURL_HTTP_VERSION_1_1,  /* please use HTTP 1.1 in the request */
		CURL_HTTP_VERSION_2_0,  /* please use HTTP 2 in the request */
		CURL_HTTP_VERSION_2TLS, /* use version 2 for HTTPS, version 1.1 for HTTP */
		CURL_HTTP_VERSION_2_PRIOR_KNOWLEDGE,  /* please use HTTP 2 without HTTP/1.1
																						 Upgrade */
		CURL_HTTP_VERSION_3 = 30, /* Makes use of explicit HTTP/3 without fallback.
																 Use CURLOPT_ALTSVC to enable HTTP/3 upgrade */
		CURL_HTTP_VERSION_LAST /* *ILLEGAL* http version */
	};

	static const int CURLAUTH_NONE = 0;
	static const int CURLAUTH_BASIC = (1<<0);

	static const int CURLE_OK = 0;
	static const int CURLOPT_PORT = 3;
	static const int CURLE_NOT_BUILT_IN = 4;
	static const int CURLOPT_VERBOSE =  41;
	static const int CURLOPT_NOPROGRESS =  43;
	static const int CURLOPT_UPLOAD =  46;
	static const int CURLE_UNKNOWN_OPTION =  48;
  static const int CURLOPT_FOLLOWLOCATION = 52;
	static const int CURLOPT_SSL_VERIFYPEER = 64;
	static const int CURLOPT_SSL_VERIFYHOST = 81;
	static const int CURLOPT_HTTP_VERSION = 84;
	static const int CURLOPT_FTP_USE_EPSV =  85;
	static const int CURLOPT_HTTPAUTH =  85;
	static const int CURLOPT_USE_SSL = 119;
	static const int CURLOPT_WRITEDATA = 10001;
	static const int CURLOPT_URL = 10002;
	static const int CURLOPT_PROXY = 10004;
	// static const int CURLOPT_USERPWD = 10005;
	static const int CURLOPT_POSTFIELDS = 10015;
	static const int CURLOPT_USERAGENT = 10018;
	static const int CURLOPT_HTTPHEADER = 10023;
	static const int CURLOPT_QUOTE = 10028;
	static const int CURLOPT_POSTQUOTE = 10039;
	static const int CURLOPT_PREQUOTE = 10093;
	static const int CURLOPT_CAPATH = 10097;
	static const int CURLOPT_ENCODING = 10102;
	static const int CURLOPT_USERNAME = 10173;
	static const int CURLOPT_PASSWORD = 10174;
	static const int CURLOPT_FROM = 10186;
  static const int CURLOPT_RCPT = 10187;
	static const int CURLOPT_WRITEFUNCTION = 20011;
	static const int CURLOPT_READFUNCTION = 20012;
	static const int CURLOPT_PROGRESSFUNCTION = 20056;
	static const int CURLOPT_HEADERFUNCTION = 20079;
	// static const int CURLOPT_XFERINFOFUNCTION = 20219;
	static const int CURLOPT_INFILESIZE_LARGE = 30115;

	/* parameter for the CURLOPT_USE_SSL option */
	typedef enum {
		CURLUSESSL_NONE,    /* do not attempt to use SSL */
		CURLUSESSL_TRY,     /* try using SSL, proceed anyway otherwise */
		CURLUSESSL_CONTROL, /* SSL for the control connection or fail */
		CURLUSESSL_ALL,     /* SSL for all communication or fail */
		CURLUSESSL_LAST     /* not an option, never use */
	} curl_usessl;
]]

local lcurl
if ffi.os == "Windows" then
	if ffi.arch == "x64" then
		util.loadDll("libeay32.dll")
		util.loadDll("ssleay32.dll")
		ffi.loadMsvcr("120")
		util.loadDll("libssh2.dll")
	end
	lcurl = util.loadDll("libcurl.dll")
	-- lparse = util.loadDll("ftp_list_parse.dll")
elseif ffi.os == "OSX" and ffi.arch == "arm64" then
	lcurl = util.loadDll("net/libcurl.4.dylib")
elseif ffi.os == "OSX" then
	lcurl = util.loadDll("libcurl.4.dylib")
	-- lparse = util.loadDll("ftp_list_parse.dylib")
else -- linux
	local ok
	ok, lcurl = pcall(ffi.load, "libcurl.so.4") -- use system libcurl.so first
	if not ok then
		lcurl = util.loadDll("libcurl.so.4")
	end
end

lcurl = lcurl or {}
return lcurl
