-- database-mysql.lua
module(..., package.seeall)

local util = require "util"
--  ffi = require "mffi"
-- local unicode = require "unicode/unicode4d"
local mysql = require "mysql" -- "luajit-mysql" -- "mysql-ffi.lua"
local l = require"lang".l
local dconv = require "dconv"

local defaultPass = "mysqlMaa"
local maxReturnRows = math.huge

function maxSaveRows()
	return 1
end

function disconnect(conn)
	conn:close()
end

function setReturnRowLimit(rows)
	maxReturnRows = rows
end

function connect(prf)
	local t = {
		host = prf.host,
		user = prf.database_user,
		pass = prf.pass or defaultPass,
		db = prf.database,
		charset = prf.charset or "utf8",
		port = prf.port, -- ~= 5432 and prf.port or nil,
		options = {
			-- MYSQL_SECURE_AUTH = false, --not supported by libmariadb
			MYSQL_OPT_READ_TIMEOUT = prf.connect_timeout -- 1
		},
		flags = {CLIENT_LONG_PASSWORD = true}
	}
	local conn, err = mysql.connect(t)
	if not err then
		-- print('mysql.connect         ', format(t, '   '), '->', conn)
		-- print('conn:change_user(     ', format(t.user), ')', conn:change_user(t.user))
		-- print('conn:select_db(       ', format(t.db), ')', conn:select_db(t.db))
		print('conn:set_multiple_statements(true)', conn:set_multiple_statements(true))
		print('conn:set_charset("utf8")', conn:set_charset(t.charset))
	end
	return conn, err
end

function execute(sqlExecute, option)
	-- sqlExecute = sqlExecute:gsub("%.name,", ".name_,")
	-- print(sqlExecute)
	local conn = option.conn -- or option.database
	local err = conn:query(sqlExecute) -- err return?
	if err then
		util.printError(l "Error in sql execute statement: " .. err .. "\n")
		return nil, err
	end
	local result = conn:store_result() -- conn:use_result()
	local rows = result:row_count()
	local cur = {rows = rows, result = result}
	return cur
end

local function rowCount(cur)
	local ret = cur.rows
	return ret
end

--[[
local function columnTypes(cur)
	local ret = cur:getcoltypes()
	return ret
end
]]

local function columnCount(cur)
	return cur.result:field_count()
end

local function columnNames(cur)
	local cols = columnCount(cur)
	local ret = util.newTable(cols, 0)
	for i = 1, cols do
		ret[i] = cur.result:field_name(i)
	end
	return ret
end

function selectionToArrayTable(cur, fieldNameArray, option)
	if not cur then
		util.printError("Cursor is nil")
		return nil
	end
	local colName = columnNames(cur)
	local colCount = #colName
	if colCount < 1 then
		util.printError("Column count < 1")
		return nil
	end
	local rows = rowCount(cur)
	local ret = util.newTable(0, colCount)
	local colTagName = util.newTable(colCount, 0)
	-- io.write("  -> columns: " ..colCount..", rows: " ..rows..", max returned rows: " ..maxReturnRows)
	-- io.flush()

	for i = 1, colCount do
		if fieldNameArray then
			colTagName[i] = fieldNameArray[i]
		else
			colTagName[i] = colName[i]
		end
		ret[colTagName[i]] = {} -- util.newTable(returnRows, 0) -- newTable USES MEMORY VERY BADDLY - if all rows do not come from db?
	end

	local returnRows = rows
	local row = 0
	local val = 0
	local returnedTbl = {}
	while returnedTbl and row < returnRows do
		row = row + 1
		if false and row % 1000 == 0 then
			io.write(row .. " ")
			io.flush()
		end
		-- https://luapower.com/mysql#resultfetchmode-row_t---true-v1-v2-...-row_t-nil
		cur.result:fetch("n", returnedTbl) -- returnedTbl
		for i = 1, colCount do
			ret[colTagName[i]][row] = returnedTbl[i]
		end
	end

	cur.result:free()

	local info = {}
	info.column_name = colTagName
	info.row_count = row
	info.row_count_total = rows
	info.column_count = colCount
	return ret, info
end

function selectionToRecordTable(cur, fieldNameArray, option)
	local sel, info = selectionToArrayTable(cur, fieldNameArray)
	return dconv.arrayTableToRecordTable(sel, info, nil, option)
end

function tableCount()
	return 0
end

function fieldCount(tableNum)
	return 0
end
