-- database-odbc_h.lua
local ffi = require "mffi"

--[[
if util.isWin() then
	ffi.cdef[-[
	typedef long            SQLINTEGER;
	// typedef void*					SQLHANDLE;
	typedef SQLINTEGER					SQLHANDLE;
	]-]
else
	ffi.cdef[-[
	typedef long            SQLINTEGER;
	typedef SQLINTEGER		SQLHANDLE;
	]-]
end
]]

-- Azure https://docs.microsoft.com/en-us/sql/relational-databases/native-client-odbc-date-time/data-type-support-for-odbc-date-and-time-improvements?view=sql-server-ver15
ffi.cdef [[
static const int SQL_SS_TIME2 = (-154);
static const int SQL_SS_TIMESTAMPOFFSET = (-155);
]]
if ffi.arch == "x64" and ffi.os == "Windows" then
	ffi.cdef [[
typedef int32_t SQLINTEGER;
typedef uint32_t SQLUINTEGER;
typedef void* SQLHANDLE;

typedef int64_t SQLLEN;
typedef uint64_t SQLULEN;
]]
else
	ffi.cdef [[
typedef long            SQLINTEGER;
typedef unsigned int    SQLUINTEGER;
typedef SQLINTEGER			 SQLHANDLE;

typedef SQLINTEGER      SQLLEN;		// #define SQLLEN          SQLINTEGER
typedef SQLUINTEGER      SQLULEN; // #define SQLULEN         SQLUINTEGER
]]
end

ffi.cdef [[
typedef short SQLSMALLINT;
typedef unsigned short SQLUSMALLINT;

typedef unsigned char   SQLCHAR;
typedef void *          SQLPOINTER;
typedef SQLSMALLINT     SQLRETURN;
// ffi_def generates osx constans

// static const unsigned long SQL_AUTOCOMMIT_OFF = 0UL;
// static const unsigned long SQL_AUTOCOMMIT_ON = 1UL;
static const uint32_t SQL_AUTOCOMMIT_OFF = 0;
static const uint32_t SQL_AUTOCOMMIT_ON = 1;
static const int SQL_BIGINT = (-5);
static const int SQL_BINARY = (-2);
static const int SQL_BIT = (-7);
static const int SQL_CHAR = 1;
static const int SQL_COMMIT = 0;
static const int SQL_DATE = 9;
static const int SQL_DECIMAL = 3;
static const int SQL_DOUBLE = 8;
static const int SQL_FLOAT = 6;
static const int SQL_INTEGER = 4;
static const int SQL_LONGVARBINARY = (-4);
static const int SQL_LONGVARCHAR = (-1);
static const int SQL_MAX_MESSAGE_LENGTH = 512;
static const int SQL_NO_DATA = 100;
static const int SQL_NO_TOTAL = (-4);
static const int SQL_NTS = (-3);
static const int SQL_NULL_DATA = (-1);
// static const long SQL_NULL_HANDLE = 0L;
static const int32_t SQL_NULL_HANDLE = 0;
static const int SQL_NUMERIC = 2;
static const int SQL_REAL = 7;
static const int SQL_ROLLBACK = 1;
static const int SQL_SMALLINT = 5;
static const int SQL_SUCCESS = 0;
static const int SQL_SUCCESS_WITH_INFO = 1;
static const int SQL_TIMESTAMP = 11;
static const int SQL_TINYINT = (-6);
static const int SQL_TYPE_DATE = 91;
static const int SQL_TYPE_TIME = 92;
static const int SQL_TYPE_TIMESTAMP = 93;
static const int SQL_VARBINARY = (-3);
static const int SQL_VARCHAR = 12;
static const int SQL_WCHAR = (-8);
static const int SQL_WLONGVARCHAR = (-10);
static const int SQL_WVARCHAR = (-9);

static const int SQL_UNSPECIFIED = 0;

static const int SQL_C_BINARY = SQL_BINARY;
static const int SQL_C_BIT = SQL_BIT;
static const int SQL_C_CHAR = SQL_CHAR;
static const int SQL_C_DOUBLE = SQL_DOUBLE;
// end ffi_def generated


/* return values from functions */
static const int SQL_ERROR                = (-1);
static const int SQL_INVALID_HANDLE       = (-2);

/* connection attributes with new names */
static const int SQL_ATTR_AUTOCOMMIT					=	102;
static const int SQL_ATTR_CONNECTION_TIMEOUT	= 113;

static const int SQL_FETCH_NEXT = 1;

static const int SQL_HANDLE_ENV             = 1;
static const int SQL_HANDLE_DBC             = 2;
static const int SQL_HANDLE_STMT            = 3;
static const int SQL_HANDLE_DESC            = 4;
// static const unsigned long SQL_OV_ODBC3	= 3UL;
static const uint32_t SQL_OV_ODBC3	= 3;
static const int SQL_ATTR_ODBC_VERSION = 200;

static const int hENV = SQL_HANDLE_ENV;
static const int hSTMT = SQL_HANDLE_STMT;
static const int hDBC = SQL_HANDLE_DBC;

typedef SQLHANDLE               SQLHENV;
typedef SQLHANDLE               SQLHDBC;
typedef SQLHANDLE               SQLHSTMT;
// typedef SQLHANDLE               SQLHDESC;

SQLRETURN SQLAllocHandle(SQLSMALLINT HandleType, SQLHANDLE InputHandle, SQLHANDLE *OutputHandle);
SQLRETURN SQLSetEnvAttr(SQLHENV EnvironmentHandle, SQLINTEGER Attribute, SQLPOINTER Value, SQLINTEGER StringLength);
SQLRETURN SQLFreeHandle(SQLSMALLINT HandleType, SQLHANDLE Handle);
SQLRETURN SQLConnect(SQLHDBC ConnectionHandle,
											SQLCHAR *ServerName, SQLSMALLINT NameLength1,
											SQLCHAR *UserName, SQLSMALLINT NameLength2,
											SQLCHAR *Authentication, SQLSMALLINT NameLength3);
SQLRETURN SQLGetDiagRec(SQLSMALLINT HandleType, SQLHANDLE Handle,
											SQLSMALLINT RecNumber, SQLCHAR *Sqlstate,
											SQLINTEGER *NativeError, SQLCHAR *MessageText,
											SQLSMALLINT BufferLength, SQLSMALLINT *TextLength);
SQLRETURN SQLSetConnectAttr(SQLHDBC ConnectionHandle,
											SQLINTEGER Attribute, SQLPOINTER Value,
											SQLINTEGER StringLength);
SQLRETURN SQLEndTran(SQLSMALLINT HandleType, SQLHANDLE Handle, SQLSMALLINT CompletionType);
SQLRETURN SQLDisconnect(SQLHDBC ConnectionHandle);
SQLRETURN SQLPrepare(SQLHSTMT StatementHandle,
																	SQLCHAR *StatementText, SQLINTEGER TextLength);
SQLRETURN SQLExecute(SQLHSTMT StatementHandle);
SQLRETURN SQLExecDirect(SQLHSTMT          StatementHandle,
                              SQLCHAR      *StatementText,
                              SQLINTEGER        TextLength);
SQLRETURN SQLNumResultCols(SQLHSTMT StatementHandle,
																	SQLSMALLINT *ColumnCount);
SQLRETURN SQLDescribeCol(SQLHSTMT StatementHandle,
																	SQLUSMALLINT ColumnNumber, SQLCHAR *ColumnName,
																	SQLSMALLINT BufferLength, SQLSMALLINT *NameLength,
																	SQLSMALLINT *DataType, SQLULEN *ColumnSize,
																	SQLSMALLINT *DecimalDigits, SQLSMALLINT *Nullable);
SQLRETURN SQLFetch(SQLHSTMT StatementHandle);
SQLRETURN SQLRowCount(SQLHSTMT StatementHandle,
                                   SQLLEN *RowCount);
SQLRETURN SQLGetData(SQLHSTMT StatementHandle,
                                  SQLUSMALLINT ColumnNumber, SQLSMALLINT TargetType,
                                  SQLPOINTER TargetValue, SQLLEN BufferLength,
                                  SQLLEN *StrLen_or_Ind);
SQLRETURN SQLCloseCursor(SQLHSTMT StatementHandle);
SQLRETURN SQLFetchScroll  (
                  SQLHSTMT          StatementHandle,
                  SQLSMALLINT       FetchOrientation,
                  SQLINTEGER        FetchOffset);
]]

return {}

--[[
typedef struct {
	short      closed;
	int        conn_counter;
	SQLHENV    henv;               /* environment handle */
} env_data;


typedef struct {
	short      closed;
	int        cur_counter;
	int        env;                /* reference to environment */
	SQLHDBC    hdbc;               /* database connection handle */
} conn_data;


typedef struct {
	short      closed;
	int        conn;               /* reference to connection */
	int        numcols;            /* number of columns */
	int        coltypes, colnames; /* reference to column information tables */
	SQLHSTMT   hstmt;              /* statement handle */
} cur_data;
]]
