--- lib/db/dschema-4d.lua
-- only-local table and field names
-- @module db
local dschema4d = {}

local util = require "util"
local dschema = require "dschema"
local toLocal, externalTablePrefix = dschema.toLocal, dschema.externalTablePrefix
local peg = require "peg"
local match = peg.match
local variablePattern = peg.capture(peg.least(peg.range("az"), 1)) * peg.pattern "_" * peg.most("a", 1) * peg.set("ilrsatdhfgxp") * peg.capture(peg.other(peg.define.anyWhiteSpace, 1))
-- ilrstdhfgp = int, long, real, string, alpha, text, date, time, boolean, picture, blob, pointer, see: 4D function _var_ TypeStrToType()
local fieldPattern = peg.pattern "[" * peg.capture(peg.other("]", 2)) * peg.pattern "]" * peg.capture(peg.other(peg.define.anyWhiteSpace, 1))

local prefix, name
local function variableNameToLocalField(variableName)
	if variableName == nil then
		util.printError("variableNameToLocalField parameter variableName is nil")
		return variableName
	end
	prefix, name = match(variablePattern, variableName)
	if prefix and name then
		if prefix == "in" then
			prefix = "inv"
			--[[ elseif prefix == "todo" then
			prefix = "do" ]]
		end
		return toLocal(prefix .. "." .. name:lower(), "4d", "no-error")
	end
	prefix, name = match(fieldPattern, variableName)
	if prefix and name then
		prefix = externalTablePrefix(prefix:lower(), "4d")
		if prefix == nil then
			return
		end
		return toLocal(prefix .. "." .. name:lower(), "4d", "no-error")
	end
end
dschema4d.variableNameToLocalField = variableNameToLocalField

local function constantToLocalField(constantName)
	prefix, name = peg.split(constantName, "_k")
	if prefix and name then
		prefix = peg.removeFromStartEnd(prefix, " ")
		name = peg.removeFromStartEnd(name, " ")
		if prefix == "in" then
			prefix = "inv"
		end
		prefix = externalTablePrefix(prefix:lower(), "4d")
		if prefix == nil then
			return
		end
		return toLocal(prefix .. "." .. name:lower(), "4d", "no-error")
	end
end
dschema4d.constantToLocalField = constantToLocalField

--[[
local function constantToName(constantName)
	local startPos = constantName:find("[A-Z]")
	if startPos then
		local fldName = constantName:sub(startPos)
		fldName = fldName:gsub("_", " ")
		-- fldName = lang.Current(fldName)
		return fldName
	else
		return constantName
	end
end
dschema4d.constantToName = constantToName
]]

return dschema4d
