--- lib/db/dschemafld.lua
-- table paths and field names parsed to locf and extf[schema] tables
-- @module db
local dschemafld = {}

local util = require "util"
local peg = require "peg"
local l = string.format -- we can't use l = require"lang".l because it causes recursive calls while creating field structure
local fs = require "fs"
local fn = require "fn"
local dprf = require "dprf"
local json = require "json"
local dconn = require "dconn"

local recordTypeSeparator = "-"
local schemaSeparator = "/"
local linkSeparator = " > "
dschemafld.recordTypeSeparator = recordTypeSeparator
dschemafld.schemaSeparator = schemaSeparator
dschemafld.linkSeparator = linkSeparator
local printLinkFind = false
local defaultFieldPrf, groupPrfLocal, fieldTypePrf, allowedFieldType, defaultFieldPrfName
-- local addJsonFieldToLocalTableJson = {}

local locf
local defaultDatabaseSchema = ""
local extf = {}
local loc = {}
loc.debug = false
loc.multiLinkPreferenceFileName = "table/prf/all_table_link_chain.json"
loc.multiLinkReadFromFile = false
loc.multiLinkSaveToFile = false
loc.extraFieldSaveToFile = false
loc.logSave = true
loc.tablePairJson = {name = "table/prf/table_pair.json"}

local function reverseKey(key)
	local linking, linked = peg.split(key, linkSeparator)
	if peg.found(linking, recordTypeSeparator) then
		local linkingTable, recType = peg.split(linking, recordTypeSeparator)
		return linked .. recordTypeSeparator .. recType .. linkSeparator .. linkingTable
	end
	return linked .. linkSeparator .. linking
end

local relationErrorCount = 0
local function addFieldRelation(lf, tableRec, fieldRec, foreignKeyRec, foreignKeyIdx, schema, option)
	if fieldRec == nil then
		relationErrorCount = relationErrorCount + 1
		util.printRed("%d. schema '%s', table '%s' linking field '%s' is not valid, preference '%s'", relationErrorCount, schema, tableRec.table_name, tostring(foreignKeyRec.linking_field), tableRec.preference_name)
		return false
	end
	if lf[foreignKeyRec.linked_table] == nil then
		util.printRed("%d. schema '%s', table '%s' linked table '%s' is not valid, preference '%s'", relationErrorCount, schema, tableRec.table_name, tostring(foreignKeyRec.linked_table), tableRec.preference_name)
		return false
	end
	local prefix = lf[foreignKeyRec.linked_table].table_prefix .. "."
	local linkedFieldRec = lf[prefix .. foreignKeyRec.linked_field]
	if linkedFieldRec == nil then
		relationErrorCount = relationErrorCount + 1
		util.printRed("%d. schema '%s', table '%s' linked field '%s' is not valid, preference '%s'", relationErrorCount, schema, tableRec.table_name, tostring(foreignKeyRec.linked_field), tableRec.preference_name)
		return false
	end
	local linkedTableRec = linkedFieldRec.table_rec
	local linkedTableRec2 = lf[foreignKeyRec.linked_table]
	local continue = false
	if foreignKeyRec.linking_record_type == nil then
		if tableRec.table_name == "sales_order" then
			foreignKeyRec.linking_record_type = tableRec.record_type_arr[1]
		end
		foreignKeyRec.linking_record_type = tableRec.record_type_arr[1]
	end
	if foreignKeyRec.linked_record_type == nil then
		foreignKeyRec.linked_record_type = linkedTableRec2 and linkedTableRec2.record_type_arr[1]
	end

	--[[
		if fldRec.foreign_key then
			if not fldRec.foreign_key[1] then
				localFLdWarningCount = localFLdWarningCount + 1
				util.printRed(
					"%d. local field '%s', external field '%s' - schema/record_type '%s' foreign_key array is empty, preference '%s'",
					localFLdWarningCount,
					fldRec.local_field or "nil",
					fieldName,
					extKey,
					tableRec.preference_name
				)
			else
				if fldRec.foreign_key[1].link_name then
					extKey = schema..recordTypeSeparator..fldRec.foreign_key[1].link_name
				elseif peg.found(prfName, "sales_order.json") then
					extKey = extKey..""
				end
			end
		end
	]]
	if linkedTableRec ~= linkedTableRec2 then
		relationErrorCount = relationErrorCount + 1
		util.printRed("%d. schema '%s', table '%s' linking field '%s', relation linked table '%s', is not same as linked field table '%s', preference '%s'", relationErrorCount, schema, tableRec.table_name, fieldRec.field, linkedTableRec2.table_name or foreignKeyRec.linked_table or "?", linkedTableRec.table_name or "?", tableRec.preference_name)
	elseif not foreignKeyRec.linked_table then
		relationErrorCount = relationErrorCount + 1
		util.printRed("%d. schema '%s', table '%s' linking field '%s', relation linked table '%s', '%s' does not exist, preference '%s'", relationErrorCount, schema, tableRec.table_name, fieldRec.field, foreignKeyRec.linked_table, foreignKeyRec.linked_field, tableRec.preference_name)
	elseif not foreignKeyRec.link_type then
		relationErrorCount = relationErrorCount + 1
		util.printRed("%d. schema '%s', table '%s' linking field '%s', relation link type for table '%s', '%s' does not exist, preference '%s'", relationErrorCount, schema, tableRec.table_name, fieldRec.field, foreignKeyRec.linked_table, foreignKeyRec.linked_field, tableRec.preference_name)
	elseif not linkedFieldRec then
		relationErrorCount = relationErrorCount + 1
		util.printRed("%d. schema '%s', table '%s' linking field '%s', relation linked record '%s', '%s' does not exist, preference '%s'", relationErrorCount, schema, tableRec.table_name, fieldRec.field, foreignKeyRec.linked_table, foreignKeyRec.linked_field, tableRec.preference_name)
	elseif foreignKeyRec.linked_table ~= linkedFieldRec.table_rec.table_name then
		relationErrorCount = relationErrorCount + 1
		util.printWarning("%d. schema '%s', table '%s' linking field '%s', linked field '%s' table '%s' is not same as relation linked table '%s', preference '%s'", relationErrorCount, schema, tableRec.table_name, fieldRec.field, foreignKeyRec.linked_field, linkedFieldRec.table_rec.table_name, foreignKeyRec.linked_table, tableRec.preference_name)
	else
		continue = true
	end
	if option == "only-check" then
		return continue
	end
	if continue == false then
		-- util.closeProgram()
		return
	else
		local linkRec = {
			default_link = foreignKeyIdx == 1,
			link_type = foreignKeyRec.link_type,
			-- code = fieldRec.code, -- not in use now
			linking_rec = fieldRec,
			linking_table = tableRec.table_name,
			linking_field = fieldRec.field, -- co.name
			info = foreignKeyRec.info,
			link_field = foreignKeyRec.link_field,
			extra_link_field = foreignKeyRec.extra_link_field,
			linking_record_type = foreignKeyRec.linking_record_type,
			linked_rec = linkedFieldRec,
			linked_table = foreignKeyRec.linked_table,
			linked_field = linkedTableRec.table_prefix .. "." .. foreignKeyRec.linked_field,
			linked_record_type = foreignKeyRec.linked_record_type,
			join = foreignKeyRec.join
		}
		if foreignKeyRec.extra_link_field then
			local arr = {}
			for i, rec in ipairs(foreignKeyRec.extra_link_field) do
				arr[i] = {linking = tableRec.table_prefix .. "." .. rec.linking, linked = linkedTableRec.table_prefix .. "." .. rec.linked, join = rec.join}
			end
			foreignKeyRec.extra_link_field = arr
		end
		if not fieldRec.link then
			fieldRec.link = {}
		end
		fieldRec.link[#fieldRec.link + 1] = linkRec
		tableRec.link[#tableRec.link + 1] = linkRec
		linkedTableRec = lf[linkRec.linked_table]
		if linkRec.linked_record_type ~= "" and not linkedTableRec.record_type[linkRec.linked_record_type] then
			relationErrorCount = relationErrorCount + 1
			util.printRed("%d. schema '%s', table '%s' linking field '%s', linked field '%s', table '%s' record type array does not contain linked table '%s' record type '%s', preference '%s'", relationErrorCount, schema, tableRec.table_name, fieldRec.field, foreignKeyRec.linked_field, linkedFieldRec.table_rec.table_name, foreignKeyRec.linked_table, linkRec.linked_record_type, tableRec.preference_name)
			if not loc.tablePairJson[schema].table_record_type[linkRec.linked_table] then
				loc.tablePairJson[schema].table_record_type[linkRec.linked_table] = {}
			end
			local len = #loc.tablePairJson[schema].table_record_type[linkRec.linked_table]
			loc.tablePairJson[schema].table_record_type[linkRec.linked_table][len + 1] = linkRec.linked_record_type
			linkedTableRec.record_type[linkRec.linked_record_type] = true
			local recTypeField = lf[linkedTableRec.table_prefix .. ".record_type"]
			if recTypeField then
				loc.tablePairJson[schema].table_allowed_record_type[linkRec.linked_table] = recTypeField.allowed_value
			end
		end
		--[[
		local linkKey
		if linkRec.linked_rec.table_rec.local_table then
			linkKey = linkRec.linked_rec.table_rec.local_table..recordTypeSeparator..linkRec.linked_record_type -- linkRec.linking_record_type
		else
			linkKey = linkRec.linked_table
		end
		if not tableRec.link[linkKey] then
			tableRec.link[linkKey] = {}
		end
		if linkRec.default_link then
			local prevLink = tableRec.link[linkKey][1]
			if prevLink and prevLink.default_link then
				util.printError("table '%s' field '%s' already has a default link to table '%s', please fix json", linkRec.linking_table,linkRec.linking_field, linkRec.linked_table)
				util.closeProgram()
			end
			table.insert(tableRec.link[linkKey], 1, linkRec)
		else
			tableRec.link[linkKey][#tableRec.link[linkKey] + 1] = linkRec
		end
		]]
		local key
		if linkRec.linking_record_type == "" then
			key = linkRec.linking_table .. linkSeparator .. linkRec.linked_table
			reverseKey = linkRec.linked_table .. linkSeparator .. linkRec.linking_table
		else
			key = linkRec.linking_table .. recordTypeSeparator .. linkRec.linking_record_type .. linkSeparator .. linkRec.linked_table
			reverseKey = linkRec.linked_table .. recordTypeSeparator .. linkRec.linking_record_type .. linkSeparator .. linkRec.linking_table
		end
		local prevRec = lf.tablePair[key]
		if prevRec == nil or linkRec.default_link and not prevRec.default_link then
			-- [[ -- these warn about link exists, and there is
			if loc.debug and prevRec then
				util.printInfo("schema '%s', link key '%s', \n prev: linking: [table '%s', field '%s', record type '%s'], linked: [table '%s', field '%s', record type '%s'] linked record exists\n  new: linking: [table '%s', field '%s', record type '%s'], linked: [table '%s', field '%s', record type '%s'] linked record exists, creating default link, preference '%s'\n", schema, key, prevRec.linking_table,
				               prevRec.linking_field, prevRec.linking_record_type, prevRec.linked_table, prevRec.linked_field, prevRec.linked_record_type, linkRec.linking_table, linkRec.linking_field, linkRec.linking_record_type, linkRec.linked_table, linkRec.linked_field, linkRec.linked_record_type, tableRec.preference_name)
			end
			lf.tablePair[key] = linkRec
			lf.tablePair[reverseKey] = linkRec
			local pairRec = {linking_field = linkRec.linking_field, linked_field = linkRec.linked_field, extra_link_field = linkRec.extra_link_field}
			if linkRec.linking_record_type and linkRec.linking_record_type ~= "" then
				pairRec.linking_record_type = linkRec.linking_record_type
			end
			if linkRec.linked_record_type and linkRec.linked_record_type ~= "" then
				pairRec.linked_record_type = linkRec.linked_record_type
			end
			if linkRec.join and linkRec.join ~= "" then
				pairRec.join = linkRec.join
			end
			if linkRec.link_field then
				key = key .. "." .. linkRec.link_field
			end
			loc.tablePairJson[schema].pair[key] = pairRec

		elseif loc.debug and prevRec and foreignKeyIdx > 1 and prevRec.linking_field ~= linkRec.linking_field then
			-- elseif loc.debug and prevRec and not prevRec.default_link and prevRec.linking_field ~= linkRec.linking_field then
			util.printInfo("schema '%s', link key '%s', \n prev: linking: [table '%s', field '%s', record type '%s'], linked: [table '%s', field '%s', record type '%s'] linked record exists\n  new: linking: [table '%s', field '%s', record type '%s'], linked: [table '%s', field '%s', record type '%s'] linked record exists, preference '%s'\n", schema, key, prevRec.linking_table, prevRec.linking_field,
			               prevRec.linking_record_type, prevRec.linked_table, prevRec.linked_field, prevRec.linked_record_type, linkRec.linking_table, linkRec.linking_field, linkRec.linking_record_type, linkRec.linked_table, linkRec.linked_field, linkRec.linked_record_type, tableRec.preference_name)
		elseif loc.debug and lf.tablePair[reverseKey] and not lf.tablePair[reverseKey].default_link and lf.tablePair[reverseKey].linking_field ~= linkRec.linking_field then
			util.printInfo("schema '%s', link reverse key '%s', linking: [table '%s', field '%s', new field '%s', record type '%s'], linked: [table '%s', field '%s', record type '%s'] reverse linked record exists, preference '%s'", schema, reverseKey, linkRec.linking_table, linkRec.linking_field, linkRec.linking_record_type, linkRec.linked_table, linkRec.linked_field, linkRec.linked_record_type,
			               tableRec.preference_name)
			-- ]]
		end
		if not loc.tablePairJson[schema].linking[linkRec.linking_table] then
			loc.tablePairJson[schema].linking[linkRec.linking_table] = {}
		end
		if util.table_item_index(linkRec.linking_field, loc.tablePairJson[schema].linking[linkRec.linking_table]) == nil then
			loc.tablePairJson[schema].linking[linkRec.linking_table][#loc.tablePairJson[schema].linking[linkRec.linking_table] + 1] = linkRec.linking_field
		end
		lf.tablePair[key] = linkRec
	end
end

local tablePairPrefExists, tablePairPrefName
local function addRelation(lf, schema)
	if tablePairPrefExists == nil then --  and not util.fromEditor()
		tablePairPrefName = "preference/table/prf/table_pair.json"
		tablePairPrefExists = fs.fileExists(tablePairPrefName)
		if not tablePairPrefExists then
			util.printRed("table pair preference '%s' does not exist", tablePairPrefName)
		end
	end
	lf.tablePair = {}
	-- will be set later in dschemafld.linkRec()
	-- 	lf.tablePairLink
	--  lf.tablePairLinkReverse -- set later
	loc.tablePairJson[schema] = {
		table_record_type = {},
		table_allowed_record_type = {},
		pair = {},
		linking = {}
		-- linking_many = {}
	}

	for _, tableRec in ipairs(lf._table) do
		--[[ if tableRec.table_pair then
			for key, val in pairs(tableRec.table_pair) do
				loc.tablePairJson[schema].pair[key] = val
			end
		end ]]
		for _, fieldRec in ipairs(tableRec._field) do
			if fieldRec.foreign_key then -- field foreign_key
				for foreignKeyIdx, foreignKeyRec in ipairs(fieldRec.foreign_key) do
					-- foreign key is array of records, same field can be used to link to many tables using many record types
					addFieldRelation(lf, tableRec, fieldRec, foreignKeyRec, foreignKeyIdx, schema)
				end
			end
		end
	end
	if not tablePairPrefExists then
		-- todo: write only if has changes to loaded, should we ceate this at all here if there are no changes?
		-- todo: if anything changes then we need to call tool/create_all_link_chains.lua
		fs.writeFile(tablePairPrefName, loc.tablePairJson, loc.logSave) -- save all schemas, not just first schema
	end
end

local function currentFieldTableStructure(schema)
	if not locf then
		locf = dschemafld.fieldTableStructure()
	end
	if schema ~= defaultDatabaseSchema then
		if not extf[schema] then
			extf[schema] = dschemafld.fieldTableStructure(schema)
		end
		return extf[schema]
	end
	return locf
end

local function cachedLink(lf, linkingTable, linkingRecordType, linkedTable, tableRecordType, schema)
	if lf.tablePairLink == nil then
		local ret = fs.readFile(util.mainPath() .. loc.multiLinkPreferenceFileName) or "{}"
		ret = json.fromJson(ret)
		if loc.multiLinkReadFromFile and ret then
			lf.tablePairLink = ret[schema .. "/link"] or {}
			lf.tablePairLinkReverse = {}
			for key, val in pairs(lf.tablePairLink) do
				lf.tablePairLinkReverse[reverseKey(key)] = val
			end
		else
			lf.tablePairLink = {}
			lf.tablePairLinkReverse = {}
		end
	end
	-- create link cache key in a way that tableRecordType -tables and keys are sorted
	local key = ""
	local arr = {}
	for tbl in pairs(tableRecordType) do
		arr[#arr + 1] = tbl
	end
	table.sort(arr)
	for _, tbl in ipairs(arr) do
		local val = tableRecordType[tbl]
		table.sort(val)
		key = key .. " / " .. tbl .. ":" .. table.concat(val, ",")
	end
	key = linkingTable .. linkSeparator .. linkedTable .. key
	local link = lf.tablePairLink[key]
	if link then
		util.printOk("* return cached multi-level link '%s'", key)
		return link, key -- return cached more-than-1 -level link pair
	else
		link = lf.tablePairLinkReverse[key]
		if link then
			util.printOk("* return cached reversed multi-level link '%s'", key)
			return link, key -- return cached more-than-1 -level link pair
		end
		link = lf.tablePair[key]
		if not link then
			if linkingRecordType == "" then
				reverseKey = linkedTable .. linkSeparator .. linkingTable
			else
				reverseKey = linkedTable .. recordTypeSeparator .. linkingRecordType .. linkSeparator .. linkingTable
			end
			link = lf.tablePair[reverseKey]
		end
		if not link and linkingRecordType ~= "" then -- lf.tablePair contains links usually without record type, lf.tablePairLink always uses record type
			link = lf.tablePair[linkingTable .. linkSeparator .. linkedTable]
			if not link then
				link = lf.tablePair[linkedTable .. linkSeparator .. linkingTable]
			end
		end
		if link then
			util.printOk("* return cached one-level link '%s'", key)
			return link, key
		end
	end
	return nil, key
end

function dschemafld.linkRec(linkedTable_, linkingTable_, doReverseSearch, schema_)
	-- linkedTable_ and linkingTable_ may be in local or external sql names
	-- first test if cached link is found
	local connQuery = dconn.query()
	local linkingTable, linkingRecordType, linkedTable = connQuery.table, connQuery.recordType, linkedTable_
	if linkingTable == linkedTable then -- and linkingRecordType == "" then
		return
	end
	if connQuery.tableRecordType == nil then
		util.printError("tableRecordType is nil you may need to install psqlodbc")
		return
	end
	local tableRecordType, schema = connQuery.tableRecordType, schema_ or connQuery.schema
	local recType = tableRecordType[linkingTable] and tableRecordType[linkingTable][1]
	if linkingRecordType ~= recType then -- just test that tableRecordType is corrently formed
		return nil, l("schema '%s', linking table '%s', linked table '%s', linkingRecordType '%s' is not same as tableRecordType[linkingTable][1] '%s'", schema, linkingTable, linkedTable, linkingRecordType, tostring(recType))
	end
	if linkingTable_ then
		linkingTable = linkingTable_
		if tableRecordType[linkingTable] then
			linkingRecordType = tableRecordType[linkingTable][1]
		else
			linkingRecordType = "" -- TODO: is this ok?
		end
	end
	local usingExternalName = false
	local lf = currentFieldTableStructure(schema)
	if lf == nil then
		util.printError("schema '%s' could not be created", tostring(schema))
		return
	end
	local link, key = cachedLink(lf, linkingTable, linkingRecordType, linkedTable, tableRecordType, schema)
	if link and printLinkFind then
		util.printInfo("* cached link found, key '%s', not used until cache is fixed", key)
		-- util.printOk("* cached link found, key '%s'", key)
		-- return link
	end
	-- default link was not saved, find links
	local linkingTableRec = locf[linkingTable] -- try local name
	if schema == "" then
		lf = locf
	else
		if lf[linkingTable] and lf[linkedTable] then
			-- can't change reverse direction here like in locf -case (below: if not linkingTableRec2 then...), just  search and do reverse search later if nothing was found, this is ok situation
			--[[if not lf[linkedTable] then
				return nil, l("schema '%s', relation linked table '%s' does not exist", schema, tostring(linkedTable))
			end]]
			--[[if linkingTableRec and locf[linkedTable] then -- linkingTable may be same name on both schemas, test both
				util.printWarning(
					"relation linking table '%s' and linked table '%s' both exist in local and external schemas, using external schema '%s'",
					linkingTable,
					linkedTable,
					schema
				)
			end]]
			usingExternalName = true -- TODO: is this ok, should we handle this with record types in external too?
			linkingTableRec = lf[linkingTable] -- find rec from external schema
		else
			-- move from local to external rec as soon as possible
			local linkingTableRec2 = linkingTableRec and linkingTableRec.external and linkingTableRec.external[schema .. recordTypeSeparator .. linkingRecordType]
			if not linkingTableRec2 then
				linkingTableRec2 = locf[linkedTable]
				if linkingTableRec2 then -- reverse the order
					if doReverseSearch ~= false then
						util.printOk("* changing reverse key '%s' to key '%s'", key, reverseKey)
						local mainLinkChain, err = dschemafld.linkRec(linkingTable_ or linkingTable, linkedTable_, false) -- reverse search
						return mainLinkChain, err
					end
				end
				return nil, l("schema '%s', link '%s' was not found", schema, key)
				--[[ -- should not use this (?)
				linkingTableRec2 = linkingTableRec.external[schema..recordTypeSeparator]
				if linkingTableRec2 then
					util.printError("linkingTableRec.external["..schema..recordTypeSeparator..linkingRecordType"] was not found but linkingTableRec.external["..schema.."/] was found")
				end
				--]]
			end
			linkingTableRec = linkingTableRec2 -- note: changes linkingTableRec
		end
		linkingTable = linkingTableRec and linkingTableRec.table_name -- change linking table name to external
	end
	if not linkingTableRec then
		return nil, l("schema '%s', relation linking table '%s' does not exist", schema, linkingTable)
	end
	--[[ if false and connQuery.table == linkedTable and linkingRecordType == linkingTableRec.local_record_type then
		-- if linkingTable == linkedTable and linkingRecordType == linkingTableRec.local_record_type then
		return nil, nil, linkingTableRec
		--[=[
		local mainLinkChain = {}
		-- mainLinkChain.default = linkingTableRec
		mainLinkChain.linked_record_type = linkingTableRec.local_record_type -- dschemasql/nameChange() uses this field
		--[==[ mainLinkChain.min_length = 0
		mainLinkChain.max_length = 0
		mainLinkChain.link_chain_count = 0 --]==]
		return mainLinkChain ]=]
	end ]]
	-- start finding all possible link routes to linkedTable and add them to lf.tablePairLink
	local recursionUsedTable = {}
	local mainLinkChain = {link = {}}
	local linkedTableExternal
	if not usingExternalName and schema ~= defaultDatabaseSchema then
		linkedTableExternal = locf[linkedTable] and locf[linkedTable].external
	end
	local linkedTableNameExternal = linkedTable
	local linkedTableRec, prevLinkedRecordType

	--[[
	local function inRecordTypeArray(tbl, recordType)
		if not tableRecordType[tbl] then
			return false
		end
		for _, recType in ipairs(tableRecordType[tbl]) do
			if recType == recordType then
				return true
			end
		end
		return false
	end
	]]
	local function findLink(linkArr, level, tableName, linkChain, linkName)
		if printLinkFind then
			util.print(string.rep("  ", level) .. "%d. table '%s'", level, linkName or tableName or "table name is nil!")
		end
		if tableName == nil then
			return l("findLink: table name is nil")
		end
		recursionUsedTable[tableName] = true
		local linkedTableAdded = false
		local localLinkedTable
		for i, linkRec in ipairs(linkArr) do
			if linkedTableExternal then
				localLinkedTable = linkRec.linked_rec.table_rec.local_table
				if linkRec.linked_record_type ~= prevLinkedRecordType or tableRecordType[localLinkedTable] then
					if tableRecordType[localLinkedTable] then
						prevLinkedRecordType = tableRecordType[localLinkedTable][1]
					else
						prevLinkedRecordType = linkRec.linked_record_type
					end
					linkedTableRec = linkedTableExternal[schema .. recordTypeSeparator .. prevLinkedRecordType]
					if linkedTableRec then
						linkedTableNameExternal = linkedTableRec.table_name
					else
						linkedTableNameExternal = linkedTable
					end
					if linkedTableNameExternal ~= linkedTable then
						if printLinkFind then
							util.printOk(string.rep("  ", level) .. " %d. changed linkedTableNameExternal from '%s' to '%s'", level, linkedTable, linkedTableNameExternal)
						end
					end
				end
			end
			if linkRec.linked_table == linkedTableNameExternal then
				if linkedTableAdded then
					if printLinkFind then
						util.printInfo(string.rep("  ", level) .. " %d. table '%s', link ('%s/%s - %s/%s', default: %s) - linked table was added", level, tableName, linkRec.linking_field, linkRec.linking_record_type, linkRec.linked_field, linkRec.linked_record_type, linkRec.default_link)
					end
				else
					linkedTableAdded = true
					local chosenLink = linkRec
					local linkRec2
					for j = i + 1, #linkArr do -- find all other links in this table to same linked table and choose which one is the correct link
						linkRec2 = linkArr[j]
						if linkRec2.linked_table == linkedTableNameExternal then
							if linkRec2.linking_record_type == linkingRecordType then -- or inRecordTypeArray(linkRec2.linking_table, linkRec2.linking_record_type) then
								if printLinkFind then
									if chosenLink.default_link then
										util.print(string.rep("  ", level) .. " %d. table '%s', matching link type ('%s/%s - %s/%s', default: %s)", level, tableName, linkRec2.linking_field, linkRec2.linking_record_type, linkRec2.linked_field, linkRec2.linked_record_type, linkRec2.default_link)
									else
										util.print(string.rep("  ", level) .. " %d. table '%s', matching link type  '%s/%s - %s/%s', default: %s", level, tableName, linkRec2.linking_field, linkRec2.linking_record_type, linkRec2.linked_field, linkRec2.linked_record_type, linkRec2.default_link)
									end
								end
								if linkRec2.default_link then
									-- for example in invoice use always default inv.company_id and not inv.delivery_company_id
									if not chosenLink.default_link then
										chosenLink = linkRec2
										--[[
									else
										util.printWarning("linking table '%s', record type '%s', linked table '%s', linking field '%s': default link already exists, using default link '%s'",
											linkingTable,
											linkingRecordType,
											linkedTable,
											linkRec2.linking_field,
											chosenLink.linking_field) ]]
									end
								elseif not chosenLink.default_link then
									chosenLink = linkRec2
								end
							elseif linkRec2.linking_record_type == "" then -- is this "" allowed any more?
								if printLinkFind then
									if chosenLink.default_link then
										util.print(string.rep("  ", level) .. " %d. table '%s', empty link type ('%s/%s - %s/%s', default: %s)", level, tableName, linkRec2.linking_field, linkRec2.linking_record_type, linkRec2.linked_field, linkRec2.linked_record_type, linkRec2.default_link)
									else
										util.print(string.rep("  ", level) .. " %d. table '%s', empty link type  '%s/%s - %s/%s', default: %s", level, tableName, linkRec2.linking_field, linkRec2.linking_record_type, linkRec2.linked_field, linkRec2.linked_record_type, linkRec2.default_link)
										chosenLink = linkRec2
									end
								end
								-- else -- if linkRec.linking_record_type is not exact or default "", then we don't add that link at all
							end
						end
					end
					-- add found link chain to mainLinkChain.link
					local linkChain2 = {}
					for pos, linkChainRec in ipairs(linkChain) do
						linkChain2[pos] = util.cloneShallow(linkChainRec)
					end
					linkChain2[#linkChain2 + 1] = util.cloneShallow(chosenLink)
					mainLinkChain.link[#mainLinkChain.link + 1] = linkChain2
					if printLinkFind then
						util.printOk(string.rep("  ", level) .. "%d. table '%s', linking field '%s', linked record type '%s', link chain length: %d", level, tableName, chosenLink.linking_field, chosenLink.linked_record_type, #linkChain2)
					end
				end
			elseif not recursionUsedTable[linkRec.linked_table] and #linkRec.linked_rec.table_rec.link > 0 then
				-- prevent recursion before recursive call
				linkChain[#linkChain + 1] = linkRec -- push
				local err = findLink(linkRec.linked_rec.table_rec.link, level + 1, linkRec.linked_table, linkChain, linkRec.linking_field .. " -> " .. linkRec.linked_table) -- recursive call
				if err then
					return err
				end
				table.remove(linkChain) -- pop
			end
		end
		-- util.print(string.rep("  ", level).."%d. table '%s', link count: %d", level, tableName, #linkChain)
		if printLinkFind then
			util.print(string.rep("  ", level + 1) .. "- table '%s', link chain length: %d", tableName, #linkChain)
		end
		return -- no error
	end

	-- linkTableRecArr first record is default link
	if printLinkFind then
		util.printInfo("\n0. link '%s' search start", key)
	end
	local err = findLink(linkingTableRec.link, 1, linkingTable, {})
	if err then
		return err
	end
	-- if #mainLinkChain.link > 0 then
	if printLinkFind then
		util.print("0. link '%s' search end, link chain count: %d", key, #mainLinkChain.link)
	end
	--[[ else
		util.print("0. link '%s' search end, link chain count: %d", key, #mainLinkChain.link)
	end ]]
	if next(mainLinkChain.link) == nil then
		if doReverseSearch ~= false then
			if linkingTable_ or linkingTable == linkedTable_ then
				return nil, l("schema '%s', link '%s' was not found", schema, key)
			end
			util.printWarning("key '%s' was not found, doing reverse search", key)
			mainLinkChain, err = dschemafld.linkRec(linkingTable_ or linkingTable, linkedTable_, false) -- recursice call, reverse search
			return mainLinkChain, err
		end
	else
		local default = {}
		local minLen = math.huge
		local maxLen = 0
		local mainTable, fld
		for _, linkArr in ipairs(mainLinkChain.link) do
			mainTable = linkArr[1].linked_table
			fld = linkArr[1].linking_field
			if #linkArr <= minLen then -- must be "<=" to override with main_table link
				if not default.linking_table or #linkArr < minLen or mainTable == linkingTableRec.main_table then
					-- default.link_field_table = mainTable
					minLen = #linkArr
					default.length = minLen
					default.link_array = linkArr
					default.last_link = linkArr[minLen]
					default.linking_table = default.last_link.linking_table
					if printLinkFind then
						util.printInfo("0. set default: main field '%s', linking table '%s', field '%s', linked table '%s', record type '%s', link chain length: %d", fld, default.linking_table, default.last_link.linking_field, default.last_link.linked_record_type, default.last_link.linked_table, minLen)
					end
				end
			end
			if #linkArr > maxLen then
				maxLen = #linkArr
			end
		end
		mainLinkChain.default = default
		mainLinkChain.linked_record_type = default.last_link.linked_record_type -- dschemasql/nameChange() uses this field
		mainLinkChain.min_length = minLen
		mainLinkChain.max_length = maxLen
		mainLinkChain.link_chain_count = #mainLinkChain.link
		-- util.printTable(mainLinkChain, key.." - mainLinkChain")
		lf.tablePairLink[key] = mainLinkChain
		lf.tablePairLinkReverse[reverseKey] = mainLinkChain
		if loc.multiLinkSaveToFile then
			local keyNameArr = {"name", "min_length", "max_length", "link_chain_count", "linked_record_type", "default"}
			local jsonTxt = json.toJsonKeySorted({name = loc.multiLinkPreferenceFileName, [schema .. "/link"] = lf.tablePairLink}, keyNameArr)
			-- [schema.."/link_reverse"] = lf.tablePairLinkReverse
			fs.writeFile(util.mainPath() .. loc.multiLinkPreferenceFileName, jsonTxt, loc.logSave)
		end
		return mainLinkChain
	end
	return nil, l("schema '%s', link '%s' was not found", schema, key)
end

local function addToExtraFieldJson(localTableRec, fldRec, locf_, save)
	-- todo: pitäsi osata tutkia kaikki localit extra_field kentät että löytyy jostain externalista ja tuhota turhat pois
	--  - samalla tutkia, että kaikki extra_field -kentät alkaa json_data nimellä
	local path = localTableRec.preference_name
	local prf = fs.getFile(path)
	if not prf.extra_field then
		prf.extra_field = {}
	end
	prf.extra_field[#prf.extra_field + 1] = {field_name = peg.parseAfter(fldRec.local_field, "."), field_type = fldRec.field_type, field_length = fldRec.field_length, table_rec = localTableRec}
	locf_[fldRec.local_field] = prf.extra_field[#prf.extra_field]
	if save then
		fs.writeFile(path, prf, loc.logSave)
	end
end

-- local prefFileName = {["group.json"]	 = true, ["redirect.json"]	 = true}

function dschemafld.schemaGroupPreference(schema)
	if schema == defaultDatabaseSchema then
		return util.readUpperLevelPreferenceFile("table/prf/group.json", "no-db use-default")
	end
	return dprf.prf("table/external/" .. schema .. "/prf/group.json", "no-cache no-db")
end

function dschemafld.fieldTableStructure(schema)
	if schema == nil then
		schema = defaultDatabaseSchema
	end
	if locf and schema == defaultDatabaseSchema then
		return locf
	end
	if schema ~= defaultDatabaseSchema and extf[schema] then
		return extf[schema]
	end
	if groupPrfLocal == nil then
		groupPrfLocal = util.readUpperLevelPreferenceFile("table/prf/group.json", "no-db use-default") -- no-db because otherwise this would cause infinite loop, todo: use dschema.groupArray("")
		if fieldTypePrf == nil then
			fieldTypePrf = dprf.prf("table/prf/field_type.json", "no-db")
		end
		allowedFieldType = {}
		for _, rec in ipairs(fieldTypePrf.field_type) do
			allowedFieldType[rec.value] = true
		end
	end
	if schema ~= defaultDatabaseSchema and not locf then
		locf = dschemafld.fieldTableStructure() -- recursive call to fill locf before extf[schema] because extf[schema] will link to locf records
	end
	local time = util.seconds()
	local tableCount = 0
	local fieldCount = 0
	local groupPrf = groupPrfLocal
	local localFLdWarningCount = 0

	local function checkPref(tableFolderPath, groupPrfName)
		local depth = nil
		local changed = false
		local tableNameCheck = {}
		local err = {}
		local notAllowedSuffix = "lang"
		-- check extra tables that in exist in folder structure but do not exist table/prf/group.json
		for _, folderPath in ipairs(tableFolderPath) do
			for fileName in fs.dirTreeIter(folderPath, {depth = depth, suffix = ".json", disallowSuffix = notAllowedSuffix}) do
				local tablePath = peg.replace(fileName, ".json", "")
				if not peg.startsWith(fileName, "prf/") and not peg.found(fileName, "/code/") and not peg.found(fileName, "not-in-use") then -- not main level pref like group.json
					local tableName = peg.parseLast(tablePath, "/", "returnWithoutDivider")
					tableNameCheck[tableName] = true
					local groupRec = util.arrayRecord(tableName, groupPrf.group, "table_name")
					if groupRec == nil then
						groupRec = groupPrf.group_not_in_use and util.arrayRecord(tableName, groupPrf.group_not_in_use, "table_name")
						if groupRec == nil then
							changed = true
							err[#err + 1] = l("table '%s' was not found from preference '%s'", folderPath .. tablePath .. ".json", groupPrfName)
							local path
							if not peg.found(tablePath, "/") then
								path = ""
							elseif peg.endsWith(folderPath, "/local/") then
								path = "local/" .. peg.parseBeforeLast(tablePath, "/") .. "/"
							else
								path = peg.parseBeforeLast(tablePath, "/") .. "/"
							end
							groupRec = {group = path, table_name = tableName, error = err[#err]}
							groupPrf.group[#groupPrf.group + 1] = groupRec
						end
					else
						if not groupRec.table_name or groupRec.table_name == "" then
							err[#err + 1] = l("table '%s' name not found from preference '%s'", tableName, groupPrfName)
						end
						if not groupRec.group or groupRec.group == "" then
							err[#err + 1] = l("table '%s' group was not found preference '%s'", tableName, groupPrfName)
						end
					end
				end
			end
		end
		if #err > 0 then
			util.printWarning("\n - " .. table.concat(err, "\n - "))
		end

		-- check extra tables in table/prf/group.json that do not exist in folder structure
		local err2 = {}
		if not util.from4d() and groupPrf and groupPrf.group then
			local checkName = {}
			for _, groupRec in ipairs(groupPrf.group) do
				if checkName[groupRec.table_name] then
					err2[#err2 + 1] = l("table name '%s' already exists in preference '%s'", groupRec.table_name, groupPrfName)
				else
					checkName[groupRec.table_name] = true
				end
				if not tableNameCheck[groupRec.table_name] then
					err2[#err2 + 1] = l("table definition file '%s' does not exist", "table/" .. groupRec.group .. groupRec.table_name .. ".json")
					if groupRec.error ~= err2[#err2] then
						groupRec.error = err2[#err2]
						changed = true
					end
				elseif groupRec.error then
					-- changed = true
					groupRec.error = nil
				end
			end
		end
		if #err2 > 0 then
			util.printWarning("\n - " .. table.concat(err2, "\n - "))
		end
		if #err > 0 or #err2 > 0 then
			if err[1] == nil or not peg.found(err[1], "' was not found from preference '") then -- ' was not found from preference ' is not an error if it was added
				util.printRed("* " .. l("please fix errors in preference '%s'", groupPrfName))
			end
		end
		if changed and not util.from4d() then
			fs.writeFile(groupPrfName, groupPrf, loc.logSave)
		end
	end

	local groupPath = "table/"
	if schema == defaultDatabaseSchema then
		if groupPrfLocal.no_file_check ~= true then
			checkPref(groupPrfLocal.table_path, "table/prf/group.json")
		end
	else
		groupPath = "table/external/" .. schema .. "/"
		local groupPrfName = groupPath .. "prf/group.json"
		groupPrf = dprf.prf(groupPrfName, "no-cache no-db") -- change from groupPrfLocal to external
		if groupPrf.no_file_check ~= true then
			checkPref({groupPath}, groupPrfName)
		end
	end
	-- create locf
	local lf = {}
	lf._table = {}
	defaultFieldPrf = nil
	if groupPrf.group then
		local hashTbl
		if not util.from4d() then
			hashTbl = {}
		end
		for _, groupRec in ipairs(groupPrf.group) do
			if not groupRec.error then
				local localTableRec
				local prfName = groupPath .. groupRec.group .. groupRec.table_name .. ".json"
				if loc.debug then
					print(" - " .. prfName)
				end
				local prf = dprf.prf(prfName, "no-error no-cache no-db", hashTbl)
				if prf.field == nil then
					util.printRed("%s: field -tag does not exist, table '%s'", prfName, groupRec.group .. groupRec.table_name)
					prf.field = {}
				end
				local fieldArr = util.clone(prf.field)
				if prf.extra_field then
					fieldArr = util.arrayCombine({fieldArr, prf.extra_field}) -- no need to clone prf.extra_field, it will be copied
				end
				if prf.default_field and prf.default_field ~= "" then
					if defaultFieldPrf == nil or defaultFieldPrfName ~= prf.default_field then
						defaultFieldPrfName = prf.default_field
						defaultFieldPrf = dprf.prf(prf.default_field, "no-cache no-db").default_field
					end
					if defaultFieldPrf == nil then
						util.printError("%s: default field tag '%s' preference does not exist in table '%s'", prfName, groupRec.group .. groupRec.table_name)
					else
						fieldArr = util.arrayCombine({fieldArr, defaultFieldPrf})
					end
				else
					defaultFieldPrf = nil
				end
				if not util.tableIsEmpty(prf) then
					tableCount = tableCount + 1
					local count = fieldCount
					local tblRec = {
						preference_name = prfName,
						_field = {},
						-- external = {}, -- only on locf
						link = {},
						table_group = groupRec.group,
						info = prf.info,
						table_name = prf.table_name,
						unique = prf.unique,
						table_prefix = prf.table_prefix,
						table_name_language = prf.table_name_language,
						record_type_arr = prf.record_type,
						main_table = prf.main_table,
						default_field = defaultFieldPrf,
						default_value = prf.default_value,
						sync_value = prf.sync_value,
						default_order = prf.default_order,
						save_preference = prf.save_preference,
						save_script = prf.save_script,
						script_field = prf.script_field,
						-- external tables have these
						local_table = prf.local_table,
						local_record_type = prf.local_record_type,
						primary_field = nil, -- will be set later from fields
						table_number = prf.table_number
						-- table_pair = prf.table_pair,
						--[[ not needed here
					field_change = prf.field_change, -- not needed here, only when comparing table to database
					default_field = prf.default_field, -- not needed, default fields have been be combined to fieldArr
					]]
					}

					if tblRec.record_type_arr == nil then
						localFLdWarningCount = localFLdWarningCount + 1
						util.printRed("%d. table '%s' - record_type -tag has not been defined, schema '%s', preference '%s'", localFLdWarningCount, tblRec.table_name, schema, "preference/" .. prfName)
						tblRec.record_type_arr = {""}
					elseif type(tblRec.record_type_arr) ~= "table" then
						localFLdWarningCount = localFLdWarningCount + 1
						util.printRed("%d. table '%s' - record_type -tag is not an array, schema '%s', preference '%s'", localFLdWarningCount, tblRec.table_name, schema, "preference/" .. prfName)
						tblRec.record_type_arr = {""}
					end
					tblRec.record_type = util.invertTable(tblRec.record_type_arr)
					if schema ~= defaultDatabaseSchema then
						if tblRec.local_table == nil then
							localFLdWarningCount = localFLdWarningCount + 1
							util.printRed("%d. external table '%s' - local_table -tag has not been defined, schema '%s', preference '%s'", localFLdWarningCount, tblRec.table_name, schema, "preference/" .. prfName)
						end
						if tblRec.local_record_type == nil then -- is external table definition
							localFLdWarningCount = localFLdWarningCount + 1
							util.printRed("%d. external table '%s' - local_record_type -tag has not been defined, schema '%s', preference '%s'", localFLdWarningCount, tblRec.table_name, schema, "preference/" .. prfName)
							--[[
						else
						tblRec.record_type_arr = {tblRec.local_record_type}
						tblRec.record_type = {[tblRec.local_record_type] = 1}
						]]
						end
						if tblRec.local_table == "" then
							localFLdWarningCount = localFLdWarningCount + 1
							util.print("%d. external table '%s' - local_table -tag is empty, table does not link to local table, schema '%s', preference '%s'", localFLdWarningCount, tblRec.table_name, schema, "preference/" .. prfName)
						elseif tblRec.local_table then
							localTableRec = locf[tblRec.local_table]
							if localTableRec == nil then
								localFLdWarningCount = localFLdWarningCount + 1
								util.printRed("%d. %s: local table name '%s' for table '%s' was not found", localFLdWarningCount, prfName, tblRec.local_table, tblRec.table_name)
								-- tblRec.local_table = nil
							else
								tblRec.local_table_prefix = localTableRec.table_prefix
								if not localTableRec.external then
									localTableRec.external = {}
								end
								local function addTableRecExternalKey(extKey, recType)
									if localTableRec.record_type[recType] == nil then -- todo: why this if is needed?
										localFLdWarningCount = localFLdWarningCount + 1
										util.printRed("%d. external table '%s' - local record type '%s' does not exist in local table '%s' record types, schema '%s', preference '%s'", localFLdWarningCount, tblRec.table_name, recType or "nil", tblRec.local_table, schema, "preference/" .. prfName)
									end
									if localTableRec.external[extKey] then
										if localTableRec.external[extKey].table_name ~= tblRec.table_name then -- todo: why this if is needed?
											localFLdWarningCount = localFLdWarningCount + 1
											util.printRed("%d. local table '%s', external table '%s' - tried to change external schema/record_type '%s'\n   table from '%s' to '%s', preference '%s'", localFLdWarningCount, tblRec.local_table, tblRec.table_name, extKey, localTableRec.external[extKey].table_name, tblRec.table_name, "preference/" .. prfName)
										end
									end
									localTableRec.external[extKey] = tblRec
									if loc.debug then
										localTableRec.debug = "tblRec.external: " .. tblRec.local_table .. ", " .. extKey .. ", " .. prfName
									end
								end
								tblRec.schema = schema
								if type(tblRec.local_record_type) == "table" then
									for _, recType in ipairs(tblRec.local_record_type) do
										local extKey = schema .. schemaSeparator .. recType
										addTableRecExternalKey(extKey, recType)
									end
								else
									local extKey = schema .. schemaSeparator .. tblRec.local_record_type
									addTableRecExternalKey(extKey, tblRec.local_record_type)
								end
							end
						end
					end
					lf._table[#lf._table + 1] = tblRec
					lf[tblRec.table_name] = tblRec
					--[[ if tblRec.table_number then -- for 4d numbers
					lf[tblRec.table_number * 1000] = tblRec
				end ]]
					if tblRec.table_prefix == nil then
						localFLdWarningCount = localFLdWarningCount + 1
						local localPrefix = localTableRec and localTableRec.table_prefix or "nil"
						util.printRed("%d. external table '%s' has no prefix, using local table '%s' prefix '%s', preference '%s'", localFLdWarningCount, tblRec.table_name, tblRec.local_table, localPrefix, "preference/" .. prfName)
						tblRec.table_prefix = localPrefix
					else
						lf[tblRec.table_prefix] = tblRec
					end
					local fieldName
					local typeWarningShown = false
					local usedFieldNameIdx = {}
					for i, fldArrRec in ipairs(fieldArr) do
						fieldName = fldArrRec.field_name
						if fieldName == nil then
							util.printError("%s: field_name -tag #%d for table '%s' is nil", prfName, i, tblRec.table_name)
							util.closeProgram()
						elseif usedFieldNameIdx[fieldName] then
							util.printError("%s: field_name -tag #%d, '%s' for table '%s' is duplicate", prfName, i, fieldName, tblRec.table_name)
							-- util.closeProgram()
						elseif loc.debug and not typeWarningShown and not allowedFieldType[fldArrRec.field_type] then
							-- TODO: read field types from database and update missing json
							typeWarningShown = true
							localFLdWarningCount = localFLdWarningCount + 1
							util.printRed("%d. %s: field_type -tag value #%d for table '%s' is '%s'", localFLdWarningCount, prfName, i, tblRec.table_name, tostring(fldArrRec.field_type))
						end
						usedFieldNameIdx[fieldName] = true
						fieldCount = fieldCount + 1
						local fldRec = util.clone(fldArrRec) -- we must clone this record here or there will be errors
						-- fldRec.external = {} -- only for locf
						fldRec.table_rec = tblRec
						fldRec.field = tblRec.table_prefix .. "." .. fieldName
						-- fldRec.local_field_part == peg.splitToArray(rec.local_field, "."), set on first call to dschema.localFieldPart(rec)
						-- fldRec.field_name_part == peg.splitToArray(rec.field_name, "."), set on first call to dschema.fieldNamePart(rec)
						if fldRec.constraint and not tblRec.primary_field then
							if fn.index("primary key", fldRec.constraint) then
								tblRec.primary_field = fldRec.field_name
							end
						end
						if fldRec.value_map then
							if type(fldRec.value_map) == "string" and peg.found(fldRec.value_map, ".json") then
								local mapPrfName = peg.parseBeforeWithDivider(fldRec.value_map, ".json")
								local keyName = fldRec.value_map:sub(#mapPrfName + 2)
								local valueMap = util.prf(mapPrfName)
								if keyName ~= "" then
									valueMap = valueMap[keyName]
								end
								if type(valueMap) ~= "table" then
									util.printError("table '%s', field '%s' value_map '%s' type is not a table", fldRec.value_map, fieldName, tblRec.table_name)
								elseif util.tableIsEmpty(valueMap) then
									util.printError("table '%s', field '%s' value_map '%s' is empty table", fldRec.value_map, fieldName, tblRec.table_name)
								else
									fldRec.value_map = valueMap
								end
							end
							fldRec.value_map_invert = util.invertTable(fldRec.value_map)
						end
						--[[ if fldRec.field == "ordr.dispatch_note_id" or fldRec.field == "sor.dispatch_note_id" then
						local debug
					    -- end ]]
						if fldRec.local_table or tblRec.local_table then
							localTableRec = locf[fldRec.local_table or tblRec.local_table]
							if localTableRec == nil then
								if tblRec.local_table ~= "" then -- if local_table == "" then do not warn about local_field -tags
									localFLdWarningCount = localFLdWarningCount + 1
									util.printWarning("%d. local table '%s' was not found, external field '%s', preference '%s'", localFLdWarningCount, fldRec.local_table or tblRec.local_table or "nil", fieldName, "preference/" .. prfName)
								end
							else
								if not fldRec.local_field or fldRec.local_field == "" then
									fldRec.local_field = "json_data." .. fldRec.field_name
									localFLdWarningCount = localFLdWarningCount + 1
									--[[ util.printWarning("%d. field in local table '%s' was not found, external field '%s', preference '%s', adding field '%s'",
									localFLdWarningCount,
									fldRec.local_table or tblRec.local_table or "nil",
									fieldName,
									"preference/"..prfName,
									fldRec.local_field) ]]
								end
								local dotPos = peg.find(fldRec.local_field, ".")
								if dotPos > 1 then
									if fldRec.local_field:sub(1, dotPos - 1) == "json_data" then
										fldRec.local_field = localTableRec.table_prefix .. "." .. fldRec.local_field
										-- else
										-- fldRec.local_field = "" .. fldRec.local_field -- for debug
									end
								else
									fldRec.local_field = localTableRec.table_prefix .. "." .. fldRec.local_field
								end
								fldRec.schema = schema
								local localFieldRec = locf[fldRec.local_field]
								if localFieldRec == nil then
									addToExtraFieldJson(localTableRec, fldRec, locf, loc.extraFieldSaveToFile)
									localFieldRec = locf[fldRec.local_field]
								end
								if localFieldRec == nil then
									localFieldRec = nil
									--[[ localFLdWarningCount = localFLdWarningCount + 1
								util.printRed("%d. local field '%s' was not found, external field '%s', preference '%s'",
									localFLdWarningCount,
									fldRec.local_field or "nil",
									fieldName,
									"preference/"..prfName)
								local addKey = schema..schemaSeparator..tblRec.table_name
								if addJsonFieldToLocalTableJson[addKey] == nil and fldRec.local_field and peg.found(fldRec.local_field, ".json_data.") then
									-- local console = require "console"
									io.write(l(" * do you want to add external json_data -fields to local table preference '%s'? [y/n]: ", localTableRec.preference_name))
									local key = "y" -- console.waitKeyPressed({"y", "n"})
									print(key)
									addJsonFieldToLocalTableJson[addKey] = key == "y"
								end
								if addJsonFieldToLocalTableJson[addKey] == true and peg.found(fldRec.local_field, ".json_data.") then
									addToExtraFieldJson(localTableRec, fldRec, locf, loc.extraFieldSaveToFile)
									util.printInfo("%d. local field '%s' was not found, external field '%s', preference '%s'\n  - extra_field '%s' was added to preference '%s'",
										localFLdWarningCount,
										fldRec.local_field,
										fieldName,
										prfName,
										fldRec.local_field,
										localTableRec.preference_name)
								else
									fldRec.local_field = nil
								end ]]
								else
									if localFieldRec.external == nil then
										localFieldRec.external = {}
									end
									local function addFieldRecExternalKey(extKey)
										if localFieldRec.external[extKey] == nil then
											localFieldRec.external[extKey] = fldRec
										else
											-- localFieldRec.external[extKey] = fldRec -- do not change
											if localFieldRec.external[extKey].field ~= fldRec.field then
												localFLdWarningCount = localFLdWarningCount + 1
												util.printRed("%d. local field '%s', external field '%s' - tried to change external schema/record_type '%s'\n   field from '%s' to '%s', preference '%s'", localFLdWarningCount, fldRec.local_field or "nil", fieldName, extKey, localFieldRec.external[extKey].field, fldRec.field, "preference/" .. prfName)
											end
										end
									end
									if type(tblRec.local_record_type) == "table" then
										for _, recType in ipairs(tblRec.local_record_type) do
											local extKey = schema .. schemaSeparator .. recType
											addFieldRecExternalKey(extKey)
										end
									else
										local extKey = schema .. schemaSeparator .. tblRec.local_record_type
										addFieldRecExternalKey(extKey)
									end
								end
							end
						end
						tblRec._field[#tblRec._field + 1] = fldRec
						if peg.found(fldRec.field, "record_type") then
							lf[fldRec.field] = fldRec
						end -- ]]
						lf[fldRec.field] = fldRec -- co.name
						if tblRec.table_number and fldRec.field_number then
							if lf._field_number == nil then
								lf._field_number = {}
							end
							lf._field_number[tblRec.table_number * 1000 + fldRec.field_number] = fldRec
						end
						-- lf[tblRec.table_name.."."..fieldName] = fldRec -- company.name
					end
					tblRec.field_count = fieldCount - count
				end
			end
		end
		-- save hash value to prf/group.json
		if not util.from4d() then
			local xxhash = require "xxhash"
			local hashVal = xxhash.hash128string(table.concat(hashTbl))
			if groupPrf.hash ~= hashVal then
				groupPrf.hash = hashVal
				local groupPrfName = groupPath .. "prf/group.json"
				fs.writeFile(groupPrfName, groupPrf, loc.logSave)
			end
		end
	end
	if localFLdWarningCount > 0 then
		print()
	end
	-- lf.fieldCount = fieldCount
	-- lf.tableCount = tableCount
	addRelation(lf, schema)
	if schema == defaultDatabaseSchema then
		if locf == nil then
			locf = lf
		else
			lf = locf
			util.printError("local field structure already exists")
		end
		if extf[schema] == nil then
			extf[schema] = lf
		else
			util.printRed("external field structure for schema '%s' already exists", schema)
		end
	else
		if extf[schema] == nil then
			extf[schema] = lf
		else
			lf = extf[schema]
			util.printError("external field structure for schema '%s' already exists", schema)
		end
	end
	if not util.from4d() then
		time = util.seconds(time)
		util.printInfo("* field table creation time for database schema '%s': %.4f seconds, tables: %d, fields: %d\n", schema, time, tableCount, fieldCount)
	end
	return lf
end

function dschemafld.reloadSchema(schema)
	if extf[schema] then
		extf[schema] = nil
		return dschemafld.fieldTableStructure(schema)
	end
end

return dschemafld
