--- dseq.lua
-- Database sequences.
-- local dseq = require "dseq"
-- @module db
--[[
-- todo: https://www.cybertec-postgresql.com/en/postgresql-sequences-vs-invoice-numbers/
test=# WITH x AS (UPDATE t_invoice_id
SET id = id + 1
RETURNING *
)
INSERT INTO t_invoice
SELECT x.id, 'cool client' FROM x;
INSERT 0 1
]] --
local dseq = {}
local util = require "util"
local l = require"lang".l
local peg = require "peg"
local qry = require "qry"
local dschema = require "dschema"
local dsave = require "dsave"
local dconn = require "dconn"
local dt = require "dt"
local dseq4d = require "dseq4d"
local uuid = require "uuid"
local auth = require "auth"
local recData = require"recdata".get
local recDataSet = require"recdata".set

local uuid4d
local savePref = {table = "sequence_number", record_type = ""}
-- local organizationFieldArr

local seqTbl
local function sequenceTbl(option)
	if dconn.database4d() then
		return dseq4d.sequence4dTbl()
	end
	if seqTbl == nil or option and peg.find(option, "no-cache") > 0 then
		local err
		seqTbl, err = qry.queryJson("common/sequence_number/all.json")
		if seqTbl and seqTbl.error or seqTbl == nil and err then
			return nil, err or seqTbl.error
		end
		seqTbl = seqTbl.data
		--[[
			seqTbl = {
				{
					seq.sequence_field = "co.json_data.company_number",
					seq.serie = "",
					seq.organization_id = 0,
					seq.prefix = "",
					seq.sequence_length = 4,
					seq.running_number = 1001,
					seq.start_number = 1,
					seq.end_number = 999999,
					seq.start_date = '',
					seq.end_date = '',
					seq.serie_field = "",
					seq.organization_field = "", -- later so_organization_id
					seq.date_field = "",
				},
				{
					seq.sequence_field = "po_code_id",
					seq.serie = "",
					seq.organization_id = 0,
					seq.prefix = "15",
					seq.sequence_length = 5,
					seq.running_number = 1,
					seq.start_number = 1,
					seq.end_number = 99999,
					seq.start_date = '2014-01-01',
					seq.end_date = '2014-12-31',
					seq.serie_field = "",
					seq.organization_field = "ord.json_data.firm_id", -- later so_organization_id
					seq.date_field = "ord.order_date",
				},
				{
					seq.sequence_field = "so_code_id",
					seq.serie = "",
					seq.organization_id = 0,
					seq.prefix = "15",
					seq.sequence_length = 5,
					seq.running_number = 1,
					seq.start_number = 1,
					seq.end_number = 999999,
					seq.start_date = '2014-01-01',
					seq.end_date = '2014-12-31',
					seq.serie_field = "so_type",
					seq.organization_field = "ord.json_data.firm_id", -- later so_organization_id
					seq.date_field = "ord.order_date",
				},
				{
					seq.sequence_field = "so_code_id",
					seq.serie = "TA", -- tarjous
					seq.organization_id = 0,
					seq.prefix = "T15",
					seq.sequence_length = 5,
					seq.running_number = 1,
					seq.start_number = 1,
					seq.end_number = 999999,
					seq.start_date = '2014-01-01',
					seq.end_date = '2014-12-31',
					seq.serie_field = "so_type",
					seq.organization_field = "ord.json_data.firm_id", -- later so_organization_id
					seq.date_field = "ord.order_date",
				},
			}
		]]
	end

	return seqTbl
end

local sequenceFieldArr
local function sequenceField(option)
	if sequenceFieldArr == nil or option and option["no-cache"] then
		sequenceFieldArr = {}
		local sequenceFieldArrUsed = {}
		local seq = sequenceTbl(option)
		if type(seq) == "table" then
			for _, rec in ipairs(seq) do
				if rec.seq.sequence_field ~= nil and sequenceFieldArrUsed[rec.seq.sequence_field] == nil and rec.seq.sequence_field ~= "" then
					sequenceFieldArrUsed[rec.sequence_field] = true
					sequenceFieldArr[#sequenceFieldArr + 1] = rec.seq.sequence_field
				end
			end
		end
	end
	return sequenceFieldArr
end

local function setRecordUuid(tableName, schema, recordType, rec, newRec) -- set uuid-fields
	local uuidFld = dschema.uuidField(tableName) -- , schema, recordType) -- we need local field
	uuidFld = dschema.fieldName(uuidFld) -- remove table prefix
	local currentUser = auth.currentUser()

	if dconn.database4d() then
		if newRec == true and uuidFld ~= nil and (rec[uuidFld] == "" or rec[uuidFld] == nil) then
			if uuid4d == nil then
				uuid4d = require "uuid-4d"
			end
			rec[uuidFld] = uuid4d.uuid(tableName, recordType)
		end
		return -- todo: is there no need to set other creator_id -fields?
	end

	local timestamp = dt.currentDateTimeMs() -- dt.currentTimeZoneString() --
	local recId = uuid.new() -- createUuid(tableName)
	local tablePrefix = dschema.tablePrefix(tableName)
	if newRec == true and uuidFld ~= nil and (rec[uuidFld] == "" or rec[uuidFld] == nil) then
		rec[uuidFld] = recId
		--[[ if dschema.externalFieldExists(tablePrefix..".create_user", schema, recordType) then
			rec["create_user"] = currentUser -- create_user is not used in new local default field
		end ]]
		if dschema.externalFieldExists(tablePrefix .. ".create_time", schema, recordType) then -- local schema timestamps are done by db default value now()
			rec["create_time"] = timestamp
		end
		--[[ if not organizationFieldArr then
			organizationFieldArr = util.prf("constant/organization_field.json")
		end
		if organizationFieldArr[tablePrefix] then -- todo: remove organizationFieldArr[tableName] - move to table json
			local organizationField = organizationFieldArr[tableName]
			if organizationField then
				rec[organizationField] = auth.currentOrganizationNumber()
			end
		end ]]
	end
	if dschema.externalFieldExists(tablePrefix .. ".modify_id", schema, recordType) then -- dschema.externalFieldExists() checks if table is local
		rec["modify_id"] = recId -- modify_id exists also in local tables
	end
	if dschema.externalFieldExists(tablePrefix .. ".modify_user", schema, recordType) then
		rec["modify_user"] = currentUser
	end
	if dschema.externalFieldExists(tablePrefix .. ".modify_time", schema, recordType) then -- local schema timestamps are done by db default value now()
		rec["modify_time"] = timestamp
	end
end

local function setRecordSequence(tableName, schema, tableRecordType, rec)
	local fieldArr, err
	if dconn.database4d() then
		fieldArr, err = dseq4d.sequenceField()
	else
		fieldArr = sequenceField()
	end
	if fieldArr == nil then
		return nil, nil, nil, err or "unable to create sequence4dField -array"
	end
	local sequenceRunningNumber, sequenceId, sequenceRecordId, defaultOrgRecord, defaultRecordTypeRecord
	local seqField, seqTable
	for i, fieldWithRecType in ipairs(fieldArr) do
		local seqFieldFull, seqRecType = dschema.splitRecTypeName(fieldWithRecType)
		if dschema.isField(seqFieldFull) then
			seqField = dschema.fieldName(seqFieldFull) -- remove table prefix
			if rec[seqField] == nil then
				seqTable = dschema.tableName(seqFieldFull) -- , schema, tableRecordType) -- we want local table name
				if tableName == seqTable then -- add sequence field to rec if it is missing
					if seqRecType == tableRecordType then --  or seqRecType == "" then -- TODO: check case seqRecType == ""
						local fldType = dschema.fieldType(seqFieldFull)
						if fldType then
							if fldType == "varchar" or fldType == "text" then
								rec[seqField] = ""
							elseif dschema.fieldTypeLua(seqFieldFull) == "number" then
								rec[seqField] = 0
							else
								util.printError("unknown sequence number field type '%s', field '%s'", tostring(fldType), tostring(seqFieldFull))
								return
							end
						end
					end
				end
			end
			if rec[seqField] and (rec[seqField] == 0 or rec[seqField] == "") then
				local seq = sequenceTbl()
				local j = i -- start checking from index i
				local foundSequenceRec
				local recordType = tableRecordType or ""
				local recordTypeFieldName = dschema.recordTypeFieldName(tableName)
				if recordTypeFieldName ~= nil and rec[recordTypeFieldName] then
					recordType = rec[recordTypeFieldName]
				end
				while seq and j <= #seq do
					local sRec = seq[j].seq or seq[j] -- note: plain seq[j] in case of 4d
					local sRecSeqField = dschema.splitRecTypeName(sRec.sequence_field)
					if sRecSeqField == seqFieldFull then
						if recordType == sRec.record_type then
							local sRecDateField = dschema.splitRecTypeName(sRec.date_field)
							local dateFld = dschema.fieldName(sRecDateField) or "" -- remove table prefix
							if dateFld ~= "" and rec[dateFld] == nil then
								recDataSet(rec, dateFld, dt.currentDateString())
							end
							local dateValue = recData(rec, dateFld)
							local dateOk = dateFld == "" or (dateValue >= sRec.start_date and dateValue <= sRec.end_date)
							local allOk = dateOk and sRec.serie == ""
							if not allOk and sRec.serie_field ~= "" then
								local sRecTypeField = dschema.fieldName(dschema.splitRecTypeName(sRec.serie_field))
								local typeValue = sRecTypeField and recData(rec, sRecTypeField)
								allOk = dateOk and sRec.serie == "" or (sRecTypeField ~= "" and typeValue ~= nil and peg.found("," .. sRec.serie .. ",", "," .. typeValue .. ","))
							end
							if allOk then
								local organization = 0
								local sRecOrganizationField = sRec.organization_field
								if sRecOrganizationField and sRecOrganizationField ~= "" then
									sRecOrganizationField = dschema.fieldName(dschema.splitRecTypeName(sRecOrganizationField))
								end
								if sRecOrganizationField ~= nil then
									organization = recData(rec, sRecOrganizationField) or 0
								end
								local rightRecordType = sRec.record_type == recordType
								local rightOrganization = organization == sRec.organization_id
								if rightRecordType and rightOrganization then
									foundSequenceRec = sRec
									break
								elseif rightRecordType then
									if sRec.organization_id == 0 then
										defaultRecordTypeRecord = sRec
									elseif sRec.organization_id == 1 and defaultRecordTypeRecord == nil then
										defaultRecordTypeRecord = sRec
									end
								elseif sRec.record_type == "" then
									if rightOrganization then
										defaultOrgRecord = sRec
									elseif sRec.organization_id == 0 and defaultOrgRecord == nil then
										defaultOrgRecord = sRec
									elseif sRec.organization_id == 1 and defaultOrgRecord == nil then
										defaultOrgRecord = sRec
									end
								end
							end
						end
					end
					j = j + 1
				end
				foundSequenceRec = foundSequenceRec or defaultRecordTypeRecord or defaultOrgRecord
				if foundSequenceRec then
					local runningStr
					if dconn.database4d() then
						runningStr = dseq4d.get4dRunningNumber(foundSequenceRec.seq_4d_running_num_prf_name)
						if runningStr == nil then
							err = l("sequence number was not found for 4D preference '%s', table '%s', record type '%s'", foundSequenceRec.seq_4d_running_num_prf_name, table, recordType)
						end
					else
						runningStr = foundSequenceRec.running_number
						if runningStr == nil then
							err = l("sequence number was not found for table '%s', record type '%s'", table, recordType)
						end
					end
					if err then -- runningStr == nil causes err to exist
						return nil, nil, nil, err
					else
						runningStr = tostring(runningStr)
						local len = #runningStr
						runningStr = string.rep("0", foundSequenceRec.sequence_length - len) .. runningStr
						sequenceRecordId = foundSequenceRec.record_id
						sequenceRunningNumber = foundSequenceRec.running_number
						sequenceId = foundSequenceRec.prefix .. runningStr
						rec[seqField] = sequenceId
						if foundSequenceRec.organization_field and foundSequenceRec.organization_field ~= "" then
							local sRecOrganizationField = dschema.fieldName(dschema.splitRecTypeName(foundSequenceRec.organization_field))
							local organizationFieldValue = recData(rec, sRecOrganizationField)
							if sRecOrganizationField ~= nil and (organizationFieldValue == nil or organizationFieldValue == 0) then
								recDataSet(rec, sRecOrganizationField, foundSequenceRec.organization_id)
							end
						end
					end
					break
				end
			end
		end
	end
	return sequenceId, sequenceRunningNumber, sequenceRecordId, err
	-- rec.code_id = rec.organization_id.."."..rec.sequence_field.."."..rec.serie.."."..rec.start_date.."_"..rec.end_date.."."..  rec.start_number.."_"..rec.end_number
	-- is this unique now?
	-- local fmt = "%0"..rec.sequence_length.."d"
	-- rec.record_id = "" -- = uuid.new()
	-- no need to set uuid to record_id, db.recordTableToSelection() will do it
end

function dseq.saveSequence(sequenceArr)
	if dconn.database4d() then
		return
	end
	local biggestNumber, recordNumber, sequenceArrRec
	for _, rec in ipairs(sequenceArr) do
		if rec.record_id and rec.running_number then
			if biggestNumber == nil or rec.running_number > biggestNumber then
				sequenceArrRec = rec
				biggestNumber = rec.running_number
				recordNumber = rec.record_id
			end
		end
	end
	if biggestNumber and recordNumber then
		local sel, err = qry.queryJson("common/sequence_number/running_number.json", {record_id = recordNumber})
		if sel and sel.error or sel == nil and err then
			return nil, err or sel.error
		end
		sel = sel.data
		local selRec = sel and sel[1] and sel[1].seq
		if selRec ~= nil then
			if selRec.running_number <= biggestNumber then
				local updateField = {}
				updateField[1] = {seq = {}}
				updateField[1].seq.record_id = selRec.record_id
				local runningNumber = selRec.running_number + 1
				updateField[1].seq.running_number = runningNumber
				local _
				_, err = dsave.saveToDatabase(updateField, savePref)
				if err then
					util.printError(l("Problems with saving next free number to field '%s'"), selRec.sequence_field)
				else
					sequenceArrRec.running_number = runningNumber
					local recSet = false
					for _, rec in ipairs(seqTbl) do
						if rec.seq.record_id == sequenceArrRec.record_id then
							recSet = true
							rec.seq.running_number = runningNumber
							break
						end
					end
					if recSet == false then
						util.printError(l("Problems with saving next free number to seqTbl field '%s'"), selRec.sequence_field)
					end
				end
			end
		end
	end
end

function dseq.setRecordArraySequence(tableName, schema, recordType, arr, newRec)
	local sequenceArr, err
	local conn = dconn.currentConnection()
	for _, rec in ipairs(arr) do
		setRecordUuid(tableName, schema, recordType, rec, newRec)
		if newRec == true then
			local sequenceId, sequenceRunningNumber, sequenceRecordId
			sequenceId, sequenceRunningNumber, sequenceRecordId, err = setRecordSequence(tableName, schema, recordType, rec)
			if err then
				return nil, err
			elseif sequenceId == "" then
				return nil, l("sequence id is empty for table '%s', record type '%s'", table, recordType)
			end
			if not dconn.database4d() then -- 4d-call saves next running number right away
				if sequenceId ~= nil then
					if sequenceArr == nil then
						sequenceArr = {}
					end
					sequenceArr[#sequenceArr + 1] = {}
					sequenceArr[#sequenceArr] = {running_number = sequenceRunningNumber, record_id = sequenceRecordId}
				end
			end
		end
	end
	local conn2 = dconn.currentConnection()
	if conn ~= conn2 then
		dconn.restoreConnection(conn) -- setRecordSequence() will use json query and it may change connection
	end
	return sequenceArr
end

return dseq
