--- db_sequence_4d.lua
-- Database sequences.
-- local dseq4d = require "dseq4d"
-- @module db
local dseq4d = {}

local json = require "json"
local l = require"lang".l
local peg = require "peg"
local dschema = require "dschema"
local dsql = require "dsql"
local dconv = require "dconv"
local fn = require "fn"

local seq4dTbl
function dseq4d.sequence4dTbl(option)
	if seq4dTbl == nil or option and option["no-cache"] then
		-- local prevOrg = auth.setCurrentOrganization("4d")
		local sel, info = dsql.sqlExecuteUnsafe("SELECT text_value FROM _preference WHERE name_id = 'code_default.json'", {"text_value"}, {"string"})
		-- auth.setCurrentOrganization(prevOrg)
		local codeDefault = sel and sel[1] and sel[1].text_value -- see site_codes.dhtm
		if codeDefault == nil then
			return nil, l("code_default.json preference was not found from 4d")
		end
		codeDefault = json.fromJson(codeDefault)
		codeDefault = codeDefault.code
		info.column_count = 0
		info.column_name = {}
		local fldTagName = {}
		for fld in pairs(codeDefault) do
			info.column_count = info.column_count + 1
			info.column_name[info.column_count] = fld
			fldTagName[info.column_count] = fld:sub(9):lower()
		end
		info.row_count = #codeDefault[info.column_name[1]]
		codeDefault = dconv.arrayTableToRecordTable(codeDefault, info, fldTagName)
		seq4dTbl = {}
		fn.iter(codeDefault):each(function(rec)
			if rec.fld and rec.seriefld and rec.firmfld and rec.datefld and rec.firmid and rec.startdate and rec.enddate and rec.prefix and rec.numberlength and rec.runningnum and rec.startnum and rec.endnum and rec.codeid then
				seq4dTbl[#seq4dTbl + 1] = {}
				local sRec = seq4dTbl[#seq4dTbl]
				if rec.fld > 0 then
					sRec.record_type = dschema.localRecordType(rec.fld, "4d")
					sRec.sequence_field = dschema.localNameWithRecType(rec.fld, "4d")
				else
					sRec.sequence_field = ""
				end
				if rec.seriefld > 0 then
					sRec.serie_field = dschema.localNameWithRecType(rec.seriefld, "4d")
				else
					sRec.serie_field = ""
				end
				if rec.firmfld > 0 then
					sRec.organization_field = dschema.localNameWithRecType(rec.firmfld, "4d")
				else
					sRec.organization_field = ""
				end
				if rec.datefld > 0 then
					sRec.date_field = dschema.localNameWithRecType(rec.datefld, "4d")
				else
					sRec.date_field = ""
				end
				sRec.serie = rec.serie
				sRec.organization_id = rec.firmid
				sRec.start_date = peg.replace(rec.startdate, ".", "-")
				sRec.end_date = peg.replace(rec.enddate, ".", "-")
				sRec.prefix = rec.prefix
				sRec.sequence_length = rec.numberlength
				sRec.running_number = rec.runningnum
				sRec.start_number = rec.startnum
				sRec.end_number = rec.endnum
				sRec.seq_4d_running_num_prf_name = rec.codeid
			end
		end)
	end
	return seq4dTbl
end

local sequenceFieldArr
function dseq4d.sequenceField(option)
	if sequenceFieldArr == nil or option and peg.find(option, "no-cache") > 0 then
		sequenceFieldArr = {}
		local sequenceFieldArrUsed = {}
		local seq, err = dseq4d.sequence4dTbl(option)
		if seq == nil then
			return nil, err
		end
		for _, rec in ipairs(seq) do
			if rec.sequence_field and rec.sequence_field ~= "" and sequenceFieldArrUsed[rec.sequence_field] == nil then
				sequenceFieldArrUsed[rec.sequence_field] = true
				sequenceFieldArr[#sequenceFieldArr + 1] = rec.sequence_field
			end
		end
	end
	return sequenceFieldArr
end

function dseq4d.get4dRunningNumber(preferenceName)
	if type(preferenceName) ~= "string" then
		return nil, l("sequence running number was not found from 4d")
	end
	local sel, info = dsql.sqlExecuteUnsafe("SELECT long_value, change_id FROM _preference WHERE name_id = '" .. preferenceName .. "'", {"long_value", "change_id"}, {"integer", "string"})
	if info.error then
		return nil, info.error
	end
	local runnungNumber = sel[1].long_value
	-- save next number right away
	local _
	_, info = dsql.sqlExecuteUnsafe("UPDATE _preference SET long_value = long_value + 1 WHERE name_id = '" .. preferenceName .. "'") -- .."' AND long_value="..runnungNumber)
	if info.error then
		return nil, info.error
	end
	return runnungNumber
end

return dseq4d
