--- lib/db/dsql-old.lua
local dsqlOld = {}
local dschema = require "dschema"
local dschemafld = require "dschemafld"
local dconn = require "dconn"
local dprf = require "dprf"
local recordTypeSeparator = dschemafld.recordTypeSeparator

function dsqlOld.addLinkRecJoinOld(linkArray, queryTblSql, addJoin)
	local connQuery = dconn.query()
	local schema = dconn.schema()
	-- if linkRec.default then
	-- 	linkRec = linkRec.default.last_link
	-- end
	for _, rec in ipairs(linkArray) do
		local where
		if rec.join and rec.join ~= "" then
			where = rec.join
		else
			where = dschema.fieldNamePrefixSql(rec.linked_field .. recordTypeSeparator .. rec.linked_record_type) .. " = " .. dschema.fieldNamePrefixSql(rec.linking_field .. recordTypeSeparator .. rec.linking_record_type) -- can be either way, but this is more clear
			if rec.extra_link_field then
				for _, rec2 in ipairs(rec.extra_link_field) do
					where = where .. " AND " .. dschema.fieldNamePrefixSql(rec2.linked .. recordTypeSeparator .. rec.linked_record_type) .. " = " .. dschema.fieldNamePrefixSql(rec2.linking .. recordTypeSeparator .. rec.linking_record_type)
				end
			end
		end
		if rec.linking_table ~= queryTblSql then
			-- addJoin(rec.linking_field .. recordTypeSeparator .. rec.linking_record_type, rec.linking_table .. recordTypeSeparator .. rec.linking_record_type, where)
			local prefixSql = dschema.tablePrefix(rec.linking_table, schema, rec.linked_record_type or rec.linking_record_type or connQuery.recordType or "")
			-- addJoin(rec.linking_field, rec.linking_table, where)
			addJoin(prefixSql, rec.linking_table, where)
		end
		if rec.linked_table ~= queryTblSql then
			-- addJoin(rec.linked_field .. recordTypeSeparator .. rec.linked_record_type, rec.linked_table .. recordTypeSeparator .. rec.linked_record_type, where)

			local prefixSql = dschema.tablePrefix(rec.linked_table, schema, rec.linking_record_type or connQuery.recordType or "")
			-- addJoin(rec.linked_field, rec.linked_table, where)
			addJoin(prefixSql, rec.linked_table, where)
		end
	end
end

local function findLinkPairOld(tbl, queryTblSql, loc)
	local connQuery = dconn.query()
	local schema = dconn.schema()
	local queryLinkTable
	if #connQuery.linkTable > 2 then
		queryLinkTable = dschema.tableNameSql(connQuery.linkTable[2], "no-quote")
	end
	if not loc.allTableLinkChain then
		loc.allTableLinkChain = dprf.prf("table/prf/all_table_link_chain.json")
	end
	local allTableLinkChain = loc.allTableLinkChain.schema[schema] and loc.allTableLinkChain.schema[schema].chain or {}

	local rec
	if queryLinkTable and queryLinkTable ~= queryTblSql then
		rec = allTableLinkChain[tbl] and allTableLinkChain[tbl][queryTblSql]
		if not rec then -- is this ok?
			rec = allTableLinkChain[tbl] and allTableLinkChain[tbl][queryLinkTable]
			if not rec then
				rec = allTableLinkChain[queryLinkTable] and allTableLinkChain[queryLinkTable][tbl]
			end
		end
	end
	if not rec then
		rec = allTableLinkChain[tbl] and allTableLinkChain[tbl][queryTblSql]
		if not rec then
			rec = allTableLinkChain[queryTblSql] and allTableLinkChain[queryTblSql][tbl]
		end
	end
	return rec
end

function dsqlOld.findLinkRecOld(linkedTblSql, queryTblSql, loc)
	local connQuery = dconn.query()
	local schema = dconn.schema()
	local rec = findLinkPairOld(linkedTblSql, queryTblSql, loc)
	local linkRec, err
	if rec then
		if linkedTblSql == rec.link_array[1].linking_table then
			linkRec, err = dschemafld.linkRec(linkedTblSql, rec.link_array[1].linked_table)
		else
			linkRec, err = dschemafld.linkRec(linkedTblSql, rec.link_array[1].linking_table)
		end
	end
	if not linkRec then
		local tblSql
		for localTbl in pairs(connQuery.tableRecordType) do
			tblSql = dschema.tableNameSql(localTbl, "no-quote")
			if tblSql ~= linkedTblSql then
				if not loc.allTableLinkChain then
					loc.allTableLinkChain = dprf.prf("table/prf/all_table_link_chain.json")
				end
				local allTableLinkChain = loc.allTableLinkChain.schema[schema] and loc.allTableLinkChain.schema[schema].chain or {}
				rec = allTableLinkChain[linkedTblSql] and allTableLinkChain[linkedTblSql][tblSql]
				if not rec then
					rec = allTableLinkChain[tblSql] and allTableLinkChain[tblSql][linkedTblSql]
				end
				if rec then
					if linkedTblSql == rec.link_array[1].linking_table then
						linkRec, err = dschemafld.linkRec(linkedTblSql, rec.link_array[1].linked_table)
					else
						linkRec, err = dschemafld.linkRec(linkedTblSql, rec.link_array[1].linking_table)
					end
					if linkRec then
						return linkRec, err
					end
				end
			end
		end
		return nil, err -- did not find linkRec
	end
	return linkRec, err
end

return dsqlOld

--[[
function dsql.setDefaultOrderBy(prf)
	local dbtype = dconn.dbType()
	if dbtype then
		defaultOrderBy[dbtype] = prf
	end
end

function dsql.getDefaultOrderBy(table)
	local field, ascending
	local dbType = dconn.dbType()
	if defaultOrderBy[dbType] then
		local rec = defaultOrderBy[dbType][table]
		if rec == nil then
			rec = defaultOrderBy[dbType][table]
		end
		if rec and #rec > 0 then
			field = rec[1].field
			ascending = rec[1].order
		end
	end
	return field, ascending
end

	-- set default order
	if #connSql.orderArrUsedTable < 1 and defaultOrderBy[conn.dbtype] then
		local queryTblPrefix = dschema.tablePrefixSql(connSql.fromUsedTableArr[1])
		local prf = defaultOrderBy[conn.dbtype][queryTblPrefix]
		if prf then
			for _, rec in ipairs(prf) do
				local asc = dsql.sqlAsc(rec.order)
				if not asc then
					err = l("default order field '%s' direction must be '>' or '<'", tostring(rec.field))
					util.printError(err)
				elseif not rec.field then
					err = l("default order field '%s' is invalid", tostring(rec.field))
					util.printError(err)
				else
					local fldType = dschema.fieldType(rec.field)
					local useLower = (fldType == "varchar" or fldType == "text") and dconn.useLowerSlq(conn)
					if useLower then
						connSql.orderArr[#connSql.orderArr + 1] = "lower("..dschema.fieldNamePrefixSql(rec.field)..")"..asc
					else
						connSql.orderArr[#connSql.orderArr + 1] = dschema.fieldNamePrefixSql(rec.field)..asc
					end
					connSql.orderArrUsedTable[#connSql.orderArrUsedTable + 1] = dschema.tablePrefixSql(rec.field) -- tableNumber(fldNum)
				end
			end
		end
	end
	--]]

--[[
		if #connSql.orderArrUsedTable > 0 then
			for i,tbl in ipairs(connSql.orderArrUsedTable) do
				if tbl == queryTbl then
					if peg.find(connSql.orderArr[i], queryTblName) > 0 then -- not already replaced?
						-- connSql.orderArr[i] = connSql.orderArr[i]:gsub(queryTblName, queryTblPrefix, 1)
						-- replace only once
						 connSql.orderArr[i] = peg.replace(connSql.orderArr[i], queryTblName, queryTblPrefix)
						-- peg.replace needs count parameter
					end
				end
			end
		end
	]]
-- end
