--- lib/db/duckdb/duckdb-created.lua
-- created using: tool/convert-code/create-ffi-call.lua
-- move functions from here to duckdb.lua
local duck = {}
local ffi = require "mffi"
local C = ffi.C
local lib = require "duckdb/duckdb-ffi"

-- not used:
function duck:open(path, out_database)
	return lib.duckdb_open(path, out_database) -- duckdb_state duckdb_open(const char *path, duckdb_database *out_database)
end

--- not copied:
function duck:result_get_chunk(chunk_index)
	return lib.duckdb_result_get_chunk(self.result, chunk_index) -- duckdb_data_chunk duckdb_result_get_chunk(duckdb_result result, idx_t chunk_index)
end

function duck:result_chunk_count()
	return lib.duckdb_result_chunk_count(self.result) -- idx_t duckdb_result_chunk_count(duckdb_result result)
end

function duck:malloc(size)
	return lib.duckdb_malloc(size) -- void duckdb_malloc(size_t size)
end

function duck:free(ptr)
	return lib.duckdb_free(ptr) -- void duckdb_free(void *ptr)
end

function duck:vector_size()
	return tonumber(lib.duckdb_vector_size()) -- idx_t duckdb_vector_size()
end

function duck:from_date(date)
	return lib.duckdb_from_date(date) -- duckdb_date_struct duckdb_from_date(duckdb_date date)
end

function duck:to_date(date)
	return lib.duckdb_to_date(date) -- duckdb_date duckdb_to_date(duckdb_date_struct date)
end

function duck:from_time(time)
	return lib.duckdb_from_time(time) -- duckdb_time_struct duckdb_from_time(duckdb_time time)
end

function duck:to_time(time)
	return lib.duckdb_to_time(time) -- duckdb_time duckdb_to_time(duckdb_time_struct time)
end

function duck:from_timestamp(ts)
	return lib.duckdb_from_timestamp(ts) -- duckdb_timestamp_struct duckdb_from_timestamp(duckdb_timestamp ts)
end

function duck:to_timestamp(ts)
	return lib.duckdb_to_timestamp(ts) -- duckdb_timestamp duckdb_to_timestamp(duckdb_timestamp_struct ts)
end

function duck:hugeint_to_double(val)
	return lib.duckdb_hugeint_to_double(val) -- double duckdb_hugeint_to_double(duckdb_hugeint val)
end

function duck:double_to_hugeint(val)
	return lib.duckdb_double_to_hugeint(val) -- duckdb_hugeint duckdb_double_to_hugeint(double val)
end

function duck:double_to_decimal(val, width, scale)
	return lib.duckdb_double_to_decimal(val, width, scale) -- duckdb_decimal duckdb_double_to_decimal(double val, uint8_t width, uint8_t scale)
end

function duck:decimal_to_double(val)
	return lib.duckdb_decimal_to_double(val) -- double duckdb_decimal_to_double(duckdb_decimal val)
end

function duck:prepare(query, out_prepared_statement)
	return lib.duckdb_prepare(self.connection, query, out_prepared_statement) -- duckdb_state duckdb_prepare(duckdb_connection connection, const char *query, duckdb_prepared_statement *out_prepared_statement)
end

function duck:destroy_prepare(prepared_statement)
	return lib.duckdb_destroy_prepare(prepared_statement) -- void duckdb_destroy_prepare(duckdb_prepared_statement *prepared_statement)
end

function duck:prepare_error(prepared_statement)
	return lib.duckdb_prepare_error(prepared_statement) -- const char duckdb_prepare_error(duckdb_prepared_statement prepared_statement)
end

function duck:nparams(prepared_statement)
	return lib.duckdb_nparams(prepared_statement) -- idx_t duckdb_nparams(duckdb_prepared_statement prepared_statement)
end

function duck:param_type(prepared_statement, param_idx)
	return lib.duckdb_param_type(prepared_statement, param_idx) -- duckdb_type duckdb_param_type(duckdb_prepared_statement prepared_statement, idx_t param_idx)
end

function duck:clear_bindings(prepared_statement)
	return lib.duckdb_clear_bindings(prepared_statement) -- duckdb_state duckdb_clear_bindings(duckdb_prepared_statement prepared_statement)
end

function duck:bind_boolean(prepared_statement, param_idx, val)
	return lib.duckdb_bind_boolean(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_boolean(duckdb_prepared_statement prepared_statement, idx_t param_idx, _Bool val)
end

function duck:bind_int8(prepared_statement, param_idx, val)
	return lib.duckdb_bind_int8(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_int8(duckdb_prepared_statement prepared_statement, idx_t param_idx, int8_t val)
end

function duck:bind_int16(prepared_statement, param_idx, val)
	return lib.duckdb_bind_int16(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_int16(duckdb_prepared_statement prepared_statement, idx_t param_idx, int16_t val)
end

function duck:bind_int32(prepared_statement, param_idx, val)
	return lib.duckdb_bind_int32(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_int32(duckdb_prepared_statement prepared_statement, idx_t param_idx, int32_t val)
end

function duck:bind_int64(prepared_statement, param_idx, val)
	return lib.duckdb_bind_int64(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_int64(duckdb_prepared_statement prepared_statement, idx_t param_idx, int64_t val)
end

function duck:bind_hugeint(prepared_statement, param_idx, val)
	return lib.duckdb_bind_hugeint(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_hugeint(duckdb_prepared_statement prepared_statement, idx_t param_idx, duckdb_hugeint val)
end

function duck:bind_decimal(prepared_statement, param_idx, val)
	return lib.duckdb_bind_decimal(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_decimal(duckdb_prepared_statement prepared_statement, idx_t param_idx, duckdb_decimal val)
end

function duck:bind_uint8(prepared_statement, param_idx, val)
	return lib.duckdb_bind_uint8(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_uint8(duckdb_prepared_statement prepared_statement, idx_t param_idx, uint8_t val)
end

function duck:bind_uint16(prepared_statement, param_idx, val)
	return lib.duckdb_bind_uint16(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_uint16(duckdb_prepared_statement prepared_statement, idx_t param_idx, uint16_t val)
end

function duck:bind_uint32(prepared_statement, param_idx, val)
	return lib.duckdb_bind_uint32(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_uint32(duckdb_prepared_statement prepared_statement, idx_t param_idx, uint32_t val)
end

function duck:bind_uint64(prepared_statement, param_idx, val)
	return lib.duckdb_bind_uint64(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_uint64(duckdb_prepared_statement prepared_statement, idx_t param_idx, uint64_t val)
end

function duck:bind_float(prepared_statement, param_idx, val)
	return lib.duckdb_bind_float(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_float(duckdb_prepared_statement prepared_statement, idx_t param_idx, float val)
end

function duck:bind_double(prepared_statement, param_idx, val)
	return lib.duckdb_bind_double(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_double(duckdb_prepared_statement prepared_statement, idx_t param_idx, double val)
end

function duck:bind_date(prepared_statement, param_idx, val)
	return lib.duckdb_bind_date(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_date(duckdb_prepared_statement prepared_statement, idx_t param_idx, duckdb_date val)
end

function duck:bind_time(prepared_statement, param_idx, val)
	return lib.duckdb_bind_time(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_time(duckdb_prepared_statement prepared_statement, idx_t param_idx, duckdb_time val)
end

function duck:bind_timestamp(prepared_statement, param_idx, val)
	return lib.duckdb_bind_timestamp(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_timestamp(duckdb_prepared_statement prepared_statement, idx_t param_idx, duckdb_timestamp val)
end

function duck:bind_interval(prepared_statement, param_idx, val)
	return lib.duckdb_bind_interval(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_interval(duckdb_prepared_statement prepared_statement, idx_t param_idx, duckdb_interval val)
end

function duck:bind_varchar(prepared_statement, param_idx, val)
	return lib.duckdb_bind_varchar(prepared_statement, param_idx, val) -- duckdb_state duckdb_bind_varchar(duckdb_prepared_statement prepared_statement, idx_t param_idx, const char *val)
end

function duck:bind_varchar_length(prepared_statement, param_idx, val, length)
	return lib.duckdb_bind_varchar_length(prepared_statement, param_idx, val, length) -- duckdb_state duckdb_bind_varchar_length(duckdb_prepared_statement prepared_statement, idx_t param_idx, const char *val, idx_t length)
end

function duck:bind_blob(prepared_statement, param_idx, data, length)
	return lib.duckdb_bind_blob(prepared_statement, param_idx, data, length) -- duckdb_state duckdb_bind_blob(duckdb_prepared_statement prepared_statement, idx_t param_idx, const void *data, idx_t length)
end

function duck:bind_null(prepared_statement, param_idx)
	return lib.duckdb_bind_null(prepared_statement, param_idx) -- duckdb_state duckdb_bind_null(duckdb_prepared_statement prepared_statement, idx_t param_idx)
end

function duck:execute_prepared(prepared_statement, out_result)
	return lib.duckdb_execute_prepared(prepared_statement, out_result) -- duckdb_state duckdb_execute_prepared(duckdb_prepared_statement prepared_statement, duckdb_result *out_result)
end

function duck:execute_prepared_arrow(prepared_statement, out_result)
	return lib.duckdb_execute_prepared_arrow(prepared_statement, out_result) -- duckdb_state duckdb_execute_prepared_arrow(duckdb_prepared_statement prepared_statement, duckdb_arrow *out_result)
end

function duck:pending_prepared(prepared_statement, out_result)
	return lib.duckdb_pending_prepared(prepared_statement, out_result) -- duckdb_state duckdb_pending_prepared(duckdb_prepared_statement prepared_statement, duckdb_pending_result *out_result)
end

function duck:destroy_pending(pending_result)
	return lib.duckdb_destroy_pending(pending_result) -- void duckdb_destroy_pending(duckdb_pending_result *pending_result)
end

function duck:pending_error(pending_result)
	return lib.duckdb_pending_error(pending_result) -- const char duckdb_pending_error(duckdb_pending_result pending_result)
end

function duck:pending_execute_task(pending_result)
	return lib.duckdb_pending_execute_task(pending_result) -- duckdb_pending_state duckdb_pending_execute_task(duckdb_pending_result pending_result)
end

function duck:execute_pending(pending_result, out_result)
	return lib.duckdb_execute_pending(pending_result, out_result) -- duckdb_state duckdb_execute_pending(duckdb_pending_result pending_result, duckdb_result *out_result)
end

function duck:destroy_value(value)
	return lib.duckdb_destroy_value(value) -- void duckdb_destroy_value(duckdb_value *value)
end

function duck:create_varchar(text)
	return lib.duckdb_create_varchar(text) -- duckdb_value duckdb_create_varchar(const char *text)
end

function duck:create_varchar_length(text, length)
	return lib.duckdb_create_varchar_length(text, length) -- duckdb_value duckdb_create_varchar_length(const char *text, idx_t length)
end

function duck:create_int64(val)
	return lib.duckdb_create_int64(val) -- duckdb_value duckdb_create_int64(int64_t val)
end

function duck:get_varchar(value)
	return lib.duckdb_get_varchar(value) -- char duckdb_get_varchar(duckdb_value value)
end

function duck:get_int64(value)
	return lib.duckdb_get_int64(value) -- int64_t duckdb_get_int64(duckdb_value value)
end

function duck:create_logical_type(type)
	return lib.duckdb_create_logical_type(type) -- duckdb_logical_type duckdb_create_logical_type(duckdb_type type)
end

function duck:create_list_type(type)
	return lib.duckdb_create_list_type(type) -- duckdb_logical_type duckdb_create_list_type(duckdb_logical_type type)
end

function duck:create_map_type(key_type, value_type)
	return lib.duckdb_create_map_type(key_type, value_type) -- duckdb_logical_type duckdb_create_map_type(duckdb_logical_type key_type, duckdb_logical_type value_type)
end

function duck:create_decimal_type(width, scale)
	return lib.duckdb_create_decimal_type(width, scale) -- duckdb_logical_type duckdb_create_decimal_type(uint8_t width, uint8_t scale)
end

function duck:get_type_id(type)
	return lib.duckdb_get_type_id(type) -- duckdb_type duckdb_get_type_id(duckdb_logical_type type)
end

function duck:decimal_width(type)
	return lib.duckdb_decimal_width(type) -- uint8_t duckdb_decimal_width(duckdb_logical_type type)
end

function duck:decimal_scale(type)
	return lib.duckdb_decimal_scale(type) -- uint8_t duckdb_decimal_scale(duckdb_logical_type type)
end

function duck:decimal_internal_type(type)
	return lib.duckdb_decimal_internal_type(type) -- duckdb_type duckdb_decimal_internal_type(duckdb_logical_type type)
end

function duck:enum_internal_type(type)
	return lib.duckdb_enum_internal_type(type) -- duckdb_type duckdb_enum_internal_type(duckdb_logical_type type)
end

function duck:enum_dictionary_size(type)
	return tonumber(lib.duckdb_enum_dictionary_size(type)) -- uint32_t duckdb_enum_dictionary_size(duckdb_logical_type type)
end

function duck:enum_dictionary_value(type, index)
	return lib.duckdb_enum_dictionary_value(type, index) -- char duckdb_enum_dictionary_value(duckdb_logical_type type, idx_t index)
end

function duck:list_type_child_type(type)
	return lib.duckdb_list_type_child_type(type) -- duckdb_logical_type duckdb_list_type_child_type(duckdb_logical_type type)
end

function duck:map_type_key_type(type)
	return lib.duckdb_map_type_key_type(type) -- duckdb_logical_type duckdb_map_type_key_type(duckdb_logical_type type)
end

function duck:map_type_value_type(type)
	return lib.duckdb_map_type_value_type(type) -- duckdb_logical_type duckdb_map_type_value_type(duckdb_logical_type type)
end

function duck:struct_type_child_count(type)
	return lib.duckdb_struct_type_child_count(type) -- idx_t duckdb_struct_type_child_count(duckdb_logical_type type)
end

function duck:struct_type_child_name(type, index)
	return lib.duckdb_struct_type_child_name(type, index) -- char duckdb_struct_type_child_name(duckdb_logical_type type, idx_t index)
end

function duck:struct_type_child_type(type, index)
	return lib.duckdb_struct_type_child_type(type, index) -- duckdb_logical_type duckdb_struct_type_child_type(duckdb_logical_type type, idx_t index)
end

function duck:destroy_logical_type(type)
	return lib.duckdb_destroy_logical_type(type) -- void duckdb_destroy_logical_type(duckdb_logical_type *type)
end

function duck:create_data_chunk(types, column_count)
	return lib.duckdb_create_data_chunk(types, column_count) -- duckdb_data_chunk duckdb_create_data_chunk(duckdb_logical_type *types, idx_t column_count)
end

function duck:destroy_data_chunk(chunk)
	return lib.duckdb_destroy_data_chunk(chunk) -- void duckdb_destroy_data_chunk(duckdb_data_chunk *chunk)
end

function duck:data_chunk_reset(chunk)
	return lib.duckdb_data_chunk_reset(chunk) -- void duckdb_data_chunk_reset(duckdb_data_chunk chunk)
end

function duck:data_chunk_get_column_count(chunk)
	return lib.duckdb_data_chunk_get_column_count(chunk) -- idx_t duckdb_data_chunk_get_column_count(duckdb_data_chunk chunk)
end

function duck:data_chunk_get_vector(chunk, col_idx)
	return lib.duckdb_data_chunk_get_vector(chunk, col_idx) -- duckdb_vector duckdb_data_chunk_get_vector(duckdb_data_chunk chunk, idx_t col_idx)
end

function duck:data_chunk_get_size(chunk)
	return tonumber(lib.duckdb_data_chunk_get_size(chunk)) -- idx_t duckdb_data_chunk_get_size(duckdb_data_chunk chunk)
end

function duck:data_chunk_set_size(chunk, size)
	return lib.duckdb_data_chunk_set_size(chunk, size) -- void duckdb_data_chunk_set_size(duckdb_data_chunk chunk, idx_t size)
end

function duck:vector_get_column_type(vector)
	return lib.duckdb_vector_get_column_type(vector) -- duckdb_logical_type duckdb_vector_get_column_type(duckdb_vector vector)
end

function duck:vector_get_data(vector)
	return lib.duckdb_vector_get_data(vector) -- void duckdb_vector_get_data(duckdb_vector vector)
end

function duck:vector_get_validity(vector)
	return lib.duckdb_vector_get_validity(vector) -- uint64_t duckdb_vector_get_validity(duckdb_vector vector)
end

function duck:vector_ensure_validity_writable(vector)
	return lib.duckdb_vector_ensure_validity_writable(vector) -- void duckdb_vector_ensure_validity_writable(duckdb_vector vector)
end

function duck:vector_assign_string_element(vector, index, str)
	return lib.duckdb_vector_assign_string_element(vector, index, str) -- void duckdb_vector_assign_string_element(duckdb_vector vector, idx_t index, const char *str)
end

function duck:vector_assign_string_element_len(vector, index, str, str_len)
	return lib.duckdb_vector_assign_string_element_len(vector, index, str, str_len) -- void duckdb_vector_assign_string_element_len(duckdb_vector vector, idx_t index, const char *str, idx_t str_len)
end

function duck:list_vector_get_child(vector)
	return lib.duckdb_list_vector_get_child(vector) -- duckdb_vector duckdb_list_vector_get_child(duckdb_vector vector)
end

function duck:list_vector_get_size(vector)
	return tonumber(lib.duckdb_list_vector_get_size(vector)) -- idx_t duckdb_list_vector_get_size(duckdb_vector vector)
end

function duck:struct_vector_get_child(vector, index)
	return lib.duckdb_struct_vector_get_child(vector, index) -- duckdb_vector duckdb_struct_vector_get_child(duckdb_vector vector, idx_t index)
end

function duck:validity_row_is_valid(validity, row)
	return lib.duckdb_validity_row_is_valid(validity, row) -- _Bool duckdb_validity_row_is_valid(uint64_t *validity, idx_t row)
end

function duck:validity_set_row_validity(validity, row, valid)
	return lib.duckdb_validity_set_row_validity(validity, row, valid) -- void duckdb_validity_set_row_validity(uint64_t *validity, idx_t row, _Bool valid)
end

function duck:validity_set_row_invalid(validity, row)
	return lib.duckdb_validity_set_row_invalid(validity, row) -- void duckdb_validity_set_row_invalid(uint64_t *validity, idx_t row)
end

function duck:validity_set_row_valid(validity, row)
	return lib.duckdb_validity_set_row_valid(validity, row) -- void duckdb_validity_set_row_valid(uint64_t *validity, idx_t row)
end

function duck:create_table_function()
	return lib.duckdb_create_table_function() -- duckdb_table_function duckdb_create_table_function()
end

function duck:destroy_table_function(table_function)
	return lib.duckdb_destroy_table_function(table_function) -- void duckdb_destroy_table_function(duckdb_table_function *table_function)
end

function duck:table_function_set_name(table_function, name)
	return lib.duckdb_table_function_set_name(table_function, name) -- void duckdb_table_function_set_name(duckdb_table_function table_function, const char *name)
end

function duck:table_function_add_parameter(table_function, type)
	return lib.duckdb_table_function_add_parameter(table_function, type) -- void duckdb_table_function_add_parameter(duckdb_table_function table_function, duckdb_logical_type type)
end

function duck:table_function_set_extra_info(table_function, extra_info, destroy)
	return lib.duckdb_table_function_set_extra_info(table_function, extra_info, destroy) -- void duckdb_table_function_set_extra_info(duckdb_table_function table_function, void *extra_info, duckdb_delete_callback_t destroy)
end

function duck:table_function_set_bind(table_function, bind)
	return lib.duckdb_table_function_set_bind(table_function, bind) -- void duckdb_table_function_set_bind(duckdb_table_function table_function, duckdb_table_function_bind_t bind)
end

function duck:table_function_set_init(table_function, init)
	return lib.duckdb_table_function_set_init(table_function, init) -- void duckdb_table_function_set_init(duckdb_table_function table_function, duckdb_table_function_init_t init)
end

function duck:table_function_set_local_init(table_function, init)
	return lib.duckdb_table_function_set_local_init(table_function, init) -- void duckdb_table_function_set_local_init(duckdb_table_function table_function, duckdb_table_function_init_t init)
end

function duck:table_function_set_function(table_function, functionPtr)
	return lib.duckdb_table_function_set_function(table_function, functionPtr) -- void duckdb_table_function_set_function(duckdb_table_function table_function, duckdb_table_function_t function)
end

function duck:table_function_supports_projection_pushdown(table_function, pushdown)
	return lib.duckdb_table_function_supports_projection_pushdown(table_function, pushdown) -- void duckdb_table_function_supports_projection_pushdown(duckdb_table_function table_function, _Bool pushdown)
end

function duck:register_table_function(functionPtr)
	return lib.duckdb_register_table_function(self.connection, functionPtr) -- duckdb_state duckdb_register_table_function(duckdb_connection con, duckdb_table_function function)
end

function duck:bind_get_extra_info(info)
	return lib.duckdb_bind_get_extra_info(info) -- void duckdb_bind_get_extra_info(duckdb_bind_info info)
end

function duck:bind_add_result_column(info, name, type)
	return lib.duckdb_bind_add_result_column(info, name, type) -- void duckdb_bind_add_result_column(duckdb_bind_info info, const char *name, duckdb_logical_type type)
end

function duck:bind_get_parameter_count(info)
	return lib.duckdb_bind_get_parameter_count(info) -- idx_t duckdb_bind_get_parameter_count(duckdb_bind_info info)
end

function duck:bind_get_parameter(info, index)
	return lib.duckdb_bind_get_parameter(info, index) -- duckdb_value duckdb_bind_get_parameter(duckdb_bind_info info, idx_t index)
end

function duck:bind_set_bind_data(info, bind_data, destroy)
	return lib.duckdb_bind_set_bind_data(info, bind_data, destroy) -- void duckdb_bind_set_bind_data(duckdb_bind_info info, void *bind_data, duckdb_delete_callback_t destroy)
end

function duck:bind_set_cardinality(info, cardinality, is_exact)
	return lib.duckdb_bind_set_cardinality(info, cardinality, is_exact) -- void duckdb_bind_set_cardinality(duckdb_bind_info info, idx_t cardinality, _Bool is_exact)
end

function duck:bind_set_error(info, error)
	return lib.duckdb_bind_set_error(info, error) -- void duckdb_bind_set_error(duckdb_bind_info info, const char *error)
end

function duck:init_get_extra_info(info)
	return lib.duckdb_init_get_extra_info(info) -- void duckdb_init_get_extra_info(duckdb_init_info info)
end

function duck:init_get_bind_data(info)
	return lib.duckdb_init_get_bind_data(info) -- void duckdb_init_get_bind_data(duckdb_init_info info)
end

function duck:init_set_init_data(info, init_data, destroy)
	return lib.duckdb_init_set_init_data(info, init_data, destroy) -- void duckdb_init_set_init_data(duckdb_init_info info, void *init_data, duckdb_delete_callback_t destroy)
end

function duck:init_get_column_count(info)
	return lib.duckdb_init_get_column_count(info) -- idx_t duckdb_init_get_column_count(duckdb_init_info info)
end

function duck:init_get_column_index(info, column_index)
	return lib.duckdb_init_get_column_index(info, column_index) -- idx_t duckdb_init_get_column_index(duckdb_init_info info, idx_t column_index)
end

function duck:init_set_max_threads(info, max_threads)
	return lib.duckdb_init_set_max_threads(info, max_threads) -- void duckdb_init_set_max_threads(duckdb_init_info info, idx_t max_threads)
end

function duck:init_set_error(info, error)
	return lib.duckdb_init_set_error(info, error) -- void duckdb_init_set_error(duckdb_init_info info, const char *error)
end

function duck:function_get_extra_info(info)
	return lib.duckdb_function_get_extra_info(info) -- void duckdb_function_get_extra_info(duckdb_function_info info)
end

function duck:function_get_bind_data(info)
	return lib.duckdb_function_get_bind_data(info) -- void duckdb_function_get_bind_data(duckdb_function_info info)
end

function duck:function_get_init_data(info)
	return lib.duckdb_function_get_init_data(info) -- void duckdb_function_get_init_data(duckdb_function_info info)
end

function duck:function_get_local_init_data(info)
	return lib.duckdb_function_get_local_init_data(info) -- void duckdb_function_get_local_init_data(duckdb_function_info info)
end

function duck:function_set_error(info, error)
	return lib.duckdb_function_set_error(info, error) -- void duckdb_function_set_error(duckdb_function_info info, const char *error)
end

function duck:add_replacement_scan(replacement, extra_data, delete_callback)
	return lib.duckdb_add_replacement_scan(self.database, replacement, extra_data, delete_callback) -- void duckdb_add_replacement_scan(duckdb_database db, duckdb_replacement_callback_t replacement, void *extra_data, duckdb_delete_callback_t delete_callback)
end

function duck:replacement_scan_set_function_name(info, function_name)
	return lib.duckdb_replacement_scan_set_function_name(info, function_name) -- void duckdb_replacement_scan_set_function_name(     duckdb_replacement_scan_info info, const char *function_name)
end

function duck:replacement_scan_add_parameter(info, parameter)
	return lib.duckdb_replacement_scan_add_parameter(info, parameter) -- void duckdb_replacement_scan_add_parameter(duckdb_replacement_scan_info info, duckdb_value parameter)
end

function duck:replacement_scan_set_error(info, error)
	return lib.duckdb_replacement_scan_set_error(info, error) -- void duckdb_replacement_scan_set_error(duckdb_replacement_scan_info info, const char *error)
end

function duck:appender_create(schema, table, out_appender)
	return lib.duckdb_appender_create(self.connection, schema, table, out_appender) -- duckdb_state duckdb_appender_create(duckdb_connection connection, const char *schema, const char *table, duckdb_appender *out_appender)
end

function duck:appender_error(appender)
	return lib.duckdb_appender_error(appender) -- const char duckdb_appender_error(duckdb_appender appender)
end

function duck:appender_flush(appender)
	return lib.duckdb_appender_flush(appender) -- duckdb_state duckdb_appender_flush(duckdb_appender appender)
end

function duck:appender_close(appender)
	return lib.duckdb_appender_close(appender) -- duckdb_state duckdb_appender_close(duckdb_appender appender)
end

function duck:appender_destroy(appender)
	return lib.duckdb_appender_destroy(appender) -- duckdb_state duckdb_appender_destroy(duckdb_appender *appender)
end

function duck:appender_begin_row(appender)
	return lib.duckdb_appender_begin_row(appender) -- duckdb_state duckdb_appender_begin_row(duckdb_appender appender)
end

function duck:appender_end_row(appender)
	return lib.duckdb_appender_end_row(appender) -- duckdb_state duckdb_appender_end_row(duckdb_appender appender)
end

function duck:append_bool(appender, value)
	return lib.duckdb_append_bool(appender, value) -- duckdb_state duckdb_append_bool(duckdb_appender appender, _Bool value)
end

function duck:append_int8(appender, value)
	return lib.duckdb_append_int8(appender, value) -- duckdb_state duckdb_append_int8(duckdb_appender appender, int8_t value)
end

function duck:append_int16(appender, value)
	return lib.duckdb_append_int16(appender, value) -- duckdb_state duckdb_append_int16(duckdb_appender appender, int16_t value)
end

function duck:append_int32(appender, value)
	return lib.duckdb_append_int32(appender, value) -- duckdb_state duckdb_append_int32(duckdb_appender appender, int32_t value)
end

function duck:append_int64(appender, value)
	return lib.duckdb_append_int64(appender, value) -- duckdb_state duckdb_append_int64(duckdb_appender appender, int64_t value)
end

function duck:append_hugeint(appender, value)
	return lib.duckdb_append_hugeint(appender, value) -- duckdb_state duckdb_append_hugeint(duckdb_appender appender, duckdb_hugeint value)
end

function duck:append_uint8(appender, value)
	return lib.duckdb_append_uint8(appender, value) -- duckdb_state duckdb_append_uint8(duckdb_appender appender, uint8_t value)
end

function duck:append_uint16(appender, value)
	return lib.duckdb_append_uint16(appender, value) -- duckdb_state duckdb_append_uint16(duckdb_appender appender, uint16_t value)
end

function duck:append_uint32(appender, value)
	return lib.duckdb_append_uint32(appender, value) -- duckdb_state duckdb_append_uint32(duckdb_appender appender, uint32_t value)
end

function duck:append_uint64(appender, value)
	return lib.duckdb_append_uint64(appender, value) -- duckdb_state duckdb_append_uint64(duckdb_appender appender, uint64_t value)
end

function duck:append_float(appender, value)
	return lib.duckdb_append_float(appender, value) -- duckdb_state duckdb_append_float(duckdb_appender appender, float value)
end

function duck:append_double(appender, value)
	return lib.duckdb_append_double(appender, value) -- duckdb_state duckdb_append_double(duckdb_appender appender, double value)
end

function duck:append_date(appender, value)
	return lib.duckdb_append_date(appender, value) -- duckdb_state duckdb_append_date(duckdb_appender appender, duckdb_date value)
end

function duck:append_time(appender, value)
	return lib.duckdb_append_time(appender, value) -- duckdb_state duckdb_append_time(duckdb_appender appender, duckdb_time value)
end

function duck:append_timestamp(appender, value)
	return lib.duckdb_append_timestamp(appender, value) -- duckdb_state duckdb_append_timestamp(duckdb_appender appender, duckdb_timestamp value)
end

function duck:append_interval(appender, value)
	return lib.duckdb_append_interval(appender, value) -- duckdb_state duckdb_append_interval(duckdb_appender appender, duckdb_interval value)
end

function duck:append_varchar(appender, val)
	return lib.duckdb_append_varchar(appender, val) -- duckdb_state duckdb_append_varchar(duckdb_appender appender, const char *val)
end

function duck:append_varchar_length(appender, val, length)
	return lib.duckdb_append_varchar_length(appender, val, length) -- duckdb_state duckdb_append_varchar_length(duckdb_appender appender, const char *val, idx_t length)
end

function duck:append_blob(appender, data, length)
	return lib.duckdb_append_blob(appender, data, length) -- duckdb_state duckdb_append_blob(duckdb_appender appender, const void *data, idx_t length)
end

function duck:append_null(appender)
	return lib.duckdb_append_null(appender) -- duckdb_state duckdb_append_null(duckdb_appender appender)
end

function duck:append_data_chunk(appender, chunk)
	return lib.duckdb_append_data_chunk(appender, chunk) -- duckdb_state duckdb_append_data_chunk(duckdb_appender appender, duckdb_data_chunk chunk)
end

function duck:query_arrow(query, out_result)
	return lib.duckdb_query_arrow(self.connection, query, out_result) -- duckdb_state duckdb_query_arrow(duckdb_connection connection, const char *query, duckdb_arrow *out_result)
end

function duck:query_arrow_schema(out_schema)
	return lib.duckdb_query_arrow_schema(self.result, out_schema) -- duckdb_state duckdb_query_arrow_schema(duckdb_arrow result, duckdb_arrow_schema *out_schema)
end

function duck:query_arrow_array(out_array)
	return lib.duckdb_query_arrow_array(self.result, out_array) -- duckdb_state duckdb_query_arrow_array(duckdb_arrow result, duckdb_arrow_array *out_array)
end

function duck:arrow_column_count()
	return lib.duckdb_arrow_column_count(self.result) -- idx_t duckdb_arrow_column_count(duckdb_arrow result)
end

function duck:arrow_row_count()
	return lib.duckdb_arrow_row_count(self.result) -- idx_t duckdb_arrow_row_count(duckdb_arrow result)
end

function duck:arrow_rows_changed()
	return lib.duckdb_arrow_rows_changed(self.result) -- idx_t duckdb_arrow_rows_changed(duckdb_arrow result)
end

function duck:query_arrow_error()
	return lib.duckdb_query_arrow_error(self.result) -- const char duckdb_query_arrow_error(duckdb_arrow result)
end

function duck:destroy_arrow()
	return lib.duckdb_destroy_arrow(self.result) -- void duckdb_destroy_arrow(duckdb_arrow *result)
end

function duck:execute_tasks(max_tasks)
	return lib.duckdb_execute_tasks(self.database, max_tasks) -- void duckdb_execute_tasks(duckdb_database database, idx_t max_tasks)
end

function duck:create_task_state()
	return lib.duckdb_create_task_state(self.database) -- duckdb_task_state duckdb_create_task_state(duckdb_database database)
end

function duck:execute_tasks_state(state)
	return lib.duckdb_execute_tasks_state(state) -- void duckdb_execute_tasks_state(duckdb_task_state state)
end

function duck:execute_n_tasks_state(state, max_tasks)
	return lib.duckdb_execute_n_tasks_state(state, max_tasks) -- idx_t duckdb_execute_n_tasks_state(duckdb_task_state state, idx_t max_tasks)
end

function duck:finish_execution(state)
	return lib.duckdb_finish_execution(state) -- void duckdb_finish_execution(duckdb_task_state state)
end

function duck:task_state_is_finished(state)
	return lib.duckdb_task_state_is_finished(state) -- _Bool duckdb_task_state_is_finished(duckdb_task_state state)
end

function duck:destroy_task_state(state)
	return lib.duckdb_destroy_task_state(state) -- void duckdb_destroy_task_state(duckdb_task_state state)
end

return duck
