--- lib/db/pgmoon/socket.lua
local useNativeSocket = true
local create_luasocket, create_native_socket
-- local seconds = require"util".seconds
-- local sendSec, receiveSec = 0, 0
-- local ret
local sendTime, receiveTime = 0, 0

do
	-- local flatten = require("pgmoon/util").flatten

	local proxy_mt = {
		__index = function(self, key)
			local sock = self.sock or self
			local original = sock[key]
			if type(original) == "function" then
				local fn = function(_, ...)
					--[[ if key == "receive" then
						receiveSec = seconds()
						ret = original(sock, ...)
						receiveTime = receiveTime + seconds(receiveSec)
						return ret
					else ]]
					return original(sock, ...)
					-- end
				end
				self[key] = fn
				return fn
			else
				return original
			end
		end
	}
	local method_overrides = {
		socketType = function()
			return useNativeSocket and "native" or "luasocket"
		end,
		resetTime = function()
			sendTime, receiveTime = 0, 0
		end,
		getTime = function()
			return sendTime, receiveTime
		end,
		send = function(self, ...)
			-- return self.sock:send(flatten(...))
			return self.sock:send(...)
		end,
		--[[ send = function(self, ...)
			local param = flatten(...)
			sendSec = seconds()
			ret = self.sock:send(param)
			sendTime = sendTime + seconds(sendSec)
			return ret
		end, ]]
		settimeout = function(self, t)
			if t then
				t = t / 1000
			end
			return self.sock:settimeout(t)
		end,
		setkeepalive = function(self)
			return error("You attempted to call setkeepalive on a LuaSocket socket. This method is only available for the ngx cosocket API for releasing a socket back into the connection pool")
		end,
		getreusedtimes = function(self, t)
			return 0
		end,
		sslhandshake = function(self, opts)
			if opts == nil then
				opts = {}
			end
			local ssl = require("ssl")
			local params = {mode = "client", protocol = "any", verify = "none", options = {"all", "no_sslv2", "no_sslv3", "no_tlsv1"}}
			for k, v in pairs(opts) do
				params[k] = v
			end
			local sec_sock, err = ssl.wrap(self.sock, params)
			if not (sec_sock) then
				return false, err
			end
			local success
			success, err = sec_sock:dohandshake()
			if not success then
				return false, err
			end
			for k, v in pairs(self) do
				if not method_overrides[k] and type(v) == "function" then
					self[k] = nil
				end
			end
			self.sock = sec_sock
			return true
		end
	}
	create_luasocket = function(...)
		local socket = require("socket")
		local proxy = {sock = socket.tcp(...)}
		for k, v in pairs(method_overrides) do
			proxy[k] = v
		end
		return setmetatable(proxy, proxy_mt)
	end
	create_native_socket = function()
		local socket = require "system/socket"
		local proxy = socket.new()
		proxy.sock = socket
		proxy.sock.socketType = method_overrides.socketType
		proxy.sock.getreusedtimes = function()
			return 0
		end
		return proxy
		--[[ for k, v in pairs(method_overrides) do
			proxy[k] = v
		end
		return setmetatable(proxy, proxy_mt) ]]
	end
end

return {
	create_luasocket = create_luasocket,
	new = function(socket_type)
		if socket_type == nil then
			if useNativeSocket then
				socket_type = "native"
			elseif ngx and ngx.get_phase() ~= "init" then
				socket_type = "nginx"
			else
				socket_type = "luasocket"
			end
		end
		local socket
		local _exp_0 = socket_type
		if "native" == _exp_0 then
			socket = create_native_socket()
		elseif "nginx" == _exp_0 then
			socket = ngx.socket.tcp()
		elseif "luasocket" == _exp_0 then
			socket = create_luasocket()
		elseif "cqueues" == _exp_0 then
			socket = require("pgmoon/cqueues").CqueuesSocket()
		else
			socket = error("got unknown or unset socket type: " .. tostring(socket_type))
		end
		return socket, socket_type
	end
}
