--- lib/db/uuid-4d.lua
-- 4D Method: code_UUIDGet.lua
local uuid4d = {}

local util = require "util"
local dconn = require "dconn"
local dsql = require "dsql"
local dschema = require "dschema"
local dt = require "dt"
local base36 = require "base36"
local mac
local loc = {}

local function macAddress()
	if mac then
		return mac
	end
	mac = require"system/net".getMacAddress()
	mac = mac:gsub(":", "")
	return mac
end

local tblChange = {cha = "_cha", lnk = "_lnk", prf = "_prf", rep = "_rep"}
local uuidCounter = 0
local currentProcess = base36.encodeDigits(999 % 1296, 2) -- currentProcess == 999

--[[
%H	hour, using a 24-hour clock (23) [00-23]
%M	minute (48) [00-59]
%S	second (10) [00-61]
]]
local function milliseconds()
	local ms = util.milliSeconds() -- milliSeconds is too slow for lua, but counter to 46655 helps, takes 0.65 secs to create counter amounts
	return math.floor(ms) % 1000
end

local function getSiteCode()
	if loc.site_code == nil then
		local sel, info = dsql.sqlExecuteUnsafe("SELECT text_value FROM _preference WHERE name_id = '_code_SiteCode'", {"text_value"}, {"string"})
		if not sel[1] then
			util.printError("site code could not be retrieved from 4D")
		else
			loc.site_code = sel[1].text_value -- see site_codes.dhtm
			loc.site_code = loc.site_code:sub(1, 3) .. "9" -- change last digit to 9, separate from records added in 4D
		end
	end
	return loc.site_code
end

function uuid4d.uuid(tableName, recordType)
	local ms = milliseconds()
	local prevOrg = dconn.setCurrentOrganization("4d") -- auth.setCurrentOrganization("4d")
	dsql.setConnection({table = tableName, record_type = recordType}, "uuid4d.uuid()") -- todo: is this needed?
	local prefix = dschema.tablePrefixSql(tableName)
	local siteCode = getSiteCode()
	dconn.setCurrentOrganization(prevOrg) -- auth.setCurrentOrganization(prevOrg)
	-- dconn.restoreConnection(prevConn)
	-- Check how this should work? It is global in 4D
	--  increase_counter, loop_back_if_reached_36^3 = 46656
	if prefix == nil then
		return "" -- error here
	end
	if uuidCounter >= 46655 then
		uuidCounter = 0
	else
		uuidCounter = uuidCounter + 1
	end --  a_looping_counter_with_three_chars, packed_to_base36
	local tblString = ((tblChange[prefix] or prefix) .. "_    "):sub(1, 5)
	local uuid = dt.currentFormat("%Y%m%d.%H%M%S.") .. base36.encodeDigits(ms, 2) .. base36.encodeDigits(uuidCounter, 3) .. "." .. tblString .. siteCode .. macAddress() .. currentProcess
	return uuid:lower()
	--  date_in_format 'YYYYMMDD.HHMMSS.'
	-- milliseconds_with_two_chars, packed_to_base36
	--  tbl_id_in_5_chars
	-- we should get table prefix. We may try to use it with tableNameToPrefix-function in database.lua
	-- uuid = uuid + Substring((_tbl_NumToIdStr(code_lTblNum) .. "     "), 1, 5) --  site_code_with_four_chars, packed_to_base36
	-- uuid = uuid + mac --  mac_address_with_12_chars+"."
	-- uuid = uuid + g["_code_tMACAddress"] --  current_process_number_with_two_chars, packed_to_base36
	-- uuid = uuid + _longToBase36(Current_process % 1296, 2) -- CLEAR_SEMAPHORE(code_tSemaphore)
	-- _0 = Lowercase(uuid, "*")
end

return uuid4d
