--- cairo_load_win.lua
-- https://github.com/jcupitt/lua-vips/issues/12#issuecomment-309730843
-- @module graphics
local cairo = {}

local util = require "util"
local ffi = require "mffi"

if util.isWin() then
	local pathBin = util.pathBin()
	if util.from4d() then
		-- old cairo
		util.loadDll(pathBin .. "cairo_old/z.dll")
		util.loadDll(pathBin .. "cairo_old/bz2.dll")
		util.loadDll(pathBin .. "cairo_old/png.dll")
		util.loadDll(pathBin .. "cairo_old/regal.dll")
		util.loadDll(pathBin .. "cairo_old/freetype2.dll")
		util.loadDll(pathBin .. "cairo_old/pixman.dll")
		cairo.cairo = util.loadDll(pathBin .. "cairo_old/cairo.dll")
		-- print("cairo_old, C: "..tostring(C))
	else
		util.loadDll("clang/libunwind.dll")
		util.loadDll("clang/libc++.dll")
		util.loadDll("graphics/libwinpthread-1.dll")
		util.loadDll("graphics/libiconv-2.dll") -- x64
		if ffi.arch == "x86" then
			util.loadDll("graphics/libgcc_s_sjlj-1.dll")
			util.loadDll("graphics/libgcc_s_dw2-1.dll")
			util.loadDll("graphics/zlib1.dll")
		else
			require "brotli/decoder"
			util.loadDll("graphics/libgcc_s_seh-1.dll")
			util.loadDll("graphics/libstdc++-6.dll")
			util.loadDll("graphics/zlib1.dll")
			util.loadDll("graphics/libintl-8.dll")
			util.loadDll("graphics/vips/libffi-8.dll")
			--	util.loadDll("graphics/vips/libz1.dll")
			util.loadDll("graphics/vips/libpcre2-8-0.dll")
			cairo.glib = util.loadDll("graphics/vips/libglib-2.0-0.dll")
			util.loadDll("graphics/vips/libgmodule-2.0-0.dll")
			cairo.gobject = util.loadDll("graphics/vips/libgobject-2.0-0.dll")
			util.loadDll("graphics/vips/libgio-2.0-0.dll")
			util.loadDll("graphics/vips/libgmodule-2.0-0.dll")
			util.loadDll("graphics/vips/libharfbuzz-0.dll", "no-init") -- needs libfreetype-6.dll
			util.loadDll("graphics/vips/libiconv-2.dll")
			-- util.loadDll("graphics/vips/liblzma-5.dll")
			util.loadDll("graphics/vips/libbz2-1.dll")
		end
		util.loadDll("graphics/vips/libpng16-16.dll")
		util.loadDll("graphics/vips/liblzma-5.dll")
		util.loadDll("graphics/vips/libxml2-2.dll")
		util.loadDll("graphics/vips/libexpat-1.dll")
		util.loadDll("graphics/vips/libfreetype-6.dll")
		util.loadDll("graphics/vips/libfontconfig-1.dll")
		util.loadDll("graphics/vips/libpixman-1-0.dll")
		cairo.cairo = util.loadDll("graphics/vips/libcairo-2.dll")
		-- util.loadDll("graphics/vips/libcairo-gobject-2.dll")
	end
end

return cairo
