-- local pdf = require "hpdf"
local hpdf, haru
local pages, page, fonts, images -- , encoders

local function hpdfInit(paper)
	if haru == nil then
		haru = require "resty.haru" -- this will fail inside 4d
	end
	if hpdf == nil then

		hpdf = haru.new()
		pages = hpdf.pages
		fonts = hpdf.fonts
		images = hpdf.images
		-- encoders = hpdf.encoders
		-- local mediaPath = util.mainPath().."test/media/"
		-- local fontName  = fonts:load(mediaPath.."DejaVuSans.ttf", true)

		-- General Settings
		hpdf:use "utfencodings"
		--[[
		hpdf:use "jpencodings"
		hpdf:use "krencodings"
		hpdf:use "cnsencodings"
		hpdf:use "cntencodings"
		hpdf:use "jpfonts"
		hpdf:use "krfonts"
		hpdf:use "cnsfonts"
		hpdf:use "cntfonts"
		]]

		-- Setting General Properties
		hpdf.encoding = "UTF-8"
		hpdf.pagelayout = "single"
		hpdf.pagemode = "outline"
		-- local helvetica = fonts:get "Helvetica"
	end

	hpdf.author = "@Capacic"
	hpdf.creator = "Capacic"
	hpdf.title = "Capacic"
	hpdf.subject = ""
	hpdf.keywords = "" -- "openresty pdf haru lua luajit ffi"
	local dateRec = os.date("*t")
	local timeZone = dt.currentTimeZone()
	local timeRec = {dateRec.year, dateRec.month, dateRec.day, dateRec.hour, dateRec.min, dateRec.sec, timeZone:sub(1, 1), tonumber(timeZone:sub(2, 3)), tonumber(timeZone:sub(4, 5))}
	hpdf.creationdate = timeRec
	hpdf.modificationdate = timeRec -- you can't copy hpdf.creationdate to hpdf.modificationdate, metatables in use
	page = pages:add()
	local paperType = paper.paperType:lower()
	local orientation = peg.found(paperType, "landscape") and "landscape" or "portrait"
	page:size(paperType, orientation) -- landscape, portrait

	-- Setting a Font
	local fontSize = 14
	local helvetica = fonts:get("Helvetica") -- , "UTF-8") does not work here
	if ffi.isNotNull(helvetica) then
		page:font(helvetica, fontSize)
	else
		util.printWarning("* hpdf could not get Helvetica font, using DejaVuSans.ttf")
		local mediaPath = util.mainPath() .. "test/media/"
		local fontName = fonts:load(mediaPath .. "DejaVuSans.ttf", true)
		local dejavu = fonts:get(fontName, "UTF-8")
		page:font(dejavu, fontSize)
	end
end

-- local imageArr = {}
local function pictHpdf(ref, style, x, y, width, height, filePath)
	local img = images:load(filePath)
	-- Image Properties
	local w = img.width
	local h = img.height
	-- print(img.colorspace)
	-- print(img.bitspercomponent)
	-- dump(img.size)

	-- Setting Image Properties
	--[[img.colormask = {
			rmin = 50,
			rmax = 150,
			gmin = 50,
			gmax = 150,
			bmin = 50,
			bmax = 150
	}
	]]
	style = style or {}
	style.scaling = style.scaling or "fit"
	style["text-align"] = style["text-align"] or "center"
	style["vertical-align"] = style["vertical-align"] or "middle"
	local scaleW = 1
	local scaleH = 1
	if style.scaling == "fit" then
		scaleW = width / w
		scaleH = height / h
		if scaleW > scaleH then -- make scale proportional
			scaleW = scaleH
		else
			scaleH = scaleW
		end
	end
	if style["text-align"] == "center" then
		local scaledWidth = w * scaleW
		local moveX = (width - scaledWidth) / 2
		x = x + moveX
	end
	if style["vertical-align"] == "middle" then
		local scaledHeight = h * scaleH
		local moveY = (height - scaledHeight) / 2
		y = y + moveY -- y is at the bottom; 0,0 is in the lower left corner
	end
	if style.scaling == "fit" then -- scaleW == scaleH here
		width = scaleW * w -- use style pict margin to fit on to box(?)
		height = scaleH * h
	end
	-- draw image
	page:image(img, x, y, width, height)
end

local function newDocumentHpdf(pref)
	if hpdf == nil then
		hpdfInit(pref.paper)
	end
end

local function toPictureHpdf(ref)
	hpdf:save(ref.file_name)
	-- hpdf:free() --needed something like this?
	-- hpdf = nil
	pictureData = nil
	return ref.file_name
end
