-- draw-util.lua
local util = require "util"
local l = require"lang".l

local function colorToRgba(name)
	if name == "black" then
		return 0, 0, 0, 1
	elseif name == "white" then
		return 1, 1, 1, 1
		-- elseif name == "grey" then
		-- return 0, 0, 0, 0.5
	end
	if name.r and name.g and name.b then
		return name.r, name.g, name.b, (name.a or 1)
	end
	util.printError(l("unknown color name '%s'", name))
	return 0, 0, 0, 1
end

local function colorToRgbaName(name)
	local r, g, b, a = colorToRgba(name)
	return "rgba(" .. r .. "," .. g .. "," .. b .. "," .. a .. ")"
end

local function colorToRgbaTable(name)
	local r, g, b, a = colorToRgba(name)
	return {r = r, g = g, b = b, a = a}
end

return {colorToRgba = colorToRgba, colorToRgbaName = colorToRgbaName, colorToRgbaTable = colorToRgbaTable}
