-- lib/draw/rsvg.lua
-- https://developer.gnome.org/rsvg/stable/RsvgHandle.html#rsvg-handle-new-from-data

local util = require "util"
local ffi = require "mffi"
require "ffi_def_glib"
require "draw/cairo_h"

local lib
if util.isWin() then
	lib = util.loadDll("graphics/vips/librsvg-2-2.dll") -- x64
elseif util.isMac() then
	lib = util.loadDll("graphics/vips/librsvg-2.2.dylib")
elseif util.isLinux() then
	-- C = util.loadDll("libpixman.so")
	lib = util.loadDll("graphics/vips/librsvg-2.so.2")
end

-- const guint librsvg_major_version;
-- const guint librsvg_minor_version;
-- const guint librsvg_micro_version;
ffi.cdef[[
// typedef struct _RsvgHandle RsvgHandle;
typedef struct {
    GObject parent;
    gpointer _abi_padding[16];
} RsvgHandle;
void	rsvg_init();
void rsvg_handle_free(RsvgHandle *handle);
RsvgHandle * rsvg_handle_new_from_data(const guint8 *data, gsize data_len, GError **error);
gboolean rsvg_handle_render_cairo(RsvgHandle *handle, cairo_t *cr);
gboolean rsvg_handle_render_cairo_sub(RsvgHandle *handle, cairo_t *cr, const char *id);
]]

return lib