--- lib/xlswrite.lua
-- https://github.com/jmcnamara/libxlsxwriter
local xlswrite = {}

local ffi = require "mffi"
local C = ffi.C
local util = require "util"
local fs = require "fs"
local xls = require "excel/xlswrite_ffi"

local function checkError(err)
	if err ~= 0 then
		util.printError("xlswrite error: %s", tostring(err))
	end
	return err
end

function xlswrite.test()
	--[[
	worksheet_write_string()
	worksheet_write_number()
	worksheet_write_formula()
	worksheet_write_datetime()
	worksheet_write_unixtime()
	worksheet_write_blank()
	lxw_doc_properties properties = {
    .title    = "This is an example spreadsheet",
    .subject  = "With document properties",
    .author   = "John McNamara",
    .manager  = "Dr. Heinz Doofenshmirtz",
    .company  = "of Wolves",
    .category = "Example spreadsheets",
    .keywords = "Sample, Example, Properties",
    .comments = "Created with libxlsxwriter",
    .status   = "Quo",
};

// Set the properties in the workbook.
workbook_set_properties(workbook, &properties);
	]]
	-- Create a new workbook and add a worksheet.
	local path = fs.filePathFix("~/nc-pdf/")
	local outputFile = path .. "demo.xlsx"
	local sheetName = "Demo -sheet"
	local nilFormat = nil
	local options = ffi.newNoAnchor("lxw_workbook_options")
	options.constant_memory = C.LXW_FALSE
	options.tmpdir = nil
	options.use_zip64 = C.LXW_TRUE
	local workbook = xls.workbook_new_opt(outputFile, options)
	local worksheet = xls.workbook_add_worksheet(workbook, sheetName)
	local datetime = ffi.newNoAnchor("lxw_datetime")
	datetime.year = 2013
	datetime.month = 1
	datetime.day = 13
	-- Add a boldFormat.
	local boldFormat = xls.workbook_add_format(workbook)
	xls.format_set_bold(boldFormat) -- Set the bold property for the boldFormat
	local moneyFormat = xls.workbook_add_format(workbook)
	xls.format_set_num_format(moneyFormat, "### ##0.00")
	local moneyBoldFormat = xls.workbook_add_format(workbook)
	xls.format_set_num_format(moneyBoldFormat, "### ##0.00")
	xls.format_set_bold(moneyBoldFormat)
	local dateFormat = xls.workbook_add_format(workbook)
	xls.format_set_num_format(dateFormat, "yyyy-mm-dd")

	checkError(xls.worksheet_set_column(worksheet, 0, 0, 20, nilFormat)) -- Change the column width for clarity.
	checkError(xls.worksheet_set_column(worksheet, 0, 1, 20, nilFormat))
	-- Write some simple text.
	checkError(xls.worksheet_write_string(worksheet, 0, 0, "Hello", nilFormat))
	-- Text with formatting.
	checkError(xls.worksheet_write_string(worksheet, 1, 0, "World", boldFormat))
	-- Write some numbers.
	checkError(xls.worksheet_write_number(worksheet, 2, 0, 123, moneyFormat))
	checkError(xls.worksheet_write_number(worksheet, 3, 0, 123.456, moneyFormat))
	checkError(xls.worksheet_write_datetime(worksheet, 3, 1, datetime, dateFormat))
	checkError(xls.worksheet_write_formula(worksheet, 4, 0, "=SUM(A3:A4)", moneyBoldFormat))
	checkError(xls.worksheet_write_string(worksheet, 4, 1, "sum", boldFormat))
	--[[ for i = 6, 10000 do
			checkError(xls.worksheet_write_number(worksheet, i, 0, i, moneyFormat))
		end ]]
	-- checkError(xls.worksheet_write_datetime(worksheet, row, col + 1, &expenses[i].datetime, date_format))
	-- Insert an image.
	-- checkError(xls.worksheet_insert_image(worksheet, 1, 2, "logo.png"))
	checkError(xls.workbook_close(workbook))
	fs.openFile(path) -- fs.openFile(outputFile)
end

return xlswrite
