--- execute.lua
-- old is in execute_old.lua
-- executes new format json code
-- todo: generate this to real lua or javascript code and cache it
-- todo: use this syntax - with 1-based indexes?, http://jmespath.org/tutorial.html
--  https://github.com/jmespath/jmespath.lua
-- @ module execute
local execute = {}

local l = require"lang".l
local util = require "util"
local json = require "json"
local peg = require "peg"
local recdata = require "recdata"
local unpack = table.unpack
local concat = table.concat
local recData, recDataSet = recdata.get, recdata.set
local runStatement -- forward declaration
local allowedFunction, allowDataParameter, allowExtraDataParameter

local function loadAllowedPrf()
	local prf = util.prf("auth/allowed_function.json")
	allowedFunction = prf.allowed_function
	allowDataParameter = prf.allow_data_parameter
	allowExtraDataParameter = prf.allow_extra_data_parameter
	return prf.allowed_function
end

local function checkAllowedName(name)
	if type(name) ~= "string" then
		return nil
	end
	local prf = allowedFunction or loadAllowedPrf()
	if prf == nil then
		return nil
	end
	name = prf[name]
	if name == nil then
		return nil
	end
	return name
end

--[[ local function runAssign(code)

end ]]

local function runIf(code, paramArr, data, saveData, parameter)
	local value, err
	if paramArr[1] == nil then
		err = util.printError("execute if, parameter 1 is nil, code '%s'", json.toJsonRaw(code))
	elseif paramArr[3] == nil then
		err = util.printError("execute if, parameter 3 is nil, code '%s'", json.toJsonRaw(code))
	elseif paramArr[2] == "=" then
		value = paramArr[1] == paramArr[3]
	elseif paramArr[2] == "<>" then
		value = paramArr[1] ~= paramArr[3]
	elseif paramArr[2] == ">" then
		value = paramArr[1] > paramArr[3]
	elseif paramArr[2] == ">=" then
		value = paramArr[1] >= paramArr[3]
	elseif paramArr[2] == "<" then
		value = paramArr[1] < paramArr[3]
	elseif paramArr[2] == "<=" then
		value = paramArr[1] <= paramArr[3]
	else
		err = util.printError("execute if, unknown operator '%s', code '%s'", tostring(paramArr[2]), json.toJsonRaw(code))
	end
	if err == nil then
		local tag
		if value and code["then"] then -- true
			tag = "then"
		elseif code["else"] then -- false
			tag = "else"
		elseif code["then"] == nil then
			err = util.printError("execute if, tags 'then' and 'else' are missing, use at least one, code '%s'", json.toJsonRaw(code))
		end
		local codeArr = tag and code[tag]
		if codeArr then
			if type(codeArr[1]) == "table" and codeArr[1]["function"] then
				for _, code2 in ipairs(codeArr) do
					value, err = runStatement(code2, data, saveData, parameter)
					if err then
						return false, value, err
					end
				end
			else
				err = util.printError("execute if, result tag '%s' is not valid code array, code '%s'", tag, json.toJsonRaw(code))
			end
		end
	end
	return err == nil, value, err
end

function execute.getFunction(code)
	local functionName = type(code) == "table" and code["function"] or code
	if functionName == "=" then -- shortcut for assign
		return "="
	elseif functionName == "if" then -- shortcut for assign
		return "if"
	end
	local funcName = functionName and checkAllowedName(functionName)
	if funcName == nil then
		local err = l("function '%s' is not listed in allowed functions", tostring(functionName or json.toJsonRaw(code)))
		util.printError(err)
		return nil, err
	end
	local func
	if type(funcName) == "function" then
		func = funcName
	else
		local funcPart = peg.splitToArray(funcName, ".")
		for i, part in ipairs(funcPart) do
			if i == 1 then
				-- util.modulePrefixToFilename(part)
				local ok
				ok, func = pcall(require, part) -- will fail wth func == "module xxx not found..."
				if ok == false then
					local err = l('module load error "%s", function \'%s\' in module \'%s\' is not valid', func, tostring(functionName), part) -- func is pcall error in case of load error
					util.printError(err)
					return nil, err
				end
			elseif type(func) == "table" then
				func = func[part]
				if func == nil then
					local err = l("function '%s' part '%s' is not a function in allowed functions", tostring(functionName), tostring(part))
					util.printError(err)
					return nil, err
				end
			else
				local err = l("function '%s' part '%s' is not a function", tostring(functionName), tostring(part))
				util.printError(err)
				return nil, err
			end
		end
	end
	return func
end

runStatement = function(code, data, saveData, parameter)
	local func, err = execute.getFunction(code)
	if func == nil then
		return nil, err
	end
	local paramArr
	if code.parameter then -- parameter array is not mandatory
		paramArr = {}
		local paramData
		for _, param in ipairs(code.parameter) do
			if type(param) == "table" and param["function"] then
				paramArr[#paramArr + 1] = runStatement(param, data, saveData, parameter) -- recursive call
			elseif type(param) == "table" and param.tag ~= nil then
				paramData = recData(data, param.tag)
				if paramData == nil then
					paramData = recData(saveData, param.tag)
				end
				if paramData ~= nil then
					paramArr[#paramArr + 1] = paramData
				end
			elseif type(param) == "table" and param.value ~= nil then
				-- fix for: do not use strings as field tag values
				paramArr[#paramArr + 1] = param.value
			elseif type(param) == "string" then
				-- do not use strings as field tag values, use {"tag": "prwo.produced_amount"} to get value from the data
				paramData = recData(data, param)
				if paramData == nil and data ~= saveData then
					paramData = recData(saveData, param)
				end
				if paramData ~= nil then
					paramArr[#paramArr + 1] = paramData
				elseif type(param) ~= "table" then
					paramArr[#paramArr + 1] = param -- static value
				end
			else -- boolean, number
				paramArr[#paramArr + 1] = param
			end
		end
	end
	local ok, value
	if func == "=" then -- multiple assign does not work here
		ok, value, err = true, paramArr[1], nil
	elseif func == "if" then -- multiple assign does not work here
		ok, value, err = runIf(code, paramArr, data, saveData)
	else
		if paramArr then
			if parameter ~= nil and allowDataParameter[code["function"]] then
				paramArr[#paramArr + 1] = parameter
			end
			if allowExtraDataParameter[code["function"]] then
				paramArr[#paramArr + 1] = data
			end
			ok, value, err = pcall(func, unpack(paramArr)) -- this call can't have saveData as 3. param because table.unpack() does not work in that case
		else
			-- bookmark for debugging
			ok, value, err = pcall(func, data, saveData, parameter)
		end
	end
	if not ok then
		err = value
		value = nil
	elseif type(value) == "table" and value.error then
		err = value.error
	end
	if err then
		if peg.found(err, "socket will be closed") then
			util.printWarning("code function '%s' error '%s', code: '\n%s'", code["function"], err, json.toJson(code) or "")
		else
			util.printError("code function '%s' error '%s', code: '\n%s'", code["function"], err, json.toJson(code) or "")
		end
	end
	if code.result and value ~= nil then
		if code.append_result then
			local prevData = recData(saveData, code.result)
			if util.isArray(prevData) and util.isArray(value) then
				util.arrayConcat(prevData, value) -- test this
				value = prevData
			elseif type(prevData) == "string" and type(value) == "string" then
				value = peg.concatWith(code.append_result, prevData, value)
			else
				util.printError("runStatement append_result prevData type '%s' and value type '%s' are not compatible", type(prevData), type(value))
			end
		end
		recDataSet(saveData, code.result, value)
	end
	return value, err
end

function execute.runCode(codeArr, data, saveData, parameter)
	local ret, err
	if type(codeArr) == "string" then -- use like this: [{ "function": "nc-database-editor.database" }]
		util.printWarning("fix execute string '%s', it should be [{ \"function\": \"%s\" }]", codeArr, codeArr)
		codeArr = {codeArr}
	end
	for line, code in ipairs(codeArr) do
		ret, err = runStatement(code, data, saveData, parameter) -- we do not need result here, result is in saveData
		if err then
			return l("%s \n - error in execute code line %d", err, line)
		end
	end
	if ret and type(ret) == "table" then
		if saveData and next(saveData) == nil then
			util.recToRec(saveData, ret)
		end
		if ret.error then
			return ret.error
		end
	end
	if parameter and parameter.return_value then
		return ret
	end
end

function execute.runCodeWeb(parameter)
	return execute.runCode(parameter.run_code, parameter, parameter, {return_value = true})
end

function execute.runFunction(funcName, data, parameter)
	local ret, err
	parameter = parameter or {}
	if type(funcName) ~= "string" then -- use like this: [{ "function": "nc-database-editor.database" }]
		err = util.printError("execute function type '%s' is not a string", type(funcName))
	elseif type(parameter) ~= "table" then -- use like this: [{ "function": "nc-database-editor.database" }]
		err = util.printError("execute function parameter type '%s' is not a table", type(parameter))
	else
		local code = {["function"] = funcName, parameter = parameter} -- , ["return"] = ret
		local saveData = {}
		ret, err = runStatement(code, data, saveData, parameter) -- we do not need result here, result is in saveData
	end
	if err then
		return nil, l("%s \n - error in execute function", err)
	end
	return ret
end

local function calculate(...)
	local arg = {...}
	local funcStr = "return function() return " .. concat(arg, " ") .. " end"
	local func, err = load(funcStr)
	if func then
		local ok, ret = pcall(func())
		if ok then
			return ret
		else
			err = util.printRed("calculate execution error: '%s'", ret)
		end
	else
		err = util.printRed("calculate compilation error: '%s'", err)
	end
	return nil, err
end
execute.calculate = calculate

function execute.calculateRec(rec, ...)
	-- local ret = execute.calculateRec({a = 1, b = 3}, "(", "a", "+", "b", ") / 2") -- returns 2
	local arg = {...}
	local arg2 = {}
	for i = 1, #arg do
		if type(arg[i]) == "string" then
			arg2[i] = recData(rec, arg[i]) or arg[i]
		end
	end
	calculate(unpack(arg2))
end

return execute
