-- lib/ffi_def_glib.lua
local ffi = require "ffi" -- must not be require "mffi"

if ffi.arch == "x64" then
ffi.cdef [[
typedef signed long long gssize;
typedef unsigned long long gsize;
typedef unsigned long long GType;
/*
#if     GLIB_SIZEOF_SIZE_T != GLIB_SIZEOF_LONG || !defined __cplusplus
typedef gsize                           GType;
#else   /* for historic reasons, C++ links against gulong GTypes * /
typedef gulong                          GType;
#endif */
]]
else
ffi.cdef [[
typedef signed int gssize;
typedef unsigned int gsize;
typedef unsigned int GType;
]]
end
ffi.cdef [[
// https://people.gnome.org/~desrt/glib-docs/glib-Basic-Types.html
typedef signed int gint32;
typedef unsigned short guint16;
typedef unsigned int guint32;
typedef unsigned char guint8;
typedef char   gchar;
typedef int    gint;
typedef unsigned int    guint;
typedef gint   gboolean;
typedef void* gpointer;
typedef guint32 GQuark;

typedef struct {
	/* In the real glib, this is a GQuark, but we dont use/need that */
	gpointer domain;
	gint     code;
	gchar   *message;
} GError;

// typedef struct _GPtrArray		GPtrArray;
typedef struct {
  gpointer *pdata;
  guint	    len;
} GPtrArray;

// typedef struct _GArray		GArray;
typedef struct {
  gchar *data;
  guint len;
} GArray;

typedef struct
{
  GQuark   quark;
  gpointer data;
} QData;

typedef struct GData
{
  guint  n_qdatas;
  QData *qdatas;
} GData;

typedef struct
{
  GType g_type;
} GTypeClass;

typedef struct
{
  GTypeClass *g_class;
} GTypeInstance;

typedef struct
{
  GTypeInstance  g_type_instance;
  volatile guint ref_count;
  GData         *qdata;
} GObject;

typedef struct _GHashTable  GHashTable;
typedef struct _GList GList;

void* g_malloc(size_t size);
void* g_malloc0(size_t size);
void g_free(void* data);
]]
