-- ffi_def_linux.lua
local ffi = require "mffi"

-- handmade basic types
ffi.cdef [[
	// these are/should be in sys/types.h, but is this safe universal way?

	// #define __char signed char
	typedef signed char __char;

]]

ffi.cdef [[
	// bad define macros, done by hand
	struct in6_addr
		{
			union
				{
		uint8_t	__u6_addr8[16];
		uint16_t __u6_addr16[8];
		uint32_t __u6_addr32[4];
				} __in6_u;
	};

	// bad order of generated calls

	// missing generation - code these
	static const int PF_INET = 2;
	static const int PF_INET6 = 10;

]]

ffi.cdef [[
	// bad enums, done by hand
	enum
  {
    _SC_ARG_MAX,
    _SC_CHILD_MAX,
    _SC_CLK_TCK,
    _SC_NGROUPS_MAX,
    _SC_OPEN_MAX,
    _SC_STREAM_MAX,
    _SC_TZNAME_MAX,
    _SC_JOB_CONTROL,
    _SC_SAVED_IDS,
    _SC_REALTIME_SIGNALS,
    _SC_PRIORITY_SCHEDULING,
    _SC_TIMERS,
    _SC_ASYNCHRONOUS_IO,
    _SC_PRIORITIZED_IO,
    _SC_SYNCHRONIZED_IO,
    _SC_FSYNC,
    _SC_MAPPED_FILES,
    _SC_MEMLOCK,
    _SC_MEMLOCK_RANGE,
    _SC_MEMORY_PROTECTION,
    _SC_MESSAGE_PASSING,
    _SC_SEMAPHORES,
    _SC_SHARED_MEMORY_OBJECTS,
    _SC_AIO_LISTIO_MAX,
    _SC_AIO_MAX,
    _SC_AIO_PRIO_DELTA_MAX,
    _SC_DELAYTIMER_MAX,
    _SC_MQ_OPEN_MAX,
    _SC_MQ_PRIO_MAX,
    _SC_VERSION,
    _SC_PAGESIZE,
    _SC_RTSIG_MAX,
    _SC_SEM_NSEMS_MAX,
    _SC_SEM_VALUE_MAX,
    _SC_SIGQUEUE_MAX,
    _SC_TIMER_MAX,
    _SC_BC_BASE_MAX,
    _SC_BC_DIM_MAX,
    _SC_BC_SCALE_MAX,
    _SC_BC_STRING_MAX,
    _SC_COLL_WEIGHTS_MAX,
    _SC_EQUIV_CLASS_MAX,
    _SC_EXPR_NEST_MAX,
    _SC_LINE_MAX,
    _SC_RE_DUP_MAX,
    _SC_CHARCLASS_NAME_MAX,
    _SC_2_VERSION,
    _SC_2_C_BIND,
    _SC_2_C_DEV,
    _SC_2_FORT_DEV,
    _SC_2_FORT_RUN,
    _SC_2_SW_DEV,
    _SC_2_LOCALEDEF,
    _SC_PII,
    _SC_PII_XTI,
    _SC_PII_SOCKET,
    _SC_PII_INTERNET,
    _SC_PII_OSI,
    _SC_POLL,
    _SC_SELECT,
    _SC_UIO_MAXIOV,
    _SC_IOV_MAX = _SC_UIO_MAXIOV,
    _SC_PII_INTERNET_STREAM,
    _SC_PII_INTERNET_DGRAM,
    _SC_PII_OSI_COTS,
    _SC_PII_OSI_CLTS,
    _SC_PII_OSI_M,
    _SC_T_IOV_MAX,
    _SC_THREADS,
    _SC_THREAD_SAFE_FUNCTIONS,
    _SC_GETGR_R_SIZE_MAX,
    _SC_GETPW_R_SIZE_MAX,
    _SC_LOGIN_NAME_MAX,
    _SC_TTY_NAME_MAX,
    _SC_THREAD_DESTRUCTOR_ITERATIONS,
    _SC_THREAD_KEYS_MAX,
    _SC_THREAD_STACK_MIN,
    _SC_THREAD_THREADS_MAX,
    _SC_THREAD_ATTR_STACKADDR,
    _SC_THREAD_ATTR_STACKSIZE,
    _SC_THREAD_PRIORITY_SCHEDULING,
    _SC_THREAD_PRIO_INHERIT,
    _SC_THREAD_PRIO_PROTECT,
    _SC_THREAD_PROCESS_SHARED,
    _SC_NPROCESSORS_CONF,
    _SC_NPROCESSORS_ONLN,
    _SC_PHYS_PAGES,
    _SC_AVPHYS_PAGES,
    _SC_ATEXIT_MAX,
    _SC_PASS_MAX,
    _SC_XOPEN_VERSION,
    _SC_XOPEN_XCU_VERSION,
    _SC_XOPEN_UNIX,
    _SC_XOPEN_CRYPT,
    _SC_XOPEN_ENH_I18N,
    _SC_XOPEN_SHM,
    _SC_2_CHAR_TERM,
    _SC_2_C_VERSION,
    _SC_2_UPE,
    _SC_XOPEN_XPG2,
    _SC_XOPEN_XPG3,
    _SC_XOPEN_XPG4,
    _SC_CHAR_BIT,
    _SC_CHAR_MAX,
    _SC_CHAR_MIN,
    _SC_INT_MAX,
    _SC_INT_MIN,
    _SC_LONG_BIT,
    _SC_WORD_BIT,
    _SC_MB_LEN_MAX,
    _SC_NZERO,
    _SC_SSIZE_MAX,
    _SC_SCHAR_MAX,
    _SC_SCHAR_MIN,
    _SC_SHRT_MAX,
    _SC_SHRT_MIN,
    _SC_UCHAR_MAX,
    _SC_UINT_MAX,
    _SC_ULONG_MAX,
    _SC_USHRT_MAX,
    _SC_NL_ARGMAX,
    _SC_NL_LANGMAX,
    _SC_NL_MSGMAX,
    _SC_NL_NMAX,
    _SC_NL_SETMAX,
    _SC_NL_TEXTMAX,
    _SC_XBS5_ILP32_OFF32,
    _SC_XBS5_ILP32_OFFBIG,
    _SC_XBS5_LP64_OFF64,
    _SC_XBS5_LPBIG_OFFBIG,
    _SC_XOPEN_LEGACY,
    _SC_XOPEN_REALTIME,
    _SC_XOPEN_REALTIME_THREADS,
    _SC_ADVISORY_INFO,
    _SC_BARRIERS,
    _SC_BASE,
    _SC_C_LANG_SUPPORT,
    _SC_C_LANG_SUPPORT_R,
    _SC_CLOCK_SELECTION,
    _SC_CPUTIME,
    _SC_THREAD_CPUTIME,
    _SC_DEVICE_IO,
    _SC_DEVICE_SPECIFIC,
    _SC_DEVICE_SPECIFIC_R,
    _SC_FD_MGMT,
    _SC_FIFO,
    _SC_PIPE,
    _SC_FILE_ATTRIBUTES,
    _SC_FILE_LOCKING,
    _SC_FILE_SYSTEM,
    _SC_MONOTONIC_CLOCK,
    _SC_MULTI_PROCESS,
    _SC_SINGLE_PROCESS,
    _SC_NETWORKING,
    _SC_READER_WRITER_LOCKS,
    _SC_SPIN_LOCKS,
    _SC_REGEXP,
    _SC_REGEX_VERSION,
    _SC_SHELL,
    _SC_SIGNALS,
    _SC_SPAWN,
    _SC_SPORADIC_SERVER,
    _SC_THREAD_SPORADIC_SERVER,
    _SC_SYSTEM_DATABASE,
    _SC_SYSTEM_DATABASE_R,
    _SC_TIMEOUTS,
    _SC_TYPED_MEMORY_OBJECTS,
    _SC_USER_GROUPS,
    _SC_USER_GROUPS_R,
    _SC_2_PBS,
    _SC_2_PBS_ACCOUNTING,
    _SC_2_PBS_LOCATE,
    _SC_2_PBS_MESSAGE,
    _SC_2_PBS_TRACK,
    _SC_SYMLOOP_MAX,
    _SC_STREAMS,
    _SC_2_PBS_CHECKPOINT,
    _SC_V6_ILP32_OFF32,
    _SC_V6_ILP32_OFFBIG,
    _SC_V6_LP64_OFF64,
    _SC_V6_LPBIG_OFFBIG,
    _SC_HOST_NAME_MAX,
    _SC_TRACE,
    _SC_TRACE_EVENT_FILTER,
    _SC_TRACE_INHERIT,
    _SC_TRACE_LOG,
    _SC_LEVEL1_ICACHE_SIZE,
    _SC_LEVEL1_ICACHE_ASSOC,
    _SC_LEVEL1_ICACHE_LINESIZE,
    _SC_LEVEL1_DCACHE_SIZE,
    _SC_LEVEL1_DCACHE_ASSOC,
    _SC_LEVEL1_DCACHE_LINESIZE,
    _SC_LEVEL2_CACHE_SIZE,
    _SC_LEVEL2_CACHE_ASSOC,
    _SC_LEVEL2_CACHE_LINESIZE,
    _SC_LEVEL3_CACHE_SIZE,
    _SC_LEVEL3_CACHE_ASSOC,
    _SC_LEVEL3_CACHE_LINESIZE,
    _SC_LEVEL4_CACHE_SIZE,
    _SC_LEVEL4_CACHE_ASSOC,
    _SC_LEVEL4_CACHE_LINESIZE,
    _SC_IPV6 = _SC_LEVEL1_ICACHE_SIZE + 50,
    _SC_RAW_SOCKETS,
    _SC_V7_ILP32_OFF32,
    _SC_V7_ILP32_OFFBIG,
    _SC_V7_LP64_OFF64,
    _SC_V7_LPBIG_OFFBIG,
    _SC_SS_REPL_MAX,
    _SC_TRACE_EVENT_NAME_MAX,
    _SC_TRACE_NAME_MAX,
    _SC_TRACE_SYS_MAX,
    _SC_TRACE_USER_EVENT_MAX,
    _SC_XOPEN_STREAMS,
    _SC_THREAD_ROBUST_PRIO_INHERIT,
    _SC_THREAD_ROBUST_PRIO_PROTECT
  };
]]

-- error codes
ffi.cdef [[
static const int EPERM = 1;
static const int ENOENT = 2;
static const int ESRCH = 3;
static const int EINTR = 4;
static const int EIO = 5;
static const int ENXIO = 6;
static const int E2BIG = 7;
static const int ENOEXEC = 8;
static const int EBADF = 9;
static const int ECHILD = 10;
static const int EAGAIN = 11;
static const int ENOMEM = 12;
static const int EACCES = 13;
static const int EFAULT = 14;
static const int ENOTBLK = 15;
static const int EBUSY = 16;
static const int EEXIST = 17;
static const int EXDEV = 18;
static const int ENODEV = 19;
static const int ENOTDIR = 20;
static const int EISDIR = 21;
static const int EINVAL = 22;
static const int ENFILE = 23;
static const int EMFILE = 24;
static const int ENOTTY = 25;
static const int ETXTBSY = 26;
static const int EFBIG = 27;
static const int ENOSPC = 28;
static const int ESPIPE = 29;
static const int EROFS = 30;
static const int EMLINK = 31;
static const int EPIPE = 32;
static const int EDOM = 33;
static const int ERANGE = 34;
static const int EDEADLK = 35;
static const int ENAMETOOLONG = 36;
static const int ENOLCK = 37;
static const int ENOSYS = 38;
static const int ENOTEMPTY = 39;
static const int ELOOP = 40;
static const int EWOULDBLOCK = EAGAIN;
static const int ENOMSG = 42;
static const int EIDRM = 43;
static const int ECHRNG = 44;
static const int EL2NSYNC = 45;
static const int EL3HLT = 46;
static const int EL3RST = 47;
static const int ELNRNG = 48;
static const int EUNATCH = 49;
static const int ENOCSI = 50;
static const int EL2HLT = 51;
static const int EBADE = 52;
static const int EBADR = 53;
static const int EXFULL = 54;
static const int ENOANO = 55;
static const int EBADRQC = 56;
static const int EBADSLT = 57;
static const int EDEADLOCK = EDEADLK;
static const int EBFONT = 59;
static const int ENOSTR = 60;
static const int ENODATA = 61;
static const int ETIME = 62;
static const int ENOSR = 63;
static const int ENONET = 64;
static const int ENOPKG = 65;
static const int EREMOTE = 66;
static const int ENOLINK = 67;
static const int EADV = 68;
static const int ESRMNT = 69;
static const int ECOMM = 70;
static const int EPROTO = 71;
static const int EMULTIHOP = 72;
static const int EDOTDOT = 73;
static const int EBADMSG = 74;
static const int EOVERFLOW = 75;
static const int ENOTUNIQ = 76;
static const int EBADFD = 77;
static const int EREMCHG = 78;
static const int ELIBACC = 79;
static const int ELIBBAD = 80;
static const int ELIBSCN = 81;
static const int ELIBMAX = 82;
static const int ELIBEXEC = 83;
static const int EILSEQ = 84;
static const int ERESTART = 85;
static const int ESTRPIPE = 86;
static const int EUSERS = 87;
static const int ENOTSOCK = 88;
static const int EDESTADDRREQ = 89;
static const int EMSGSIZE = 90;
static const int EPROTOTYPE = 91;
static const int ENOPROTOOPT = 92;
static const int EPROTONOSUPPORT = 93;
static const int ESOCKTNOSUPPORT = 94;
static const int EOPNOTSUPP = 95;
static const int EPFNOSUPPORT = 96;
static const int EAFNOSUPPORT = 97;
static const int EADDRINUSE = 98;
static const int EADDRNOTAVAIL = 99;
static const int ENETDOWN = 100;
static const int ENETUNREACH = 101;
static const int ENETRESET = 102;
static const int ECONNABORTED = 103;
static const int ECONNRESET = 104;
static const int ENOBUFS = 105;
static const int EISCONN = 106;
static const int ENOTCONN = 107;
static const int ESHUTDOWN = 108;
static const int ETOOMANYREFS = 109;
static const int ETIMEDOUT = 110;
static const int ECONNREFUSED = 111;
static const int EHOSTDOWN = 112;
static const int EHOSTUNREACH = 113;
static const int EALREADY = 114;
static const int EINPROGRESS = 115;
static const int ESTALE = 116;
static const int EUCLEAN = 117;
static const int ENOTNAM = 118;
static const int ENAVAIL = 119;
static const int EISNAM = 120;
static const int EREMOTEIO = 121;
static const int EDQUOT = 122;
static const int ENOMEDIUM = 123;
static const int EMEDIUMTYPE = 124;
static const int ECANCELED = 125;
static const int ENOKEY = 126;
static const int EKEYEXPIRED = 127;
static const int EKEYREVOKED = 128;
static const int EKEYREJECTED = 129;
static const int EOWNERDEAD = 130;
static const int ENOTRECOVERABLE = 131;
static const int ERFKILL = 132;
static const int EHWPOISON = 133;
static const int ENOTSUP = EOPNOTSUPP;
]]

-- everything above will stay, below will be generated --
-- ******************** --
-- generated code start --

--[[ lib_date_time.lua ]]
ffi.cdef [[
	 typedef long int __time_t;
	typedef __time_t time_t;

	double difftime (time_t __time1, time_t __time0)
    ;
	time_t time (time_t *__timer);
]]

--[[ lib_http.lua ]]
--[[ lib_kqueue.lua ]]
--[[ system/poll.lua ]]
ffi.cdef [[
	static const int POLLERR = 0x008;
	static const int POLLHUP = 0x010;
	static const int POLLRDHUP = 0x2000;
	static const int POLLIN = 0x001;
	static const int POLLNVAL = 0x020;
	static const int POLLOUT = 0x004;


	struct pollfd
	  {
	    int fd;
	    short int events;
	    short int revents;
	  };


	void free (void *__ptr);
	void *realloc (void *__ptr, size_t __size)
    ;
]]

--[[ lib_shared_memory.lua ]]
ffi.cdef [[
	static const int MAP_SHARED = 0x01;
	static const int O_CREAT = 0100;
	static const int O_RDONLY = 00;
	static const int O_RDWR = 02;
	static const int PROT_READ = 0x1;
	static const int PROT_WRITE = 0x2;

	 typedef unsigned int __mode_t;
	 typedef long int __off_t;
	typedef __mode_t mode_t;

	int close (int __fd);
	int ftruncate (int __fd, __off_t __length);
	void *mmap (void *__addr, size_t __len, int __prot,
     int __flags, int __fd, __off_t __offset);
	int munmap (void *__addr, size_t __len);
	int shm_open (const char *__name, int __oflag, mode_t __mode);
	int shm_unlink (const char *__name);
	size_t strlen (const char *__s)
    ;
]]

--[[ lib_signal.lua ]]
ffi.cdef [[
	typedef struct
	  {
	    unsigned long int __val[(1024 / (8 * sizeof (unsigned long int)))];
	  } __sigset_t;

	typedef __sigset_t sigset_t;
	 typedef int __pid_t;

	__pid_t getpid (void);
	int kill (__pid_t __pid, int __sig);
	int pthread_sigmask (int __how,
       const __sigset_t *__newmask,
       __sigset_t *__oldmask)__attribute__ ((__nothrow__ , __leaf__));
	int sigaddset (sigset_t *__set, int __signo);
	int sigemptyset (sigset_t *__set);
	int sigwait (const sigset_t *__set, int *__sig)
    ;
]]

--[[ socket.lua ]]
ffi.cdef [[
	static const int F_GETFL = 3;
	static const int F_SETFL = 4;
	static const int O_NONBLOCK = 04000;
	static const int MSG_DONTWAIT = 0x40;
	static const int MSG_NOSIGNAL	= 0x4000; /* Do not generate SIGPIPE.  */
	static const int SO_BROADCAST = 6;

	typedef uint32_t in_addr_t;
	typedef unsigned short int sa_family_t;
	typedef unsigned long int nfds_t;
	typedef uint16_t in_port_t;

	 typedef int __ssize_t;
	struct sockaddr
	  {
	    sa_family_t sa_family;
	    char sa_data[14];
	  };
	struct sockaddr_un {
		sa_family_t sun_family;               /* AF_UNIX */
		char        sun_path[108];            /* Pathname */
	};

	typedef __ssize_t ssize_t;
	struct in_addr
	  {
	    in_addr_t s_addr;
	  };

	 typedef unsigned int __socklen_t;
	typedef __socklen_t socklen_t;
	struct sockaddr_in
	  {
	    sa_family_t sin_family;
	    in_port_t sin_port;
	    struct in_addr sin_addr;
	    unsigned char sin_zero[sizeof (struct sockaddr) -
	      (sizeof (unsigned short int)) -
	      sizeof (in_port_t) -
	      sizeof (struct in_addr)];
	  };

	struct addrinfo
	{
	  int ai_flags;
	  int ai_family;
	  int ai_socktype;
	  int ai_protocol;
	  socklen_t ai_addrlen;
	  struct sockaddr *ai_addr;
	  char *ai_canonname;
	  struct addrinfo *ai_next;
	};


	int accept (int __fd, struct sockaddr *__addr,
     socklen_t *__addr_len);
	int bind (int __fd, const struct sockaddr * __addr, socklen_t __len)
    ;
	int connect (int __fd, const struct sockaddr * __addr, socklen_t __len);
	int fcntl (int __fd, int __cmd, ...);
	const char *gai_strerror (int __ecode);
	int getaddrinfo (const char *__name,
   const char *__service,
   const struct addrinfo *__req,
   struct addrinfo **__pai);
	int getnameinfo (const struct sockaddr *__sa,
   socklen_t __salen, char *__host,
   socklen_t __hostlen, char *__serv,
   socklen_t __servlen, int __flags);
	int getpeername (int __fd, struct sockaddr *__addr,
   socklen_t *__len);
	int getsockopt (int __fd, int __level, int __optname,
         void *__optval,
         socklen_t *__optlen);
	uint16_t htons (uint16_t __hostshort)
    ;
	const char *inet_ntop (int __af, const void *__cp,
    char *__buf, socklen_t __len)
    ;
	int listen (int __fd, int __n);
	uint16_t ntohs (uint16_t __netshort)
    ;
	int poll (struct pollfd *__fds, nfds_t __nfds, int __timeout);
	ssize_t recv (int __fd, void *__buf, size_t __n, int __flags);
	ssize_t send (int __fd, const void *__buf, size_t __n, int __flags);
	extern ssize_t sendto (int __fd, __const void *__buf, size_t __n,
         int __flags, __const struct sockaddr * __addr,
         socklen_t __addr_len);
	extern ssize_t recvfrom (int __fd, void *__restrict __buf, size_t __n,
    int __flags, struct sockaddr *__restrict __addr,
    socklen_t *__restrict __addr_len);
	int setsockopt (int __fd, int __level, int __optname,
         const void *__optval, socklen_t __optlen);
	int shutdown (int __fd, int __how);
	int socket (int __domain, int __type, int __protocol);

	extern in_addr_t inet_addr (__const char *__cp) __attribute__ ((__nothrow__ , __leaf__));
]]

--[[ system/socket.lua ]]
ffi.cdef [[
	static const int AF_UNIX = 1;
	static const int AF_INET = PF_INET;
	static const int AF_INET6 = PF_INET6;
	static const int AI_PASSIVE = 0x0001;

	static const int AI_NUMERICHOST = 0x0008;

	static const int INET6_ADDRSTRLEN = 46;
	static const int INET_ADDRSTRLEN = 16;
	static const int SO_RCVBUF = 8;
	static const int SO_REUSEADDR = 2;
	static const int SO_SNDBUF = 7;
	static const int SOL_SOCKET = 1;
	static const int SOMAXCONN = 128;
	static const int TCP_NODELAY = 1;
	static const int TCP_QUICKACK = 12;

	struct sockaddr_storage
	  {
	    sa_family_t ss_family;
	    unsigned long int __ss_align;
	    char __ss_padding[(128 - (2 * sizeof (unsigned long int)))];
	  };

	struct sockaddr_in6
	  {
	    sa_family_t sin6_family;
	    in_port_t sin6_port;
	    uint32_t sin6_flowinfo;
	    struct in6_addr sin6_addr;
	    uint32_t sin6_scope_id;
	  };


	enum
  {
    IPPROTO_IP = 0,
    IPPROTO_HOPOPTS = 0,
    IPPROTO_ICMP = 1,
    IPPROTO_IGMP = 2,
    IPPROTO_IPIP = 4,
    IPPROTO_TCP = 6,
    IPPROTO_EGP = 8,
    IPPROTO_PUP = 12,
    IPPROTO_UDP = 17,
    IPPROTO_IDP = 22,
    IPPROTO_TP = 29,
    IPPROTO_DCCP = 33,
    IPPROTO_IPV6 = 41,
    IPPROTO_ROUTING = 43,
    IPPROTO_FRAGMENT = 44,
    IPPROTO_RSVP = 46,
    IPPROTO_GRE = 47,
    IPPROTO_ESP = 50,
    IPPROTO_AH = 51,
    IPPROTO_ICMPV6 = 58,
    IPPROTO_NONE = 59,
    IPPROTO_DSTOPTS = 60,
    IPPROTO_MTP = 92,
    IPPROTO_ENCAP = 98,
    IPPROTO_PIM = 103,
    IPPROTO_COMP = 108,
    IPPROTO_SCTP = 132,
    IPPROTO_UDPLITE = 136,
    IPPROTO_RAW = 255,
    IPPROTO_MAX
  };
	    struct in6_addr sin6_addr;
	    in_port_t sin6_port;
	enum __socket_type
{
  SOCK_STREAM = 1,
  SOCK_DGRAM = 2,
  SOCK_RAW = 3,
  SOCK_RDM = 4,
  SOCK_SEQPACKET = 5,
  SOCK_DCCP = 6,
  SOCK_PACKET = 10,
  SOCK_CLOEXEC = 02000000,
  SOCK_NONBLOCK = 04000
};
]]

--[[ lib_thread.lua ]]

if ffi.os == "Linux" then
	if ffi.arch == "x64" then
		ffi.cdef [[
				static const int __SIZEOF_PTHREAD_ATTR_T = 56;
		]]
	else
		ffi.cdef [[
				static const int __SIZEOF_PTHREAD_ATTR_T = 36;
		]]
	end
	ffi.cdef [[
	typedef uint64_t pthread_t;

	typedef union {
		int8_t __size[__SIZEOF_PTHREAD_ATTR_T];
		int64_t __align;
	} pthread_attr_t;
	]]
end

--[[ lib_util.lua ]]
ffi.cdef [[
	struct timezone
	  {
	    int tz_minuteswest;
	    int tz_dsttime;
	  };

	 typedef long int __suseconds_t;
	 typedef unsigned int __useconds_t;
	struct timespec
	  {
	    __time_t tv_sec;
	    long int tv_nsec;
	  };

	typedef struct timezone *__timezone_ptr_t;
	struct timeval
	  {
	    __time_t tv_sec;
	    __suseconds_t tv_usec;
	  };


	int gettimeofday (struct timeval *__tv,
    __timezone_ptr_t __tz);
	int nanosleep (const struct timespec *__requested_time,
        struct timespec *__remaining);
	int sched_yield (void);
	char *strerror (int __errnum);
	long int sysconf (int __name);
	int usleep (__useconds_t __useconds);
]]

--[[ TestAddrinfo.lua ]]
ffi.cdef [[
	static const int AI_CANONNAME = 0x0002;
	static const int NI_MAXHOST = 1025;
	static const int NI_MAXSERV = 32;
	static const int NI_NAMEREQD = 8;
	static const int NI_NUMERICHOST = 1;
	static const int NI_NUMERICSERV = 2;
]]

--[[ TestAll.lua ]]
--[[ TestKqueue.lua ]]
ffi.cdef [[
	int open (const char *__file, int __oflag, ...);
]]

--[[ TestLinux.lua ]]
ffi.cdef [[
	static const int O_EXCL = 0200;
]]

--[[ TestSharedMemory.lua ]]
--[[ TestSignal.lua ]]
--[[ TestSignal_bad.lua ]]
ffi.cdef [[
	typedef void (*__sighandler_t) (int);

	int pause (void);
	__sighandler_t signal (int __sig, __sighandler_t __handler)
    ;
]]

--[[ TestSocket.lua ]]
--[[ TestThread.lua ]]
