-- ffi_def_unix.lua
-- common for Linux and OSX
local ffi = require "ffi" -- must not be require "mffi"

-- common
ffi.cdef [[
typedef unsigned char u_char;
char *strcpy(char *dest, const char *src);
char *inet_ntoa(struct in_addr);
size_t wcstombs(char *dest, const wchar_t *src, size_t n);
size_t mbstowcs (wchar_t* dest, const char* src, size_t max);
size_t wcslen (const wchar_t *ws);
int strcmp ( const char * str1, const char * str2 );
int pipe(int[2]);
ssize_t read(int fd, void *buf, size_t count);
ssize_t write(int fd, const void *buf, size_t count);
]]

ffi.cdef [[
// socket
static const int	PF_UNSPEC = 0;			// Unspecified.
static const int	SHUT_RD		= 0;		/* shut down the reading side */
static const int	SHUT_WR		= 1;		/* shut down the writing side */
static const int	SHUT_RDWR	= 2;		/* shut down both sides */
]]

ffi.cdef [[
struct _IO_FILE;
typedef struct _IO_FILE FILE;

typedef void* iconv_t;
]]

--- ******* Time *******
ffi.cdef [[
	// typedef long __time32_t; /* 32-bit time value */
	typedef __int64 __time64_t; /* 64-bit time value */
	typedef __time64_t time_t; /* time value */

	struct tm
	{
			int tm_sec;
			int tm_min;
			int tm_hour;
			int tm_mday;
			int tm_mon;
			int tm_year;
			int tm_wday;
			int tm_yday;
			int tm_isdst;
			long int __tm_gmtoff;
			const char *__tm_zone;
	};

	struct tm *localtime(const time_t *timer);
	struct lconv {
   char *decimal_point;
	 char *thousands_sep;
	 char *grouping;
	 char *int_curr_symbol;
	 char *currency_symbol;
	 char *mon_decimal_point;
	 char *mon_thousands_sep;
	 char *mon_grouping;
	 char *positive_sign;
	 char *negative_sign;
	 char int_frac_digits;
	 char frac_digits;
	 char p_cs_precedes;
	 char p_sep_by_space;
	 char n_cs_precedes;
	 char n_sep_by_space;
	 char p_sign_posn;
	 char n_sign_posn;
	};
	struct lconv *localeconv(void);
	size_t strftime(
			char *ptr,
			size_t maxsize,
			const char *format,
			const struct tm *timeptr
	);

/* not in use
	typedef long suseconds_t;
	struct timeval{
			time_t tv_sec;
			suseconds_t tv_usec;
	};
	struct timezone{
			int tz_minuteswest;
			int tz_dsttime;
	};
	typedef struct timezone *timezone_ptr_t;
	time_t time(time_t *timer);
	struct tm *gmtime(const time_t *timer);
	int gettimeofday(struct timeval *tv, timezone_ptr_t tz);
*/
]]

ffi.cdef [[
static const int MSG_PEEK = 0x2; // ignore error: ';' expected near '=' at line 2
]]

ffi.cdef [[
	void* malloc(size_t size);
	void* calloc(size_t num, size_t size);
	void* realloc(void* ptr, size_t size);
	void free(void* ptr);
]]

-- Lua state - creating a new Lua state to a new thread
ffi.cdef [[

	static const int LUA_GCSTOP		= 0;
	static const int LUA_GCRESTART		= 1;
	static const int LUA_GCCOLLECT		= 2;
	static const int LUA_GCCOUNT		= 3;
	static const int LUA_GCCOUNTB		= 4;
	static const int LUA_GCSTEP		= 5;
	static const int LUA_GCSETPAUSE		= 6;
	static const int LUA_GCSETSTEPMUL	= 7;
	static const int LUA_GLOBALSINDEX = -10002;

	typedef struct lua_State lua_State;

	int (lua_gc) (lua_State *L, int what, int data);
	lua_State *luaL_newstate(void);
	void luaL_openlibs(lua_State *L);
	void lua_close(lua_State *L);
	int luaL_loadstring(lua_State *L, const char *s);
	int lua_pcall(lua_State *L, int nargs, int nresults, int errfunc);
	void lua_getfield(lua_State *L, int index, const char *k);
	ptrdiff_t lua_tointeger(lua_State *L, int index);
	void lua_settop(lua_State *L, int index);
]]

--  thread.lua
ffi.cdef [[
	int pthread_create(
		pthread_t *thread,
		const pthread_attr_t *attr,
		void *(*start_routine)(void *),
		void *arg
	);
	int pthread_join(
		pthread_t thread,
		void **value_ptr
	);
	int       pthread_detach(pthread_t );
	int       pthread_equal(pthread_t , pthread_t );
	void      pthread_exit(void *);
	pthread_t pthread_self(void);

	/* from: https://github.com/hnakamur/luajit-examples/blob/master/pthread/thread1.lua */
	// needed inluaThreadCreate(): ffi.cast("thread_func", func_ptr)
	typedef void *(*thread_func)(void *);

	/*
		// Code for simulating pthreads API on Windows.
		// https://github.com/FrancescAlted/blosc/blob/master/blosc/win32/pthread.c
		int  pthread_create(pthread_t *thread, pthread_attr_t *attr, void *(*start_routine) (void *), void *arg);
		int  pthread_join (pthread_t th, void **thread_return);
		void pthread_exit (void *retval);

		int pthread_mutex_init (pthread_mutex_t *mutex, pthread_mutexattr_t *mutex_attr);
		int pthread_mutex_destroy (pthread_mutex_t *mutex);
		int pthread_mutex_lock (pthread_mutex_t *mutex);
		int pthread_mutex_unlock (pthread_mutex_t *mutex);

		void mutex_lock();
		bool mutex_try_lock();
		void mutex_unlock();
	*/

]]

-- printer.lua
ffi.cdef [[
typedef void* http_t; // typedef struct _http_s http_t;
// define CUPS_HTTP_DEFAULT		(http_t *)0, CUPS_HTTP_DEFAULT = ffi.cast("void*", 0)
// define CUPS_FORMAT_AUTO		"application/octet-stream"

typedef enum http_status_e		/**** HTTP status codes ****/
{
  HTTP_STATUS_ERROR = -1,		/* An error response from httpXxxx() */
  HTTP_STATUS_NONE = 0,			/* No Expect value @since CUPS 1.7/OS X 10.9@ */

  HTTP_STATUS_CONTINUE = 100,		/* Everything OK, keep going... */
  HTTP_STATUS_SWITCHING_PROTOCOLS,	/* HTTP upgrade to TLS/SSL */

  HTTP_STATUS_OK = 200,			/* OPTIONS/GET/HEAD/POST/TRACE command was successful */
  HTTP_STATUS_CREATED,			/* PUT command was successful */
  HTTP_STATUS_ACCEPTED,			/* DELETE command was successful */
  HTTP_STATUS_NOT_AUTHORITATIVE,	/* Information is not authoritative */
  HTTP_STATUS_NO_CONTENT,		/* Successful command, no new data */
  HTTP_STATUS_RESET_CONTENT,		/* Content was reset/recreated */
  HTTP_STATUS_PARTIAL_CONTENT,		/* Only a partial file was recieved/sent */

  HTTP_STATUS_MULTIPLE_CHOICES = 300,	/* Multiple files match request */
  HTTP_STATUS_MOVED_PERMANENTLY,	/* Document has moved permanently */
  HTTP_STATUS_MOVED_TEMPORARILY,	/* Document has moved temporarily */
  HTTP_STATUS_SEE_OTHER,		/* See this other link... */
  HTTP_STATUS_NOT_MODIFIED,		/* File not modified */
  HTTP_STATUS_USE_PROXY,		/* Must use a proxy to access this URI */

  HTTP_STATUS_BAD_REQUEST = 400,	/* Bad request */
  HTTP_STATUS_UNAUTHORIZED,		/* Unauthorized to access host */
  HTTP_STATUS_PAYMENT_REQUIRED,		/* Payment required */
  HTTP_STATUS_FORBIDDEN,		/* Forbidden to access this URI */
  HTTP_STATUS_NOT_FOUND,		/* URI was not found */
  HTTP_STATUS_METHOD_NOT_ALLOWED,	/* Method is not allowed */
  HTTP_STATUS_NOT_ACCEPTABLE,		/* Not Acceptable */
  HTTP_STATUS_PROXY_AUTHENTICATION,	/* Proxy Authentication is Required */
  HTTP_STATUS_REQUEST_TIMEOUT,		/* Request timed out */
  HTTP_STATUS_CONFLICT,			/* Request is self-conflicting */
  HTTP_STATUS_GONE,			/* Server has gone away */
  HTTP_STATUS_LENGTH_REQUIRED,		/* A content length or encoding is required */
  HTTP_STATUS_PRECONDITION,		/* Precondition failed */
  HTTP_STATUS_REQUEST_TOO_LARGE,	/* Request entity too large */
  HTTP_STATUS_URI_TOO_LONG,		/* URI too long */
  HTTP_STATUS_UNSUPPORTED_MEDIATYPE,	/* The requested media type is unsupported */
  HTTP_STATUS_REQUESTED_RANGE,		/* The requested range is not satisfiable */
  HTTP_STATUS_EXPECTATION_FAILED,	/* The expectation given in an Expect header field was not met */
  HTTP_STATUS_UPGRADE_REQUIRED = 426,	/* Upgrade to SSL/TLS required */

  HTTP_STATUS_SERVER_ERROR = 500,	/* Internal server error */
  HTTP_STATUS_NOT_IMPLEMENTED,		/* Feature not implemented */
  HTTP_STATUS_BAD_GATEWAY,		/* Bad gateway */
  HTTP_STATUS_SERVICE_UNAVAILABLE,	/* Service is unavailable */
  HTTP_STATUS_GATEWAY_TIMEOUT,		/* Gateway connection timed out */
  HTTP_STATUS_NOT_SUPPORTED,		/* HTTP version not supported */

  HTTP_STATUS_CUPS_AUTHORIZATION_CANCELED = 1000,
					/* User canceled authorization @since CUPS 1.4@ */
  HTTP_STATUS_CUPS_PKI_ERROR,		/* Error negotiating a secure connection @since CUPS 1.5/OS X 10.7@ */
  HTTP_STATUS_CUPS_WEBIF_DISABLED	/* Web interface is disabled @private@ */
} http_status_t;


typedef enum ipp_status_e		/**** IPP status codes ****/
{
  IPP_STATUS_CUPS_INVALID = -1,		/* Invalid status name for @link ippErrorValue@ */
  IPP_STATUS_OK = 0x0000,		/* successful-ok */
  IPP_STATUS_OK_IGNORED_OR_SUBSTITUTED,	/* successful-ok-ignored-or-substituted-attributes */
  IPP_STATUS_OK_CONFLICTING,		/* successful-ok-conflicting-attributes */
  IPP_STATUS_OK_IGNORED_SUBSCRIPTIONS,	/* successful-ok-ignored-subscriptions */
  IPP_STATUS_OK_IGNORED_NOTIFICATIONS,	/* successful-ok-ignored-notifications @private@ */
  IPP_STATUS_OK_TOO_MANY_EVENTS,	/* successful-ok-too-many-events */
  IPP_STATUS_OK_BUT_CANCEL_SUBSCRIPTION,/* successful-ok-but-cancel-subscription @private@ */
  IPP_STATUS_OK_EVENTS_COMPLETE,	/* successful-ok-events-complete */
  IPP_STATUS_REDIRECTION_OTHER_SITE = 0x0200,
					/* redirection-other-site @private@ */
  IPP_STATUS_CUPS_SEE_OTHER = 0x0280,	/* cups-see-other */
  IPP_STATUS_ERROR_BAD_REQUEST = 0x0400,/* client-error-bad-request */
  IPP_STATUS_ERROR_FORBIDDEN,		/* client-error-forbidden */
  IPP_STATUS_ERROR_NOT_AUTHENTICATED,	/* client-error-not-authenticated */
  IPP_STATUS_ERROR_NOT_AUTHORIZED,	/* client-error-not-authorized */
  IPP_STATUS_ERROR_NOT_POSSIBLE,	/* client-error-not-possible */
  IPP_STATUS_ERROR_TIMEOUT,		/* client-error-timeout */
  IPP_STATUS_ERROR_NOT_FOUND,		/* client-error-not-found */
  IPP_STATUS_ERROR_GONE,		/* client-error-gone */
  IPP_STATUS_ERROR_REQUEST_ENTITY,	/* client-error-request-entity-too-large */
  IPP_STATUS_ERROR_REQUEST_VALUE,	/* client-error-request-value-too-long */
  IPP_STATUS_ERROR_DOCUMENT_FORMAT_NOT_SUPPORTED,
					/* client-error-document-format-not-supported */
  IPP_STATUS_ERROR_ATTRIBUTES_OR_VALUES,/* client-error-attributes-or-values-not-supported */
  IPP_STATUS_ERROR_URI_SCHEME,		/* client-error-uri-scheme-not-supported */
  IPP_STATUS_ERROR_CHARSET,		/* client-error-charset-not-supported */
  IPP_STATUS_ERROR_CONFLICTING,		/* client-error-conflicting-attributes */
  IPP_STATUS_ERROR_COMPRESSION_NOT_SUPPORTED,
					/* client-error-compression-not-supported */
  IPP_STATUS_ERROR_COMPRESSION_ERROR,	/* client-error-compression-error */
  IPP_STATUS_ERROR_DOCUMENT_FORMAT_ERROR,
					/* client-error-document-format-error */
  IPP_STATUS_ERROR_DOCUMENT_ACCESS,	/* client-error-document-access-error */
  IPP_STATUS_ERROR_ATTRIBUTES_NOT_SETTABLE,
					/* client-error-attributes-not-settable */
  IPP_STATUS_ERROR_IGNORED_ALL_SUBSCRIPTIONS,
					/* client-error-ignored-all-subscriptions */
  IPP_STATUS_ERROR_TOO_MANY_SUBSCRIPTIONS,
					/* client-error-too-many-subscriptions */
  IPP_STATUS_ERROR_IGNORED_ALL_NOTIFICATIONS,
					/* client-error-ignored-all-notifications @private@ */
  IPP_STATUS_ERROR_PRINT_SUPPORT_FILE_NOT_FOUND,
					/* client-error-print-support-file-not-found @private@ */
  IPP_STATUS_ERROR_DOCUMENT_PASSWORD,	/* client-error-document-password-error */
  IPP_STATUS_ERROR_DOCUMENT_PERMISSION,	/* client-error-document-permission-error */
  IPP_STATUS_ERROR_DOCUMENT_SECURITY,	/* client-error-document-security-error */
  IPP_STATUS_ERROR_DOCUMENT_UNPRINTABLE,/* client-error-document-unprintable-error */
  IPP_STATUS_ERROR_ACCOUNT_INFO_NEEDED,	/* client-error-account-info-needed */
  IPP_STATUS_ERROR_ACCOUNT_CLOSED,	/* client-error-account-closed */
  IPP_STATUS_ERROR_ACCOUNT_LIMIT_REACHED,
					/* client-error-account-limit-reached */
  IPP_STATUS_ERROR_ACCOUNT_AUTHORIZATION_FAILED,
					/* client-error-account-authorization-failed */

  /* Legacy status codes for paid printing */
  IPP_STATUS_ERROR_CUPS_ACCOUNT_INFO_NEEDED = 0x049C,
					/* cups-error-account-info-needed @deprecated@ */
  IPP_STATUS_ERROR_CUPS_ACCOUNT_CLOSED,	/* cups-error-account-closed @deprecate@ */
  IPP_STATUS_ERROR_CUPS_ACCOUNT_LIMIT_REACHED,
					/* cups-error-account-limit-reached @deprecated@ */
  IPP_STATUS_ERROR_CUPS_ACCOUNT_AUTHORIZATION_FAILED,
					/* cups-error-account-authorization-failed @deprecated@ */

  IPP_STATUS_ERROR_INTERNAL = 0x0500,	/* server-error-internal-error */
  IPP_STATUS_ERROR_OPERATION_NOT_SUPPORTED,
					/* server-error-operation-not-supported */
  IPP_STATUS_ERROR_SERVICE_UNAVAILABLE,	/* server-error-service-unavailable */
  IPP_STATUS_ERROR_VERSION_NOT_SUPPORTED,
					/* server-error-version-not-supported */
  IPP_STATUS_ERROR_DEVICE,		/* server-error-device-error */
  IPP_STATUS_ERROR_TEMPORARY,		/* server-error-temporary-error */
  IPP_STATUS_ERROR_NOT_ACCEPTING_JOBS,	/* server-error-not-accepting-jobs */
  IPP_STATUS_ERROR_BUSY,		/* server-error-busy */
  IPP_STATUS_ERROR_JOB_CANCELED,	/* server-error-job-canceled */
  IPP_STATUS_ERROR_MULTIPLE_JOBS_NOT_SUPPORTED,
					/* server-error-multiple-document-jobs-not-supported */
  IPP_STATUS_ERROR_PRINTER_IS_DEACTIVATED,
					/* server-error-printer-is-deactivated */
  IPP_STATUS_ERROR_TOO_MANY_JOBS,	/* server-error-too-many-jobs */
  IPP_STATUS_ERROR_TOO_MANY_DOCUMENTS,	/* server-error-too-many-documents */

  /* These are internal and never sent over the wire... */
  IPP_STATUS_ERROR_CUPS_AUTHENTICATION_CANCELED = 0x1000,
					/* cups-authentication-canceled - Authentication canceled by user @since CUPS 1.5/OS X 10.7@ */
  IPP_STATUS_ERROR_CUPS_PKI,		/* cups-pki-error - Error negotiating a secure connection @since CUPS 1.5/OS X 10.7@ */
  IPP_STATUS_ERROR_CUPS_UPGRADE_REQUIRED/* cups-upgrade-required - TLS upgrade required */
} ipp_status_t;

struct cups_option_s {
    char *name;
    char *value;
};
typedef struct cups_option_s cups_option_t;
struct cups_dest_s {
    char *name, *instance;
    int is_default;
    int num_options;
    cups_option_t *options;
};
typedef struct cups_dest_s cups_dest_t;

int cupsAddOption (
    const char *name,
    const char *value,
    int num_options,
    cups_option_t **options
);

void cupsFreeOptions (
    int num_options,
    cups_option_t *options
);

void cupsFreeDests (
    int num_dests,
    cups_dest_t *dests
);

int cupsGetDests (
    cups_dest_t **dests
);

const char *cupsGetDefault (void);

void cupsSetDefaultDest (
	const char *name,
	const char *instance,
	int num_dests,
	cups_dest_t *dests
);

void cupsSetDests (
	int num_dests,
	cups_dest_t *dests
);

int cupsPrintFile (
	const char *name,
	const char *filename,
	const char *title,
	int num_options,
	cups_option_t *options
);

int cupsCreateJob (
    http_t *http,
    const char *name,
    const char *title,
    int num_options,
    cups_option_t *options
);

http_status_t cupsStartDocument (
    http_t *http,
    const char *name,
    int job_id,
    const char *docname,
    const char *format,
    int last_document
);

http_status_t cupsWriteRequestData (
    http_t *http,
    const char *buffer,
    size_t length
);

ipp_status_t cupsFinishDocument (
    http_t *http,
    const char *name
);
]]
