-- ffi_def_windows.lua
-- ffi_def_windows.lua
local ffi = require "ffi" -- must not be require "mffi"

--[=[
local _WIN64 = (ffi.os == "Windows") and ffi.abi("64bit");
if _WIN64 then
ffi.cdef[[
typedef int64_t   INT_PTR, *PINT_PTR;
typedef uint64_t  UINT_PTR, *PUINT_PTR;
typedef intptr_t   LONG_PTR, *PLONG_PTR, *PLONG_PTR;
typedef uint64_t  ULONG_PTR, *PULONG_PTR;
]]
else
ffi.cdef[[
typedef int             INT_PTR, *PINT_PTR;
typedef unsigned int    UINT_PTR, *PUINT_PTR;
typedef intptr_t            LONG_PTR, *PLONG_PTR;
typedef unsigned long   ULONG_PTR, *PULONG_PTR;
]]

ffi.cdef[[
typedef long int __ssize_t;
typedef __ssize_t ssize_t;
]]
end

]=]
if not jit or jit.arch == "x86" then --  or jit.arch == "x86" is needed for 4d
	ffi.cdef [[
	typedef intptr_t ssize_t; // is defined inside luajit, but might not be defined inside ffi.dll or ffi.so
	]]
end

ffi.cdef [[
struct _IO_FILE;
typedef struct _IO_FILE FILE;

typedef void* iconv_t;
]]

ffi.cdef [[
static const int MSG_PEEK = 0x2;
// #define WSABASEERR		10000
static const int WSATRY_AGAIN = 11002; // (WSABASEERR + 1002)
static const int WSAEWOULDBLOCK = 10035; // (WSABASEERR + 35  )
static const int WSAECONNRESET = 10054;		// (WSABASEERR + 54  )
]]
-- error codes, unix compatibility
ffi.cdef [[
static const int ECONNRESET = 54; // need testing, osx = 54, linux = 104
static const int EAGAIN = 11;
static const int EPIPE = 32;
static const int ETIMEDOUT = 138; // MAc 60, Linux 110
]]

ffi.cdef [[
typedef long int __time_t;
typedef __time_t time_t;
typedef __int64 __time64_t;
struct tm *localtime(const time_t *timer);
struct tm *_localtime32(const time_t *sourceTime);
struct tm *_localtime64(const __time64_t *sourceTime);
struct lconv {
 char *decimal_point;
 char *thousands_sep;
 char *grouping;
 char *int_curr_symbol;
 char *currency_symbol;
 char *mon_decimal_point;
 char *mon_thousands_sep;
 char *mon_grouping;
 char *positive_sign;
 char *negative_sign;
 char int_frac_digits;
 char frac_digits;
 char p_cs_precedes;
 char p_sep_by_space;
 char n_cs_precedes;
 char n_sep_by_space;
 char p_sign_posn;
 char n_sign_posn;
};
struct lconv *localeconv(void);
size_t strftime(
		char *ptr,
		size_t maxsize,
		const char *format,
		const struct tm *timeptr
);
]]

ffi.cdef [[
	void* malloc(size_t size);
	void* calloc(size_t num, size_t size);
	void* realloc(void* ptr, size_t size);
	void free(void* ptr);
]]

-- Lua state - creating a new Lua state to a new thread
ffi.cdef [[
  // lua.h
  static const int LUA_GCSTOP		= 0;
  static const int LUA_GCRESTART		= 1;
  static const int LUA_GCCOLLECT		= 2;
  static const int LUA_GCCOUNT		= 3;
  static const int LUA_GCCOUNTB		= 4;
  static const int LUA_GCSTEP		= 5;
  static const int LUA_GCSETPAUSE		= 6;
  static const int LUA_GCSETSTEPMUL	= 7;
  static const int LUA_GLOBALSINDEX = -10002;
  typedef struct lua_State lua_State;
  int (lua_gc) (lua_State *L, int what, int data);
  lua_State *luaL_newstate(void);
  void luaL_openlibs(lua_State *L);
  void lua_close(lua_State *L);
  int luaL_loadstring(lua_State *L, const char *s);
  int lua_pcall(lua_State *L, int nargs, int nresults, int errfunc);
  void lua_getfield(lua_State *L, int index, const char *k);
  ptrdiff_t lua_tointeger(lua_State *L, int index);
  void lua_settop(lua_State *L, int index);
]]

ffi.cdef [[
  // handmade basic types
  // http://msdn.microsoft.com/en-us/library/windows/desktop/aa383751(v=vs.85).aspx

  // following MUST be here
  typedef intptr_t INT_PTR;
  typedef uintptr_t UINT_PTR;

	typedef unsigned long ULONG;
	typedef ULONG *PULONG;

  // WinNT.h, BaseTsd.h
  typedef void VOID;
  typedef void *PVOID;
  typedef void *LPVOID;
  typedef const void *LPCVOID;

  typedef char CHAR;
  typedef unsigned char UCHAR;
  typedef short SHORT;
  typedef unsigned short USHORT;
  typedef int INT;
	typedef int *LPINT;
  typedef unsigned int UINT;
  typedef long LONG;
  typedef unsigned long ULONG;
  typedef uint8_t UINT8;
  typedef __int64 LONGLONG;
  typedef unsigned __int64 ULONGLONG;
  typedef unsigned __int64 ULONG64;
  typedef uint32_t UINT32;

  typedef int BOOL;
  typedef unsigned char BYTE;

  // typedef void *HANDLE; // in mffi.lua
  typedef HANDLE *PHANDLE;
	typedef HANDLE HPALETTE;
	typedef int HFILE;
  typedef unsigned short WORD;
  typedef unsigned long DWORD;

  typedef unsigned __int64 ULONG_PTR, *PULONG_PTR;
  typedef ULONG_PTR DWORD_PTR, *PDWORD_PTR;
  typedef unsigned short wchar_t;
  typedef wchar_t WCHAR;
  typedef WCHAR *PWCHAR;

  typedef CHAR *NPSTR, *LPSTR, *PSTR;
	typedef char TCHAR, *PTCHAR;
  typedef LPSTR LPTSTR;
  typedef HANDLE *LPHANDLE;
  typedef BYTE *LPBYTE;
  typedef DWORD *LPDWORD;

  // Basic system type definitions, taken from the BSD file sys/types.h.
  typedef unsigned char   u_char;
  typedef unsigned short  u_short;
  typedef unsigned int    u_int;
  typedef unsigned long   u_long;

]]
ffi.cdef [[
// bad or ugly define macros, done by hand
UINT SetErrorMode(
	UINT uMode
);
static const int SEM_FAILCRITICALERRORS = 0x0001;
static const int SEM_NOGPFAULTERRORBOX = 0x0002;

// #define inside struct is bad
typedef struct in_addr {
        union {
                struct { UCHAR s_b1,s_b2,s_b3,s_b4; } S_un_b;
                struct { USHORT s_w1,s_w2; } S_un_w;
                ULONG S_addr;
        } S_un;
      // #define s_addr  S_un.S_addr /* can be used for most tcp & ip code */
      // #define s_host  S_un.S_un_b.s_b2    // host on imp
      // #define s_net   S_un.S_un_b.s_b1    // network
      // #define s_imp   S_un.S_un_w.s_w2    // imp
      // #define s_impno S_un.S_un_b.s_b4    // imp #
      // #define s_lh    S_un.S_un_b.s_b3    // logical host
} IN_ADDR, *PIN_ADDR, *LPIN_ADDR;

// wrong order of defines
typedef USHORT ADDRESS_FAMILY;

// handmade stuff

typedef struct _GUID {
  unsigned long  Data1;
  unsigned short Data2;
  unsigned short Data3;
  unsigned char  Data4[8];
} GUID, UUID;

typedef long RPC_STATUS;
// typedef unsigned short RPC_STATUS;
RPC_STATUS UuidCreateSequential(
  UUID *Uuid
);


typedef unsigned __int64 ULONG_PTR, *PULONG_PTR;
typedef ULONG_PTR SIZE_T, *PSIZE_T;
typedef const CHAR *LPCSTR, *PCSTR;
typedef LPCSTR			LPCTSTR;
typedef intptr_t HINSTANCE;
// typedef uint32_t HINSTANCE;
// typedef void * 		HINSTANCE;
typedef HINSTANCE		HMODULE;
typedef HANDLE 		HWND;
typedef HANDLE 		HDC; // in cairo

typedef struct _SECURITY_ATTRIBUTES {
    DWORD nLength;
    LPVOID lpSecurityDescriptor;
    BOOL bInheritHandle;
} SECURITY_ATTRIBUTES, *PSECURITY_ATTRIBUTES, *LPSECURITY_ATTRIBUTES;

BOOL GetUserNameA(
  LPTSTR  lpBuffer,
  LPDWORD lpnSize
);
]]

-- https://msdn.microsoft.com/fi-fi/library/windows/desktop/ms684175(v=vs.85).aspx
ffi.cdef [[
static const int DONT_RESOLVE_DLL_REFERENCES = 0x00000001;
HMODULE LoadLibraryExA(
  LPCTSTR lpFileName,
  HANDLE  hFile,
  DWORD   dwFlags
);
]]

-- wine
ffi.cdef [[
const char *wine_get_version(void);
HMODULE GetModuleHandleA(LPCSTR lpModuleName);
void * GetProcAddress(HMODULE hModule, LPCSTR lpProcName);
]]

ffi.cdef [[
BOOL CloseHandle(HANDLE hObject);

BOOL DuplicateHandle(
    HANDLE hSourceProcessHandle,
    HANDLE hSourceHandle,
    HANDLE hTargetProcessHandle,
    LPHANDLE lpTargetHandle,
    DWORD dwDesiredAccess,
    BOOL bInheritHandle,
    DWORD dwOptions);

BOOL GetHandleInformation(HANDLE hObject, LPDWORD lpdwFlags);

BOOL SetHandleInformation(HANDLE hObject, DWORD dwMask, DWORD dwFlags);

static const int HANDLE_FLAG_INHERIT            = 0x00000001;
static const int HANDLE_FLAG_PROTECT_FROM_CLOSE = 0x00000002;

static const int STD_INPUT_HANDLE    = ((DWORD)-10);
static const int STD_OUTPUT_HANDLE   = ((DWORD)-11);
static const int STD_ERROR_HANDLE    = ((DWORD)-12);

enum {
	ENABLE_PROCESSED_OUTPUT = 0x1,
	ENABLE_WRAP_AT_EOL_OUTPUT = 0x2,
	ENABLE_VIRTUAL_TERMINAL_PROCESSING = 0x4,
	ENABLE_INSERT_MODE = 0x20,
	ENABLE_QUICK_EDIT_MODE = 0x40,
	ENABLE_EXTENDED_FLAGS = 0x80,
};
]]

-- util.lua
ffi.cdef [[
// static const DWORD INFINITE = 0xFFFFFFFF;
static const int STARTF_USESTDHANDLES    = 0x00000100;
static const int STARTF_USESHOWWINDOW    = 0x00000001;
static const int SW_HIDE = 0;
static const int SW_SHOWMINNOACTIVE = 7;
static const int SW_SHOWNORMAL = 1; // SW_SHOW = 5; SW_RESTORE = 9;
static const int ERROR_BROKEN_PIPE= 109;
static const int MAX_PATH = 260;
static const int PROCESS_VM_READ = 0x0010;
static const int PROCESS_QUERY_INFORMATION = 0x0400;

static const int TH32CS_SNAPPROCESS = 0x00000002;
typedef struct tagPROCESSENTRY32 {
  DWORD     dwSize;
  DWORD     cntUsage;
  DWORD     th32ProcessID;
  ULONG_PTR th32DefaultHeapID;
  DWORD     th32ModuleID;
  DWORD     cntThreads;
  DWORD     th32ParentProcessID;
  LONG      pcPriClassBase;
  DWORD     dwFlags;
  TCHAR     szExeFile[MAX_PATH];
} PROCESSENTRY32, *PPROCESSENTRY32, *LPPROCESSENTRY32;

typedef struct _PROCESS_INFORMATION {
    HANDLE hProcess;
    HANDLE hThread;
    DWORD dwProcessId;
    DWORD dwThreadId;
} PROCESS_INFORMATION, *PPROCESS_INFORMATION, *LPPROCESS_INFORMATION;

typedef struct _STARTUPINFOA {
    DWORD   cb;
    LPSTR   lpReserved;
    LPSTR   lpDesktop;
    LPSTR   lpTitle;
    DWORD   dwX;
    DWORD   dwY;
    DWORD   dwXSize;
    DWORD   dwYSize;
    DWORD   dwXCountChars;
    DWORD   dwYCountChars;
    DWORD   dwFillAttribute;
    DWORD   dwFlags;
    WORD    wShowWindow;
    WORD    cbReserved2;
    LPBYTE  lpReserved2;
    HANDLE  hStdInput;
    HANDLE  hStdOutput;
    HANDLE  hStdError;
} STARTUPINFOA, *LPSTARTUPINFOA;

typedef struct _OVERLAPPED {
    ULONG_PTR Internal;
    ULONG_PTR InternalHigh;
    union {
        struct {
            DWORD Offset;
            DWORD OffsetHigh;
        };

        PVOID Pointer;
    };

    HANDLE hEvent;
} OVERLAPPED, *LPOVERLAPPED;


static const int SECURITY_DESCRIPTOR_REVISION    = 1;
typedef struct _ACL
{
    UCHAR AclRevision;
    UCHAR Sbz1;
    USHORT AclSize;
    USHORT AceCount;
    USHORT Sbz2;
} 	ACL, *PACL;
typedef PVOID PSID;
typedef USHORT SECURITY_DESCRIPTOR_CONTROL;
typedef struct _SECURITY_DESCRIPTOR
{
    UCHAR Revision;
    UCHAR Sbz1;
    SECURITY_DESCRIPTOR_CONTROL Control;
    PSID Owner;
    PSID Group;
    PACL Sacl;
    PACL Dacl;
}   SECURITY_DESCRIPTOR, *PSECURITY_DESCRIPTOR;


BOOL InitializeSecurityDescriptor(
    PSECURITY_DESCRIPTOR pSecurityDescriptor,
    DWORD dwRevision
);

BOOL SetSecurityDescriptorDacl (
    PSECURITY_DESCRIPTOR pSecurityDescriptor,
    BOOL bDaclPresent,
    PACL pDacl,
    BOOL bDaclDefaulted
);

HANDLE GetStdHandle(DWORD nStdHandle);

BOOL CloseHandle(
    HANDLE hObject
);

DWORD WaitForSingleObject(
    HANDLE hHandle,
    DWORD dwMilliseconds
);

BOOL CreatePipe(
    PHANDLE hReadPipe,
    PHANDLE hWritePipe,
    LPSECURITY_ATTRIBUTES lpPipeAttributes,
    DWORD nSize
);

BOOL ReadFile(
    HANDLE hFile,
    LPVOID lpBuffer,
    DWORD nNumberOfBytesToRead,
    LPDWORD lpNumberOfBytesRead,
    LPOVERLAPPED lpOverlapped
);

BOOL CreateProcessA(
    LPCSTR lpApplicationName,
    LPSTR lpCommandLine,
    LPSECURITY_ATTRIBUTES lpProcessAttributes,
    LPSECURITY_ATTRIBUTES lpThreadAttributes,
    BOOL bInheritHandles,
    DWORD dwCreationFlags,
    LPVOID lpEnvironment,
    LPCSTR lpCurrentDirectory,
    LPSTARTUPINFOA lpStartupInfo,
    LPPROCESS_INFORMATION lpProcessInformation
 );

HINSTANCE ShellExecuteA(
  HWND    hwnd,
  LPCTSTR lpOperation,
  LPCTSTR lpFile,
  LPCTSTR lpParameters,
  LPCTSTR lpDirectory,
  INT     nShowCmd
);

BOOL EnumProcesses (
	DWORD * lpidProcess,
	DWORD cb,
	LPDWORD lpcbNeeded
);

HANDLE CreateToolhelp32Snapshot(
  DWORD dwFlags,
  DWORD th32ProcessID
);

BOOL Process32First(
  HANDLE           hSnapshot,
  LPPROCESSENTRY32 lppe
);

BOOL Process32Next(
  HANDLE           hSnapshot,
  LPPROCESSENTRY32 lppe
);


HANDLE GetCurrentProcess();
DWORD GetCurrentProcessId();

HANDLE OpenProcess(
  DWORD dwDesiredAccess,
  BOOL  bInheritHandle,
  DWORD dwProcessId
);

DWORD GetModuleFileNameExA(
  HANDLE  hProcess,
  HMODULE hModule,
  LPTSTR  lpFilename,
  DWORD   nSize
);

]]

-- print.lua
ffi.cdef [[
static const int CCHDEVICENAME = 32;
static const int CCHFORMNAME = 32;

typedef DWORD ACCESS_MASK;
typedef ACCESS_MASK* PACCESS_MASK;

typedef struct _POINTL {
  LONG x;
  LONG y;
} POINTL, *PPOINTL;

typedef struct _devicemodeA {
  BYTE dmDeviceName[CCHDEVICENAME];
  WORD dmSpecVersion;
  WORD dmDriverVersion;
  WORD dmSize;
  WORD dmDriverExtra;
  DWORD dmFields;
  union {
    struct {
      short dmOrientation;
      short dmPaperSize;
      short dmPaperLength;
      short dmPaperWidth;
      short dmScale;
      short dmCopies;
      short dmDefaultSource;
      short dmPrintQuality;
    };
    struct {
      POINTL dmPosition;
      DWORD dmDisplayOrientation;
      DWORD dmDisplayFixedOutput;
    };
  };
  short dmColor;
  short dmDuplex;
  short dmYResolution;
  short dmTTOption;
  short dmCollate;
  BYTE dmFormName[CCHFORMNAME];
  WORD dmLogPixels;
  DWORD dmBitsPerPel;
  DWORD dmPelsWidth;
  DWORD dmPelsHeight;
  union {
    DWORD dmDisplayFlags;
    DWORD dmNup;
  };
  DWORD dmDisplayFrequency;
  DWORD dmICMMethod;
  DWORD dmICMIntent;
  DWORD dmMediaType;
  DWORD dmDitherType;
  DWORD dmReserved1;
  DWORD dmReserved2;
  DWORD dmPanningWidth;
  DWORD dmPanningHeight;
} DEVMODEA,*PDEVMODEA,*NPDEVMODEA,*LPDEVMODEA;

typedef struct _PRINTER_DEFAULTSA {
  LPSTR pDatatype;
  LPDEVMODEA pDevMode;
  ACCESS_MASK DesiredAccess;
} PRINTER_DEFAULTSA,*PPRINTER_DEFAULTSA,*LPPRINTER_DEFAULTSA;
typedef LPPRINTER_DEFAULTSA LPPRINTER_DEFAULTS;

typedef struct _DOC_INFO_1 {
  LPTSTR pDocName;
  LPTSTR pOutputFile;
  LPTSTR pDatatype;
} DOC_INFO_1;


BOOL OpenPrinterA(
  LPTSTR pPrinterName,
  LPHANDLE phPrinter,
  LPPRINTER_DEFAULTS pDefault
);

/*
BOOL OpenPrinter2A(
  LPCTSTR pPrinterName,
  LPHANDLE phPrinter,
  LPPRINTER_DEFAULTS pDefault,
  PPRINTER_OPTIONS pOptions
);
*/

BOOL ClosePrinter(
  HANDLE hPrinter
);

DWORD StartDocPrinterA(
  HANDLE hPrinter,
  DWORD Level,
  LPBYTE pDocInfo
);

BOOL EndDocPrinter(
  HANDLE hPrinter
);

BOOL StartPagePrinter(
  HANDLE hPrinter
);

BOOL EndPagePrinter(
  HANDLE hPrinter
);

BOOL WritePrinter(
  HANDLE hPrinter,
  LPVOID pBuf,
  DWORD cbBuf,
  LPDWORD pcWritten
);

static const int PRINTER_ENUM_LOCAL =	2;
static const int	PRINTER_ENUM_CONNECTIONS	= 4;
typedef	struct _PRINTER_INFO_2A {
  LPSTR pServerName;
  LPSTR pPrinterName;
  LPSTR pShareName;
  LPSTR pPortName;
  LPSTR pDriverName;
  LPSTR pComment;
  LPSTR pLocation;
  LPDEVMODEA pDevMode;
  LPSTR pSepFile;
  LPSTR pPrintProcessor;
  LPSTR pDatatype;
  LPSTR pParameters;
  PSECURITY_DESCRIPTOR pSecurityDescriptor;
  DWORD Attributes;
  DWORD Priority;
  DWORD DefaultPriority;
  DWORD StartTime;
  DWORD UntilTime;
  DWORD Status;
  DWORD cJobs;
  DWORD AveragePPM;
} PRINTER_INFO_2A,*PPRINTER_INFO_2A,*LPPRINTER_INFO_2A;

BOOL EnumPrintersA(
  DWORD   Flags,
  LPTSTR  Name,
  DWORD   Level,
  LPBYTE  pPrinterEnum,
  DWORD   cbBuf,
  LPDWORD pcbNeeded,
  LPDWORD pcReturned
);

BOOL GetDefaultPrinterA(
  LPTSTR  pszBuffer,
  LPDWORD pcchBuffer
);

BOOL SetDefaultPrinterA(
  LPCTSTR pszPrinter
);

]]

-- win gdiplus print
ffi.cdef [[
typedef struct {
  int     cbSize;
  LPCTSTR lpszDocName;
  LPCTSTR lpszOutput;
  LPCTSTR lpszDatatype;
  DWORD   fwType;
} DOCINFO, *LPDOCINFO;

enum DebugEventLevel
{
    DebugEventLevelFatal,
    DebugEventLevelWarning
};

typedef enum  {
  Ok                          = 0,
  GenericError                = 1,
  InvalidParameter            = 2,
  OutOfMemory                 = 3,
  ObjectBusy                  = 4,
  InsufficientBuffer          = 5,
  NotImplemented              = 6,
  Win32Error                  = 7,
  WrongState                  = 8,
  Aborted                     = 9,
  FileNotFound                = 10,
  ValueOverflow               = 11,
  AccessDenied                = 12,
  UnknownImageFormat          = 13,
  FontFamilyNotFound          = 14,
  FontStyleNotFound           = 15,
  NotTrueTypeFont             = 16,
  UnsupportedGdiplusVersion   = 17,
  GdiplusNotInitialized       = 18,
  PropertyNotFound            = 19,
  PropertyNotSupported        = 20,
  ProfileNotFound             = 21
} GpStatus;

typedef struct {
  UINT32         GdiplusVersion;
  void* 				DebugEventCallback; // DebugEventProc DebugEventCallback;
  BOOL           SuppressBackgroundThread;
  BOOL           SuppressExternalCodecs;
} GdiplusStartupInput;

typedef struct GdiplusStartupOutput {
  void* NotificationHook;
  void* NotificationUnhook;
} GdiplusStartupOutput;

GpStatus GdiplusStartup(
  ULONG_PTR *token,
  const GdiplusStartupInput *input,
  GdiplusStartupOutput *output
);

void GdiplusShutdown(void*);

int StartDocA(
  HDC     hdc,
  const DOCINFO *lpdi
);

int EndDoc(
  HDC hdc
);

int StartPage(
  HDC hDC
);

int EndPage(
  HDC hdc
);

HDC CreateDCA(LPCSTR lpszDriver,LPCSTR lpszDevice,LPCSTR lpszOutput,const void * lpInitData);

BOOL DeleteDC(
  HDC hdc
);
]]

-- everything above will stay, below will be generated --
-- ******************** --
-- generated code start --

--[[ lib_http.lua ]]
--[[ lib_kqueue.lua ]]
--[[ system/poll.lua ]]
ffi.cdef [[
static const int POLLRDBAND = 0x0200;
static const int POLLRDNORM = 0x0100;
static const int POLLWRNORM = 0x0010;
static const int POLLERR = 0x0001;
static const int POLLHUP = 0x0002;
static const int POLLIN = (POLLRDNORM | POLLRDBAND);
static const int POLLNVAL = 0x0004;
static const int POLLOUT = (POLLWRNORM);

typedef UINT_PTR SOCKET;

typedef struct pollfd {
    SOCKET fd;
    SHORT events;
    SHORT revents;
} WSAPOLLFD, *PWSAPOLLFD, *LPWSAPOLLFD;

]]

--[[ lib_shared_memory.lua ]]
ffi.cdef [[


HANDLE
CreateFileMappingA(
    HANDLE hFile,
    LPSECURITY_ATTRIBUTES lpFileMappingAttributes,
    DWORD flProtect,
    DWORD dwMaximumSizeHigh,
    DWORD dwMaximumSizeLow,
    LPCSTR lpName
    );

DWORD
GetLastError(
    VOID
    );

LPVOID
MapViewOfFile(
    HANDLE hFileMappingObject,
    DWORD dwDesiredAccess,
    DWORD dwFileOffsetHigh,
    DWORD dwFileOffsetLow,
    SIZE_T dwNumberOfBytesToMap
    );

HANDLE
OpenFileMappingA(
    DWORD dwDesiredAccess,
    BOOL bInheritHandle,
    LPCSTR lpName
    );
size_t strlen( const char * _Str);

BOOL
UnmapViewOfFile(
    LPCVOID lpBaseAddress
    );
]]

--[[ lib_signal.lua ]]
--[[ socket.lua ]]
ffi.cdef [[
static const int	PF_UNSPEC = 0;		// Unspecified.
static const int	SHUT_RD		= 0;		/* shut down the reading side */
static const int	SHUT_WR		= 1;		/* shut down the writing side */
static const int	SHUT_RDWR	= 2;		/* shut down both sides */
/*
typedef struct _GUID {
    unsigned long Data1;
    unsigned short Data2;
    unsigned short Data3;
    unsigned char Data4[ 8 ];
} GUID;
*/

typedef struct _WSAPROTOCOLCHAIN {
    int ChainLen; /* the length of the chain,     */
    DWORD ChainEntries[7]; /* a list of dwCatalogEntryIds */
} WSAPROTOCOLCHAIN, * LPWSAPROTOCOLCHAIN;
typedef void *PVOID;
typedef int socklen_t;


  // Constants for getaddrinfo()
  static const int AI_PASSIVE                  =0x00000001;
typedef struct addrinfo
{
    int ai_flags; // AI_PASSIVE, AI_CANONNAME, AI_NUMERICHOST
    int ai_family; // PF_xxx
    int ai_socktype; // SOCK_xxx
    int ai_protocol; // 0 or IPPROTO_xxx for IPv4 and IPv6
    size_t ai_addrlen; // Length of ai_addr
    char * ai_canonname; // Canonical name for nodename
    struct sockaddr * ai_addr; // Binary address
    struct addrinfo * ai_next; // Next structure in linked list
}
ADDRINFOA, *PADDRINFOA;


typedef struct _WSAPROTOCOL_INFOA {
    DWORD dwServiceFlags1;
    DWORD dwServiceFlags2;
    DWORD dwServiceFlags3;
    DWORD dwServiceFlags4;
    DWORD dwProviderFlags;
    GUID ProviderId;
    DWORD dwCatalogEntryId;
    WSAPROTOCOLCHAIN ProtocolChain;
    int iVersion;
    int iAddressFamily;
    int iMaxSockAddr;
    int iMinSockAddr;
    int iSocketType;
    int iProtocol;
    int iProtocolMaxOffset;
    int iNetworkByteOrder;
    int iSecurityScheme;
    DWORD dwMessageSize;
    DWORD dwProviderReserved;
    CHAR szProtocol[255 +1];
} WSAPROTOCOL_INFOA, * LPWSAPROTOCOL_INFOA;
typedef CHAR *PCHAR, *LPCH, *PCH;


static const int UNIX_PATH_MAX = 108;
typedef struct sockaddr_un {
  ADDRESS_FAMILY sun_family;
  char sun_path[UNIX_PATH_MAX];
} SOCKADDR_UN, *PSOCKADDR_UN;

typedef struct sockaddr_in {
    ADDRESS_FAMILY sin_family;
    USHORT sin_port;
    IN_ADDR sin_addr;
    CHAR sin_zero[8];
} SOCKADDR_IN, *PSOCKADDR_IN;
typedef DWORD *LPDWORD;

typedef struct sockaddr {
    ADDRESS_FAMILY sa_family; // Address family.
    CHAR sa_data[14]; // Up to 14 bytes of direct address.
} SOCKADDR, *PSOCKADDR, *LPSOCKADDR;

typedef struct WSAData {
        WORD wVersion;
        WORD wHighVersion;
        unsigned short iMaxSockets;
        unsigned short iMaxUdpDg;
        char * lpVendorInfo;
        char szDescription[256 +1];
        char szSystemStatus[128 +1];
} WSADATA, * LPWSADATA;

typedef struct hostent {
  char *h_name;
  char **h_aliases;
  short h_addrtype;
  short h_length;
  char **h_addr_list;
} HOSTENT, *PHOSTENT, *LPHOSTENT;

struct hostent* gethostbyname(
  const char *name
);

char*
inet_ntoa(
  struct in_addr in
);

int gethostname(
  char *name,
  int namelen
);

SOCKET
accept(
    SOCKET s,
    struct sockaddr * addr,
    int * addrlen
    );

int
bind(
    SOCKET s,
    const struct sockaddr * name,
    int namelen
    );

int
closesocket(
    SOCKET s
    );

int
connect(
    SOCKET s,
    const struct sockaddr * name,
    int namelen
    );

INT
getaddrinfo(
    PCSTR pNodeName,
    PCSTR pServiceName,
    const ADDRINFOA * pHints,
    PADDRINFOA * ppResult
    );

INT
getnameinfo(
    const SOCKADDR * pSockaddr,
    socklen_t SockaddrLength,
    PCHAR pNodeBuffer,
    DWORD NodeBufferSize,
    PCHAR pServiceBuffer,
    DWORD ServiceBufferSize,
    INT Flags
    );

int
getpeername(
    SOCKET s,
    struct sockaddr * name,
    int * namelen
    );

int
getsockopt(
    SOCKET s,
    int level,
    int optname,
    char * optval,
    int * optlen
    );

u_short
htons(
    u_short hostshort
    );

PCSTR
inet_ntop(
    INT Family,
    PVOID pAddr,
    PSTR pStringBuf,
    size_t StringBufSize
    );

int
ioctlsocket(
    SOCKET s,
    long cmd,
    u_long * argp
    );

int
listen(
    SOCKET s,
    int backlog
    );

u_short
ntohs(
    u_short netshort
    );

unsigned long
inet_addr(
  const char *cp
);

int
recv(
    SOCKET s,
    char * buf,
    int len,
    int flags
   );

int
recvfrom(
  SOCKET s,
  char * buf,
  int len,
  int flags,
  struct sockaddr * from,
  int * fromlen
);

int
send(
    SOCKET s,
    const char * buf,
    int len,
    int flags
);

int sendto(
  SOCKET s,
  const char *buf,
  int len,
  int flags,
  const struct sockaddr *to,
  int tolen
);

int
setsockopt(
    SOCKET s,
    int level,
    int optname,
    const char * optval,
    int optlen
    );

int
shutdown(
    SOCKET s,
    int how
    );

SOCKET
socket(
    int af,
    int type,
    int protocol
    );
]]

-- socket WSA
ffi.cdef [[

typedef struct __WSABUF {
	u_long len;
	char * buf;
} WSABUF,  *LPWSABUF;

typedef DWORD       WSAEVENT, *LPWSAEVENT;
typedef HANDLE      WSAEVENT;
typedef LPHANDLE    LPWSAEVENT;

/*
 * WSAMSG -- for WSASendMsg
 */
typedef struct _WSAMSG {
    LPSOCKADDR       name;
    INT              namelen;
    LPWSABUF         lpBuffers;
    ULONG            dwBufferCount;
    WSABUF           Control;
    ULONG            dwFlags;
} WSAMSG, *PWSAMSG, * LPWSAMSG;

static const int    FD_SETSIZE = 64;
typedef struct fd_set {
    u_int fd_count;               /* how many are SET? */
    SOCKET  fd_array[FD_SETSIZE];   /* an array of SOCKETs */
} fd_set;

static const int WSA_FLAG_OVERLAPPED = 0x01;
typedef OVERLAPPED	WSAOVERLAPPED;
typedef struct _OVERLAPPED *LPWSAOVERLAPPED;
typedef unsigned int GROUP;

typedef void (* LPWSAOVERLAPPED_COMPLETION_ROUTINE)(
    DWORD dwError,
    DWORD cbTransferred,
    LPWSAOVERLAPPED lpOverlapped,
    DWORD dwFlags
    );

INT
WSAAddressToStringA(
    LPSOCKADDR lpsaAddress,
    DWORD dwAddressLength,
    LPWSAPROTOCOL_INFOA lpProtocolInfo,
    LPSTR lpszAddressString,
    LPDWORD lpdwAddressStringLength
    );

int
WSACleanup(
    void
    );

int
WSAGetLastError(
    void
    );

int
WSAPoll(
    LPWSAPOLLFD fdArray,
    ULONG fds,
    INT timeout
    );

int
WSAStartup(
    WORD wVersionRequested,
    LPWSADATA lpWSAData
    );

int __WSAFDIsSet(SOCKET fd, fd_set *);

INT WSAAddressToStringA(
		LPSOCKADDR lpsaAddress,
    DWORD dwAddressLength,
    LPWSAPROTOCOL_INFOA lpProtocolInfo,
    LPSTR lpszAddressString,
    LPDWORD lpdwAddressStringLength);

int WSAIoctl(
    SOCKET s,
    DWORD dwIoControlCode,
    LPVOID lpvInBuffer,
    DWORD cbInBuffer,
    LPVOID lpvOutBuffer,
    DWORD cbOutBuffer,
    LPDWORD lpcbBytesReturned,
    LPWSAOVERLAPPED lpOverlapped,
    LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine);

int WSAEnumProtocolsA(
    LPINT lpiProtocols,
    LPWSAPROTOCOL_INFOA lpProtocolBuffer,
    LPDWORD lpdwBufferLength);

BOOL
WSAGetOverlappedResult(
    SOCKET s,
    LPWSAOVERLAPPED lpOverlapped,
    LPDWORD lpcbTransfer,
    BOOL fWait,
    LPDWORD lpdwFlags);

int WSARecv(
    SOCKET s,
    LPWSABUF lpBuffers,
    DWORD dwBufferCount,
    LPDWORD lpNumberOfBytesRecvd,
    LPDWORD lpFlags,
    LPWSAOVERLAPPED lpOverlapped,
    void* lpCompletionRoutine);

int
WSARecvFrom(
    SOCKET s,
    LPWSABUF lpBuffers,
    DWORD dwBufferCount,
    LPDWORD lpNumberOfBytesRecvd,
    LPDWORD lpFlags,
    struct sockaddr * lpFrom,
    LPINT lpFromlen,
    LPWSAOVERLAPPED lpOverlapped,
    LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine);


int WSASend(SOCKET s,
	LPWSABUF lpBuffers,
	DWORD dwBufferCount,
    LPDWORD lpNumberOfBytesSent,
    DWORD dwFlags,
    LPWSAOVERLAPPED lpOverlapped,
	LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine);

int WSASendDisconnect(SOCKET s, LPWSABUF lpOutboundDisconnectData);

int WSASendMsg(SOCKET Handle,
    LPWSAMSG lpMsg,
    DWORD dwFlags,
    LPDWORD lpNumberOfBytesSent,
    LPWSAOVERLAPPED lpOverlapped,
    LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine);

int WSASendTo(SOCKET s,
    LPWSABUF lpBuffers,
    DWORD dwBufferCount,
    LPDWORD lpNumberOfBytesSent,
    DWORD dwFlags,
    const struct sockaddr * lpTo,
    int iTolen,
    LPWSAOVERLAPPED lpOverlapped,
    LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine);

BOOL WSASetEvent(WSAEVENT hEvent);

SOCKET WSASocketA(
    int af,
    int type,
    int protocol,
    LPWSAPROTOCOL_INFOA lpProtocolInfo,
    GROUP g,
    DWORD dwFlags);

]]

--[[ system/socket.lua ]]
ffi.cdef [[
static const int AF_INET = 2;
static const int AF_INET6 = 23;
static const int INET6_ADDRSTRLEN = 65;
static const int INET_ADDRSTRLEN = 22;
static const int SO_RCVBUF = 0x1002;
static const int SO_REUSEADDR = 0x0004;
static const int SO_BROADCAST = 0x0020;
// static const int SO_USELOOPBACK = 0x0040;
// static const int SO_LINGER = 0x0080;
static const int SO_SNDBUF = 0x1001;
static const int SO_USELOOPBACK = 0x0040;
static const int SOCK_STREAM = 1;
static const int SOCK_DGRAM = 2;
static const int SOL_SOCKET = 0xffff;
static const int SOMAXCONN = 0x7fffffff;
static const int TCP_NODELAY = 0x0001;

/* DWORD fDsrHold : 1;
typedef struct {
    union {
        struct {
            ULONG Zone : 28;
            ULONG Level : 4;
        };
        ULONG Value;
    };
} SCOPE_ID, *PSCOPE_ID;


typedef struct in6_addr {
    union {
        UCHAR Byte[16];
        USHORT Word[8];
    } u;
} IN6_ADDR, *PIN6_ADDR, *LPIN6_ADDR;
typedef enum _RTL_UMS_THREAD_INFO_CLASS UMS_THREAD_INFO_CLASS, *PUMS_THREAD_INFO_CLASS;

typedef struct sockaddr_in6 {
    ADDRESS_FAMILY sin6_family; // AF_INET6.
    USHORT sin6_port; // Transport level port number.
    ULONG sin6_flowinfo; // IPv6 flow information.
    IN6_ADDR sin6_addr; // IPv6 address.
    union {
        ULONG sin6_scope_id; // Set of interfaces for a scope.
        SCOPE_ID sin6_scope_struct;
    };

IN6_ADDR sin6_addr;
USHORT sin6_port;
*/

typedef struct sockaddr_storage {
    ADDRESS_FAMILY ss_family; // address family
    CHAR __ss_pad1[((sizeof(__int64)) - sizeof(USHORT))]; // 6 byte pad, this is to make
    __int64 __ss_align; // Field to force desired structure
    CHAR __ss_pad2[(128 - (sizeof(USHORT) + ((sizeof(__int64)) - sizeof(USHORT)) + (sizeof(__int64))))]; // 112 byte pad to achieve desired size;
} SOCKADDR_STORAGE_LH, *PSOCKADDR_STORAGE_LH, *LPSOCKADDR_STORAGE_LH;


typedef enum {
    IPPROTO_HOPOPTS = 0,
    IPPROTO_ICMP = 1,
    IPPROTO_IGMP = 2,
    IPPROTO_GGP = 3,
    IPPROTO_IPV4 = 4,
    IPPROTO_ST = 5,
    IPPROTO_TCP = 6,
    IPPROTO_CBT = 7,
    IPPROTO_EGP = 8,
    IPPROTO_IGP = 9,
    IPPROTO_PUP = 12,
    IPPROTO_UDP = 17,
    IPPROTO_IDP = 22,
    IPPROTO_RDP = 27,
    IPPROTO_IPV6 = 41,
    IPPROTO_ROUTING = 43,
    IPPROTO_FRAGMENT = 44,
    IPPROTO_ESP = 50,
    IPPROTO_AH = 51,
    IPPROTO_ICMPV6 = 58,
    IPPROTO_NONE = 59,
    IPPROTO_DSTOPTS = 60,
    IPPROTO_ND = 77,
    IPPROTO_ICLFXBM = 78,
    IPPROTO_PIM = 103,
    IPPROTO_PGM = 113,
    IPPROTO_L2TP = 115,
    IPPROTO_SCTP = 132,
    IPPROTO_RAW = 255,
    IPPROTO_MAX = 256,
    IPPROTO_RESERVED_RAW = 257,
    IPPROTO_RESERVED_IPSEC = 258,
    IPPROTO_RESERVED_IPSECOFFLOAD = 259,
    IPPROTO_RESERVED_MAX = 260
} IPPROTO, *PIPROTO;

]]

--[[ lib_thread.lua ]]
ffi.cdef [[
static const int THREAD_QUERY_INFORMATION = 0x0040;
static const int INFINITE = 0xFFFFFFFF; // static const dword earlier...
typedef DWORD (*PTHREAD_START_ROUTINE)(
    LPVOID lpThreadParameter
    );
typedef PTHREAD_START_ROUTINE LPTHREAD_START_ROUTINE;
typedef struct _CREATE_THREAD_DEBUG_INFO {
    HANDLE hThread;
    LPVOID lpThreadLocalBase;
    LPTHREAD_START_ROUTINE lpStartAddress;
} CREATE_THREAD_DEBUG_INFO, *LPCREATE_THREAD_DEBUG_INFO;

HANDLE CreateThread(
  LPSECURITY_ATTRIBUTES lpThreadAttributes,
  size_t dwStackSize,
  LPTHREAD_START_ROUTINE lpStartAddress,
  LPVOID lpParameter,
  DWORD dwCreationFlags,
  LPDWORD lpThreadId
);

DWORD GetCurrentThreadId(VOID);

DWORD WaitForSingleObject(
    HANDLE hHandle,
    DWORD dwMilliseconds
);

VOID ExitThread(
  DWORD dwExitCode
);

BOOL GetExitCodeThread(
  HANDLE  hThread,
  LPDWORD lpExitCode
);
]]

--[[ lib_util.lua ]]
ffi.cdef [[
static const int ENABLE_ECHO_INPUT = 0x0004;
static const int ENABLE_LINE_INPUT = 0x0002;
static const int FORMAT_MESSAGE_FROM_SYSTEM = 0x00001000;
static const int FORMAT_MESSAGE_IGNORE_INSERTS = 0x00000200;


typedef struct _SYSTEM_INFO {
    union {
        DWORD dwOemId; // Obsolete field...do not use
        struct {
            WORD wProcessorArchitecture;
            WORD wReserved;
        } DUMMYSTRUCTNAME;
    } DUMMYUNIONNAME;
    DWORD dwPageSize;
    LPVOID lpMinimumApplicationAddress;
    LPVOID lpMaximumApplicationAddress;
    DWORD_PTR dwActiveProcessorMask;
    DWORD dwNumberOfProcessors;
    DWORD dwProcessorType;
    DWORD dwAllocationGranularity;
    WORD wProcessorLevel;
    WORD wProcessorRevision;
} SYSTEM_INFO, *LPSYSTEM_INFO;

typedef union _LARGE_INTEGER {
    struct {
        DWORD LowPart;
        LONG HighPart;
    } s;
    struct {
        DWORD LowPart;
        LONG HighPart;
    } u;
    LONG QuadPart;
} LARGE_INTEGER;

typedef struct _CONSOLE_READCONSOLE_CONTROL {
    ULONG nLength;
    ULONG nInitialChars;
    ULONG dwCtrlWakeupMask;
    ULONG dwControlKeyState;
} CONSOLE_READCONSOLE_CONTROL, *PCONSOLE_READCONSOLE_CONTROL;

struct timeval {
        long tv_sec; /* seconds */
        long tv_usec; /* and microseconds */
};


DWORD
FormatMessageA(
    DWORD dwFlags,
    LPCVOID lpSource,
    DWORD dwMessageId,
    DWORD dwLanguageId,
    LPSTR lpBuffer,
    DWORD nSize,
    va_list *Arguments
    );

BOOL
GetConsoleMode(
    HANDLE hConsoleHandle,
    LPDWORD lpMode
    );

HANDLE
GetStdHandle(
    DWORD nStdHandle
    );
VOID
GetSystemInfo(
    LPSYSTEM_INFO lpSystemInfo
    );

BOOL
QueryPerformanceCounter(
    LARGE_INTEGER *lpPerformanceCount
    );

BOOL
QueryPerformanceFrequency(
    LARGE_INTEGER *lpFrequency
    );

BOOL
ReadConsoleW(
    HANDLE hConsoleInput,
		LPVOID lpBuffer,
    DWORD nNumberOfCharsToRead,
    LPDWORD lpNumberOfCharsRead,
    PCONSOLE_READCONSOLE_CONTROL pInputControl
    );

BOOL
SetConsoleMode(
    HANDLE hConsoleHandle,
    DWORD dwMode
    );

VOID
Sleep(
    DWORD dwMilliseconds
    );
char * strerror( int);

BOOL
SwitchToThread(
    VOID
    );
]]

--[[ TestAddrinfo.lua ]]
ffi.cdef [[
static const int NI_MAXHOST = 1025;
static const int NI_MAXSERV = 32;
static const int NI_NAMEREQD = 0x04;
static const int NI_NUMERICHOST = 0x02;
static const int NI_NUMERICSERV = 0x08;
]]

-- lib_util
-- ffi.cdef[[ ]]

-- net.lua
ffi.cdef [[
static const int MIB_IPADDR_PRIMARY = 0x0001;
static const int MIB_IPADDR_DYNAMIC = 0x0004;
static const int MIB_IPADDR_DISCONNECTED = 0x0008;
static const int MIB_IPADDR_DELETED = 0x0040;
static const int MIB_IPADDR_TRANSIENT = 0x0080;

// copied from: /Users/pasi/installed/Lua/Luajit-Tcp-Server/c_include/windows/ffi_types.h
static const long NO_ERROR = 0L;
static const long ERROR_INSUFFICIENT_BUFFER = 122L;

// copied from: /Users/pasi/installed/Lua/luajit-winapi/ffi/winapi/windows/iphlpapi.lua
enum { ANY_SIZE = 1 };
typedef ULONG NET_IFINDEX; //Alias
// typedef NET_IFINDEX *PNET_IFINDEX; //Pointer
typedef NET_IFINDEX IF_INDEX; //Alias
typedef unsigned short WINAPI_MIB_IPADDR_TYPE; //Alias
typedef struct MIB_IPADDRROW {
	DWORD dwAddr;
	IF_INDEX dwIndex;
	DWORD dwMask;
	DWORD dwBCastAddr;
	DWORD dwReasmSize;
	unsigned short unused1;
	WINAPI_MIB_IPADDR_TYPE wType;
} MIB_IPADDRROW;
typedef struct MIB_IPADDRTABLE {
	DWORD dwNumEntries;
	MIB_IPADDRROW table[ANY_SIZE];
} MIB_IPADDRTABLE;
typedef MIB_IPADDRTABLE *PMIB_IPADDRTABLE; //Pointer
DWORD GetIpAddrTable(
  PMIB_IPADDRTABLE pIpAddrTable,
  PULONG           pdwSize,
  BOOL             bOrder
);
]]

--[[
static const int MAX_ADAPTER_ADDRESS_LENGTH = 8;

typedef enum {
  IfOperStatusUp = 1,
  IfOperStatusDown,
  IfOperStatusTesting,
  IfOperStatusUnknown,
  IfOperStatusDormant,
  IfOperStatusNotPresent,
  IfOperStatusLowerLayerDown
} IF_OPER_STATUS;

typedef enum  {
  IpDadStateInvalid     = 0,
  IpDadStateTentative,
  IpDadStateDuplicate,
  IpDadStateDeprecated,
  IpDadStatePreferred
} IP_DAD_STATE;


typedef enum  {
  IpPrefixOriginOther                = 0,
  IpPrefixOriginManual,
  IpPrefixOriginWellKnown,
  IpPrefixOriginDhcp,
  IpPrefixOriginRouterAdvertisement,
  IpPrefixOriginUnchanged            = 16
} IP_PREFIX_ORIGIN;

typedef enum  {
  IpSuffixOriginOther             = 0,
  IpSuffixOriginManual,
  IpSuffixOriginWellKnown,
  IpSuffixOriginDhcp,
  IpSuffixOriginLinkLayerAddress,
  IpSuffixOriginRandom,
  IpSuffixOriginUnchanged         = 16
} IP_SUFFIX_ORIGIN;

typedef struct _SOCKET_ADDRESS {
  LPSOCKADDR lpSockaddr;
  INT        iSockaddrLength;
} SOCKET_ADDRESS, *PSOCKET_ADDRESS;


typedef struct _IP_ADAPTER_PREFIX {
  union {
    ULONGLONG  Alignment;
    struct {
      ULONG Length;
      DWORD Flags;
    };
  };
  struct _IP_ADAPTER_PREFIX  *Next;
  SOCKET_ADDRESS            Address;
  ULONG                     PrefixLength;
} IP_ADAPTER_PREFIX, *PIP_ADAPTER_PREFIX;

typedef struct _IP_ADAPTER_UNICAST_ADDRESS {
  union {
    struct {
      ULONG Length;
      DWORD Flags;
    };
  };
  struct _IP_ADAPTER_UNICAST_ADDRESS  *Next;
  SOCKET_ADDRESS                     Address;
  IP_PREFIX_ORIGIN                   PrefixOrigin;
  IP_SUFFIX_ORIGIN                   SuffixOrigin;
  IP_DAD_STATE                       DadState;
  ULONG                              ValidLifetime;
  ULONG                              PreferredLifetime;
  ULONG                              LeaseLifetime;
  UINT8                              OnLinkPrefixLength;
} IP_ADAPTER_UNICAST_ADDRESS, *PIP_ADAPTER_UNICAST_ADDRESS;


typedef struct _IP_ADAPTER_ANYCAST_ADDRESS {
  union {
    ULONGLONG Alignment;
    struct {
      ULONG Length;
      DWORD Flags;
    };
  };
  struct _IP_ADAPTER_ANYCAST_ADDRESS  *Next;
  SOCKET_ADDRESS                     Address;
} IP_ADAPTER_ANYCAST_ADDRESS, *PIP_ADAPTER_ANYCAST_ADDRESS;

typedef struct _IP_ADAPTER_MULTICAST_ADDRESS {
  union {
    ULONGLONG Alignment;
    struct {
      ULONG Length;
      DWORD Flags;
    };
  };
  struct _IP_ADAPTER_MULTICAST_ADDRESS  *Next;
  SOCKET_ADDRESS                       Address;
} IP_ADAPTER_MULTICAST_ADDRESS, *PIP_ADAPTER_MULTICAST_ADDRESS;


typedef struct _IP_ADAPTER_DNS_SERVER_ADDRESS {
  union {
    ULONGLONG Alignment;
    struct {
      ULONG Length;
      DWORD Reserved;
    };
  };
  struct _IP_ADAPTER_DNS_SERVER_ADDRESS  *Next;
  SOCKET_ADDRESS                        Address;
} IP_ADAPTER_DNS_SERVER_ADDRESS, *PIP_ADAPTER_DNS_SERVER_ADDRESS;


typedef struct _IP_ADAPTER_ADDRESSES {
  union {
    ULONGLONG Alignment;
    struct {
      ULONG Length;
      DWORD IfIndex;
    };
  };
  struct _IP_ADAPTER_ADDRESSES  *Next;
  PCHAR                              AdapterName;
  PIP_ADAPTER_UNICAST_ADDRESS        FirstUnicastAddress;
  PIP_ADAPTER_ANYCAST_ADDRESS        FirstAnycastAddress;
  PIP_ADAPTER_MULTICAST_ADDRESS      FirstMulticastAddress;
  PIP_ADAPTER_DNS_SERVER_ADDRESS     FirstDnsServerAddress;
  PWCHAR                             DnsSuffix;
  PWCHAR                             Description;
  PWCHAR                             FriendlyName;
  BYTE                               PhysicalAddress[MAX_ADAPTER_ADDRESS_LENGTH];
  DWORD                              PhysicalAddressLength;
  DWORD                              Flags;
  DWORD                              Mtu;
  DWORD                              IfType;
  IF_OPER_STATUS                     OperStatus;
  DWORD                              Ipv6IfIndex;
  DWORD                              ZoneIndices[16];
  PIP_ADAPTER_PREFIX                 FirstPrefix;
  ULONG64                            TransmitLinkSpeed;
  ULONG64                            ReceiveLinkSpeed;
  PIP_ADAPTER_WINS_SERVER_ADDRESS_LH FirstWinsServerAddress;
  PIP_ADAPTER_GATEWAY_ADDRESS_LH     FirstGatewayAddress;
  ULONG                              Ipv4Metric;
  ULONG                              Ipv6Metric;
  IF_LUID                            Luid;
  SOCKET_ADDRESS                     Dhcpv4Server;
  NET_IF_COMPARTMENT_ID              CompartmentId;
  NET_IF_NETWORK_GUID                NetworkGuid;
  NET_IF_CONNECTION_TYPE             ConnectionType;
  TUNNEL_TYPE                        TunnelType;
  SOCKET_ADDRESS                     Dhcpv6Server;
  BYTE                               Dhcpv6ClientDuid[MAX_DHCPV6_DUID_LENGTH];
  ULONG                              Dhcpv6ClientDuidLength;
  ULONG                              Dhcpv6Iaid;
  PIP_ADAPTER_DNS_SUFFIX             FirstDnsSuffix;
} IP_ADAPTER_ADDRESSES, *PIP_ADAPTER_ADDRESSES;


ULONG GetAdaptersAddresses(
  ULONG Family,
  ULONG Flags,
  PVOID Reserved,
  PIP_ADAPTER_ADDRESSES AdapterAddresses,
  PULONG SizePointer
);
]]

--[[ TestAll.lua ]]
--[[ TestKqueue.lua ]]
--[[ TestLinux.lua ]]
--[[ TestSharedMemory.lua ]]
--[[ TestSignal.lua ]]
--[[ TestSignal_bad.lua ]]
--[[ TestSocket.lua ]]
ffi.cdef [[
static const int SD_SEND = 0x01;
]]

--[[ TestThread.lua ]]

--[[
not found calls = {
   [1] = "--- lib_date_time.lua ---";
   [2] = "--- lib_http.lua ---";
   [3] = "--- lib_kqueue.lua ---";
   [4] = "--- system/poll.lua ---";
   [5] = "--- lib_shared_memory.lua ---";
   [6] = "close";
   [7] = "ftruncate";
   [8] = "MAP_SHARED";
   [9] = "mmap";
   [10] = "munmap";
   [11] = "O_CREAT";
   [12] = "O_RDONLY";
   [13] = "O_RDWR";
   [14] = "PROT_READ";
   [15] = "PROT_WRITE";
   [16] = "shm_open";
   [17] = "shm_unlink";
   [18] = "--- lib_signal.lua ---";
   [19] = "getpid";
   [20] = "kill";
   [21] = "pthread_sigmask";
   [22] = "sigaddset";
   [23] = "sigemptyset";
   [24] = "sigwait";
   [25] = "--- socket.lua ---";
   [26] = "close";
   [27] = "F_GETFL";
   [28] = "F_SETFL";
   [29] = "fcntl";
   [30] = "gai_strerror";
   [31] = "O_NONBLOCK";
   [32] = "poll";
   [33] = "--- system/socket.lua ---";
   [34] = "--- lib_thread.lua ---";
   [35] = "pthread_create";
   [36] = "pthread_exit";
   [37] = "pthread_join";
   [38] = "pthread_self";
   [39] = "--- lib_util.lua ---";
   [40] = "_SC_NPROCESSORS_CONF";
   [41] = "_SC_NPROCESSORS_ONLN";
   [42] = "gettimeofday";
   [43] = "nanosleep";
   [44] = "sched_yield";
   [45] = "sysconf";
   [46] = "usleep";
   [47] = "--- TestAddrinfo.lua ---";
   [48] = "--- TestAll.lua ---";
   [49] = "--- TestKqueue.lua ---";
   [50] = "close";
   [51] = "EV_ADD";
   [52] = "EV_ENABLE";
   [53] = "EV_ONESHOT";
   [54] = "EVFILT_VNODE";
   [55] = "kevent";
   [56] = "kqueue";
   [57] = "NOTE_ATTRIB";
   [58] = "NOTE_DELETE";
   [59] = "NOTE_EXTEND";
   [60] = "NOTE_WRITE";
   [61] = "O_RDONLY";
   [62] = "open";
   [63] = "--- TestLinux.lua ---";
   [64] = "mmap";
   [65] = "munmap";
   [66] = "O_CREAT";
   [67] = "O_EXCL";
   [68] = "shm_open";
   [69] = "shm_unlink";
   [70] = "--- TestSharedMemory.lua ---";
   [71] = "--- TestSignal.lua ---";
   [72] = "--- TestSignal_bad.lua ---";
   [73] = "getpid";
   [74] = "kill";
   [75] = "pause";
   [76] = "signal";
   [77] = "--- TestSocket.lua ---";
   [78] = "--- TestThread.lua ---";
};
]]

--[[
not found basic types = {
   [1] = "kevent";
   [2] = "sigset_t";
   [3] = "pthread_t";
   [4] = "thread_func";
   [5] = "timespec";
};
]]
