--- filter_map_reduce.lua
-- old: fmr.lua
--
-- @ module filter_map_reduce
local util = require "util"
local fn = require "fn"
local peg = require "peg"
local l = require"lang".l
--[[
local auth = require "auth"

--]]

local fmr = {}

local leadTime = require "form/nc/report/lead-time/query/lead_time" -- delete leadTime later
fmr.leadTimeProData = leadTime.proData
fmr.leadTimeOrdrData = leadTime.ordrData

function fmr.arrayFirstKey(arr, key, defaultReturnValue)
	if arr and arr[1] and arr[1][key] then
		return arr[1][key]
	end
	return defaultReturnValue or ""
end

function fmr.parseBeforeFromArray(arr, delimiter)
	local retKey = {}
	local val
	local ret = fn.iter(arr):map(function(str)
		val = peg.parseBefore(str, delimiter) -- "0101/02" -> "0101"
		if retKey[val] then -- return only unique
			return nil
		end
		retKey[val] = true
		return val
	end)
	ret = ret:totable()
	return ret
end

function fmr.filter(name, data)
	util.printWarning("fmr.filter not done: " .. name)
	return data
end

function fmr.map(name, data, ...)
	if fmr[name] then
		return fmr[name](data, ...)
	else
		util.printWarning("fmr.map not done: " .. name)
	end
	return data
end

function fmr.reduce(name, data, ...)
	if fmr[name] then
		return fmr[name](data, ...)
	else
		util.printWarning("fmr.reduce not done: " .. name)
	end
	return data
end

function fmr.sort(arr, ruleArr)
	-- see: db_query_json.lua / function runOrder
	-- see: execute.lua / sort
	-- local time = util.seconds()
	local err
	if type(arr) ~= "table" then
		-- return -- may be nil data
		err = "parameter 1 type is not an array"
	elseif type(ruleArr) ~= "table" then
		err = "parameter 2 type is not an array"
	end
	if #ruleArr % 2 ~= 0 then
		err = "parameter 2 rule array is not even length"
	end
	if #ruleArr < 2 then
		err = "parameter 2 rule array length is smaller than 2"
	end
	if err then
		util.printError("fmr.sort error: " .. err)
		return
	end

	local fldArr = {}
	for i = 1, #ruleArr, 2 do
		local rec = {fld = ruleArr[i], comp = ruleArr[i + 1]}
		if ruleArr[i + 1] == ">" then
			-- rec.op1 = fn.operator.gt -- https://rtsisyk.github.io/luafun/operators.html
			-- rec.op2 = fn.operator.lt
		elseif ruleArr[i + 1] == "<" then
			-- rec.op1 = fn.operator.lt
			-- rec.op2 = fn.operator.gt
		else
			util.printError("fmr.sort compare is not '>' or '<'")
			return
		end
		fldArr[#fldArr + 1] = rec
	end

	--[[
	local func1 = function(a, b) -- sort by id, it starts with count number
		for _, rule in ipairs(fldArr) do
			if a[rule.fld] == nil or b[rule.fld] == nil then
				err = l("fmr.sort field '%s' does not exist", rule.fld)
				return false
			end
			if rule.op1(a[rule.fld], b[rule.fld]) then
				return true
			elseif rule.op2(a[rule.fld], b[rule.fld]) then
				return false
			end
			-- is equal, continue to next rule
		end
		return true -- true causes "invalid order function"
	end
	local time1 = util.seconds()
	table.sort(arr, func1)
	time1 = util.seconds(time1)
	--]]

	--[[
		The comparison function must return a boolean value specifying whether the first argument should be before the second argument in the sequence. The default behaviour is for the < comparison to be made. For example, the following behaves the same as no function being supplied:
		t = { 3,2,5,1,4 }
		table.sort(t, function(a,b) return a<b end)
	]]

	local a, b
	local func2 = function(aa, bb) -- sort by id, it starts with count number
		-- see: execute.lua / sort
		for _, rule in ipairs(fldArr) do
			if type(aa[rule.fld]) == "string" then -- should check if fied needs lower from pref
				a = aa[rule.fld]:lower() -- using this: 0.0029 seconds without lower to 0.0069 with lower, row count: 2140
				b = bb[rule.fld]:lower()
			else
				a, b = aa[rule.fld], bb[rule.fld]
			end
			if a == nil or b == nil then
				err = l("fmr.sort field '%s' does not exist", rule.fld)
				return false
			end
			if rule.comp == ">" then
				if a > b then
					return false
				elseif a < b then
					return true
				end
			elseif rule.comp == "<" then
				if a < b then
					return false
				elseif a > b then
					return true
				end
			end
			-- is equal, continue to next rule
		end
		-- util.printWarning("fmr.sort needs more sort fileds: "..json.toJson(ruleArr))
		return false -- true causes "invalid order function"
	end

	-- local time2 = util.seconds()
	table.sort(arr, func2)
	-- time2 = util.seconds(time2)
	-- time = util.seconds(time)
	if err then
		util.printError(err)
	end

	-- util.printDebug("fmr.sort, row count: %d, time: %.6f seconds", #arr, util.seconds(time))
	-- util.printDebug("fmr.sort, row count: %d, sort time1 : %.6f, sort time2 : %.6f, time: %.6f seconds", #arr, time1, time2, util.seconds(time))
	-- fmr.sort, row count: 2269, sort time1 : 0.005463, sort time2 : 0.005197, time: 0.010667 seconds
	-- return arr
end

return fmr
