--- fsevent_osx.lua
-- listen file system events, OSX 64 bit only
-- g++ fsevent.cpp -o libfsevent.dylib -dynamiclib -framework CoreFoundation -framework CoreServices
-- g++ fsevent.cpp -o fsevent -framework CoreFoundation -framework CoreServices && ./fsevent . /Users/pasi/ma-git
-- same c++ code works as starndalone app and OSX x64 dynamiclib

local fsevent = {}

local ffi = require "mffi"
local util = require "util"

ffi.cdef[[
typedef struct _LuaCbArg // callback structure for Lua
{
  unsigned long long evId;
  const char* path;
  uint32_t modified;
  uint32_t deleted;
  uint32_t renamed;
  uint32_t created;
  uint32_t isFile;
  uint32_t isDir;
} LuaCbArg;

uint32_t listenChange(void* luaCallback, double latency, uint32_t argc, char **argv);
]]

local lib = util.loadDll("fsevent")

function fsevent.listenChange(callbackFunction, latency, pathsToListen)
	if type(callbackFunction) ~= "function" then
		util.printError("param 1 callbackFunction must be a Lua function")
		return 2
	end
	local callbackFunctionPointer = ffi.cast("uint32_t (*)(size_t, LuaCbArg *)", callbackFunction)
	local argc = #pathsToListen
	local argv = ffi.new("char *[?]", argc)
	for i = 1, argc do
		argv[i - 1] = ffi.cast("char *", pathsToListen[i])
	end
	return lib.listenChange(callbackFunctionPointer, latency, argc, argv)
end

return fsevent
