--- fsevent_win.lua
-- listen file system events
-- https://stackoverflow.com/questions/47667402/can-i-watch-multiple-directories-for-changes-using-readdirectorychangesw-in-c

local fsevent = {}

local ffi = require "mffi"
local C = ffi.C
local bit = require "bit"
local util = require "util"

ffi.cdef[[
typedef struct _LuaCbArg // callback structure for Lua
{
  unsigned long long evId;
  const char* path;
  uint32_t modified;
  uint32_t deleted;
  uint32_t renamed;
  uint32_t created;
  uint32_t isFile;
  uint32_t isDir;
} LuaCbArg;

uint32_t listenChange(void* luaCallback, double latency, uint32_t argc, char **argv);
]]

-- local lib = util.loadDll("ReadDirectoryChanges.dll")
-- local lib = util.loadDll("api-ms-win-crt-runtime-l1-1-0.dll")
-- lib = util.loadDll("vcruntime140.dll")
-- lib = util.loadDll("fsevent_win.dll")
local ret = util.loadDll("graphics/libwinpthread-1.dll")
if ffi.arch == "x64" then
	ret = util.loadDll("graphics/libgcc_s_seh-1.dll")
else
	ret = util.loadDll("graphics/libgcc_s_sjlj-1.dll")
end
ret = util.loadDll("graphics/libstdc++-6.dll")
local lib = util.loadDll("fsevent_win.dll")

function fsevent.listenChange(callbackFunction, latency, pathsToListen)
	if type(callbackFunction) ~= "function" then
		util.printError("param 1 callbackFunction must be a Lua function")
		return 2
	end
	local callbackFunctionPointer = ffi.cast("uint32_t (*)(size_t, LuaCbArg *)", callbackFunction)
	local argc = #pathsToListen
	local argv = ffi.new("char*[?]", argc)
	for i = 1, argc do
		argv[i - 1] = pathsToListen[i]
	end
	local ret = lib.listenChange(callbackFunctionPointer, latency, argc, argv)
	return ret
end

return fsevent

--[=[

ffi.cdef[[
// see ~/ma-git/other/c/winnt.h h
static const int GENERIC_READ  = 0x80000000;
static const int GENERIC_WRITE = 0x40000000;
static const int FILE_SHARE_READ = 0x00000001;
static const int FILE_SHARE_DELETE = 0x00000004;
static const int FILE_SHARE_WRITE = 0x00000002;
static const int FILE_FLAG_NO_BUFFERING = 0x20000000;
static const int OPEN_ALWAYS = 4;

static const int FILE_NOTIFY_CHANGE_FILE_NAME = 0x00000001;
static const int FILE_NOTIFY_CHANGE_DIR_NAME = 0x00000002;
static const int FILE_NOTIFY_CHANGE_CREATION = 0x00000040;
static const int FILE_NOTIFY_CHANGE_LAST_WRITE = 0x00000010;
static const int FILE_NOTIFY_CHANGE_SIZE = 8;

typedef struct _FILE_NOTIFY_INFORMATION {
	DWORD NextEntryOffset;
	DWORD Action;
	DWORD FileNameLength;
	WCHAR FileName[1];
} FILE_NOTIFY_INFORMATION,*PFILE_NOTIFY_INFORMATION;

HANDLE CreateFileA(
  LPCTSTR               lpFileName,
  DWORD                 dwDesiredAccess,
  DWORD                 dwShareMode,
  LPSECURITY_ATTRIBUTES lpSecurityAttributes,
  DWORD                 dwCreationDisposition,
  DWORD                 dwFlagsAndAttributes,
  HANDLE                hTemplateFile
);

BOOL ReadDirectoryChangesW(
  HANDLE                          hDirectory,
  LPVOID                          lpBuffer,
  DWORD                           nBufferLength,
  BOOL                            bWatchSubtree,
  DWORD                           dwNotifyFilter,
  LPDWORD                         lpBytesReturned,
  LPOVERLAPPED                    lpOverlapped,
  void* lpCompletionRoutine // LPOVERLAPPED_COMPLETION_ROUTINE
);

]]

local function listenChangeX(callbackFunctionPointer, latency, argc, argv)
	--
	argv[0] = "D:\\" -- "\\\\?\\c:"
	-- hDir[i] = CreateFileA(DirName, FILE_LIST_DIRECTORY, FILE_SHARE_READ | FILE_SHARE_DELETE, NULL, OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, NULL);
	local hDir = C.CreateFileA(argv[0], C.GENERIC_READ, bit.bor(C.FILE_SHARE_READ), nil, C.OPEN_ALWAYS, C.FILE_FLAG_NO_BUFFERING, nil) -- C.FILE_SHARE_DELETE, C.FILE_SHARE_READ, C.FILE_SHARE_WRITE
	print(hDir)
	if ffi.invalidWinHandle(hDir) then
		local errNum = C.GetLastError() -- GetLastWin32Error();
		local err = util.winErrorText(errNum)
		return err
	end
	local buffer = ffi.new("FILE_NOTIFY_INFORMATION[1024]")
  local bytesReturned = ffi.new("DWORD[1]")
	local ret
	repeat
		ret = C.ReadDirectoryChangesW(hDir, buffer[0], ffi.sizeof(buffer), true, bit.bor(C.FILE_NOTIFY_CHANGE_LAST_WRITE, C.FILE_NOTIFY_CHANGE_SIZE), bytesReturned, nil, nil)
	until ret ~= 0
	return 0
end
]=]