--- hash.lua
-- hashing functions
-- @module util
local hash = {}
local util = require "util"
local json = require "json"
local peg = require "peg"
local xxhash = require "xxhash"

function hash.setHash(prefTxt, fileName, option, hashTbl)
	local prefTbl, err = json.fromJson(prefTxt, fileName)
	if prefTbl then
		local hashVal
		if hashTbl ~= nil or option and peg.find(option, "hashVal") > 0 then
			-- calculate hash value from source text to table.hash
			if type(prefTxt) == "string" then
				hashVal = xxhash.hash128string(prefTxt)
			else
				-- util.printWarning("set hash parameter type '%s' is not string, file name '%s'", type(prefTxt), tostring(fileName))
				hashVal = xxhash.hash128string(json.toJsonKeySorted(prefTxt))
			end
		end
		if hashVal then
			if hashTbl then
				hashTbl[#hashTbl + 1] = hashVal
			else
				prefTbl.hash = hashVal -- set hash-key
			end
		end
	end
	return prefTbl, err
end

return hash
