--- http.lua
-- http utility functions
--

local http = {}
-- local peg = require "peg"

--[[
function http.getHeader(header, headerName)
	local pos = peg.find(header, "\r\n"..headerName..": ")
	if pos < 1 then
		return nil
	end
	pos = pos + #headerName + 4 -- 4 == "\r\n" and ": "
	local posEnd = peg.find(header:sub(pos), "\r\n")
	if posEnd < 1 then
		return nil
	end
	return header:sub(pos, pos + posEnd - 2) -- -2 = "\r\n"
end
]]

function http.getHeader(header, headerName)
	if header == nil or headerName == nil then
		return nil
	end
	local pos = header:find("\r\n"..headerName..": ", 1, true)
	if pos == nil then
		return nil
	end
	pos = pos + #headerName + 4 -- 4 == "\r\n" and ": "
	local posEnd = header:find("\r\n", pos, true)
	if posEnd == nil then
		return nil
	end
	return header:sub(pos, posEnd - 1)
end


function http.headerValueFound(header, headerName, value)
	local hdr = http.getHeader(header, headerName)
	if hdr == nil then
		hdr = http.getHeader(header, headerName:lower())
	end
	if hdr == value then
		return true
	end
	local pos = hdr:find(", ", 1, true)
	if not pos then
		pos = hdr:find("; ", 1, true)
	end
	while pos do
		if hdr:sub(1, pos - 1) == value then
			return true
		end
		hdr = hdr:sub(pos + 2)
		if hdr == value then
			return true
		end
		pos = hdr:find(", ", 1, true)
		if not pos then
			pos = hdr:find("; ", 1, true)
		end
	end
	return false
end

return http
