-- lib/import.lua
-- see: https://scilua.org/xsys.html
-- copied from: https://github.com/stepelu/lua-xsys
local import = {}
local peg = require "peg"

local function trim(s)
	return (s:gsub("^%s*(.-)%s*$", "%1"))
end

local function testexec(ok, ...)
	if not ok then
		local err = select(1, ...)
		error("execution error: " .. err)
	end
	return ...
end

local function exec(chunk, chunkname, fenv)
	chunkname = chunkname or chunk
	local f, err = loadstring(chunk, chunkname)
	if not f then
		error("parsing error: " .. err)
	end
	if fenv then
		setfenv(f, fenv)
	end
	return testexec(pcall(f))
end
import.exec = exec

-- local exp, log, sqrt, cos, sin, min, max, sqrt = import.from(math, "exp, log, sqrt, cos, sin, min, max, sqrt")
function import.from(what, keystr)
	local keys = peg.splitToArray(keystr, ",")
	local o = {}
	for i = 1, #keys do
		o[i] = "x." .. trim(keys[i])
	end
	o = table.concat(o, ",")
	local s = "return function(x) return " .. o .. " end"
	return exec(s, "from<" .. keystr .. ">")(what)
end

return import
