-- used by the pure-ffi, returns a
-- reference to the sodium library
local ffi = require 'ffi'
local string_format = string.format
local lib

local function lib_loader(signatures)
	if lib == nil then
		ffi.cdef([[
			int sodium_init(void);
		]])
		local function test_cspace()
			if ffi.C.sodium_init then
				return ffi.C
			end
			return false
		end

		do
			local ok = pcall(test_cspace)
			if ok then
				lib = ffi.C
			else
				-- lib = ffi.load('sodium')
				local util = require "util"
				lib = util.loadDll("sodium")
			end
		end
	end

	for f, sig in pairs(signatures) do
		ffi.cdef(string_format(sig, f))
	end

	return lib
end

return lib_loader
