--MurmurHash3_x86_32 from http://code.google.com/p/smhasher/source/browse/trunk/MurmurHash3.cpp

local ffi = require "mffi"
local bit = require "bit"
local util = require "util"
local lhash

ffi.cdef[[
	void MurmurHash3_x86_32( const void * key, const int len,
														const uint32_t seed, void * out );

	void MurmurHash3_x86_128( const void * key, const int len,
														 const uint32_t seed, void * out );

	void MurmurHash3_x64_128( const void * key, const int len,
														const uint32_t seed, void * out );
]]


local C1 = 0xcc9e2d51
local C2 = 0x1b873593
local rotl, xor, band, shl, shr = bit.rol, bit.bxor, bit.band, bit.lshift, bit.rshift

local function mmul(x1, x2) --multiplication with modulo2 semantics
  return tonumber(ffi.cast('uint32_t', ffi.cast('uint32_t', x1) * ffi.cast('uint32_t', x2)))
end


local out1 = ffi.newAnchor("uint32_t[1]")
local out4 = ffi.newAnchor("uint32_t[4]")

local function hash32_x86(data, len, seed)
	if not lhash then
		lhash = util.loadDll("hash")
	end
  seed = seed or 0
  if type(data) == 'string' then
    data, len = ffi.cast('const uint8_t*', data), math.min(len or #data, #data)
  end
	lhash.MurmurHash3_x86_32(data, len, seed, out1)
	return string.format("%x", out1[0])
	-- use: util.bufferToHex(buffer, bufLen, separator)
end

local function hash128_x86(data, len, seed)
	if not lhash then
		lhash = util.loadDll("hash")
	end
  seed = seed or 0
  if type(data) == 'string' then
    data, len = ffi.cast('const uint8_t*', data), math.min(len or #data, #data)
  end
	lhash.MurmurHash3_x86_128(data, len, seed, out4)
	return string.format("%x-%x-%x-%x", out4[0], out4[1], out4[2], out4[3])
	-- use: util.bufferToHex(buffer, bufLen, separator)
end

local function hash128_x64(data, len, seed)
	if not lhash then
		lhash = util.loadDll("hash")
	end
	len = len or #data
  if type(data) == "string" then
    data = ffi.cast('const uint8_t*', data)
  end
  seed = seed or 0
	--[[
	local out = ffi.newNoAnchor("uint64_t[2]")
	lhash.MurmurHash3_x64_128(data, len, seed, out)
	local out0 = tonumber(bit.rshift(out[0], 32))
	local out1 = tonumber(bit.band(out[0], 0xffffffff))
	local out2 = tonumber(bit.rshift(out[1], 32))
	local out3 = tonumber(bit.band(out[1], 0xffffffff))
	]]
	lhash.MurmurHash3_x64_128(data, len, seed, out4)
	return string.format("%x-%x-%x-%x", out4[0], out4[1], out4[2], out4[3])
	-- use: util.bufferToHex(buffer, bufLen, separator)
end

--[[
local hash128
if ffi.arch == "x86" then
	hash128 = hash128_x86
elseif ffi.arch == "x64" then
	hash128 = hash128_x64
end
]]

local function hash32(data, len, seed)
  seed = seed or 0
  if type(data) == 'string' then
    data, len = ffi.cast('const uint8_t*', data), math.min(len or #data, #data)
  end

  local nblocks = math.floor(len / 4)
  local h1 = seed

  local blocks = ffi.cast('uint32_t*', data)
  for i=0,nblocks-1 do
    h1 = mmul(rotl(xor(h1, mmul(rotl(mmul(blocks[i], C1), 15), C2)), 13), 5) + 0xe6546b64
  end

  local tail = data + (nblocks * 4)
  local k1 = 0
  local sw = band(len, 3)
  if sw == 3 then k1 = xor(k1, shl(tail[2], 16)) end
  if sw >= 2 then k1 = xor(k1, shl(tail[1],  8)) end
  if sw >= 1 then k1 = xor(k1, tail[0]) end

  h1 = xor(xor(h1, mmul(rotl(mmul(k1, C1), 15), C2)), len)
  h1 = mmul(xor(h1, shr(h1, 16)), 0x85ebca6b)
  h1 = mmul(xor(h1, shr(h1, 13)), 0xc2b2ae35)
  h1 = xor(h1, shr(h1, 16))

  return util.numToHex(h1)
end

if false and not ... then
	ffi.cdef[[
		int printf (__const char *__restrict __format, ...);
	]]

	local C = ffi.C
	local h1 = 0xffaabbff
	local h2 = 0xccdd3344
	local hout = ffi.newNoAnchor("uint32_t", h1)
	local hout2 = ffi.newNoAnchor("uint32_t", h2)
	-- local hout3 = ffi.newNoAnchor("uint64_t", 0xffaabbffccdd3344LL)
	local hout3 = ffi.newNoAnchor("uint64_t", 0xffaabbffccdd3344) -- fix for basic lua + ffi
	local out = hout
	local out2 = hout2
	local out3 = bit.rshift(hout3, 32)
	local out4 = bit.band(hout3, 0xffffffff)
	-- local out4 = bit.lshift(hout3, 32)
	-- out4 = bit.rshift(out4, 32)

	-- C.printf("printf: %f\n", 123)
	C.printf("hout: %x\n", hout)
	C.printf("hout2: %x\n", hout2)
	C.printf("hout3: %lx\n", hout3)
	print(string.format("%x-%x", tonumber(out3), tonumber(out4)))
	-- use: util.bufferToHex(buffer, bufLen, separator)

	print(util.numToHex(h1))
	print(util.numToHex(out))
	print(util.numToHex(out3))
	print(util.numToHex(h2))
	print(util.numToHex(out2))
	print(util.numToHex(out4))
end

return {
	hash32 = hash32_x86,
	hash128 = hash128_x64, -- ffi.arch == "x64" and hash128_x64 or hash128_x86, -- hash128_x64 and hash128_x86 give different results

	hash32lua = hash32,

	hash32_x86 = hash32_x86,
	hash128_x86 = hash128_x86,
	hash128_x64 = hash128_x64,
}
