--- lib/net/fd-send-win.lua
local fdSend = {}

local util = require "util"
local ffi = require "ffi"
local C = ffi.C
local socket, socketSend, socketReceive, socketAccept
local listenSocket
local portTcp = 5969

local k32 = ffi.load("kernel32")

local serverName = "/tmp/.nc-fd-server"
fdSend.serverName = serverName
function fdSend.setupFdServer()
	socket = require "system/socket"
	listenSocket = socket.listen("0.0.0.0", portTcp, "tcp")
	if listenSocket then
		util.printOk("fd-server waiting on: 0.0.0.0:%d", portTcp)
	else
		util.printRed("fd-server listen failed on: 0.0.0.0:%d", portTcp)
		return -1
	end
	return listenSocket
end

function fdSend.acceptFd(sockFd) -- , printFd)
	-- local clientUnixAddrPtr, structLen
	local cSockFd = sockFd:accept() --  clientUnixAddrPtr, structLen)
	if cSockFd == nil then
		util.printError("accept failed")
		socket.close(sockFd)
	end
	return cSockFd
end

function fdSend.connectToUnixServer(name)
	name = name or serverName
	local server_unix_addr_s = ffi.newAnchor("struct sockaddr_un[1]")
	local server_unix_addr_ptr = ffi.cast("struct sockaddr *", server_unix_addr_s)
	local server_unix_addr = server_unix_addr_s[0]
	local sockFd = C.socket(C.AF_UNIX, C.SOCK_STREAM, 0)
	if sockFd < 0 then
		util.printError("socket")
		return sockFd
	end
	server_unix_addr.sun_family = C.AF_UNIX
	ffi.copy(server_unix_addr.sun_path, name)
	local len = ffi.sizeof("sa_family_t")
	len = len + #name + 1
	if C.connect(sockFd, server_unix_addr_ptr, len) < 0 then
		C.close(sockFd)
		return -1
	end
	return sockFd
end

function fdSend.close(sock)
	if type(sock) == "number" then
		C.close(sock)
	elseif sock.socket then
		sock:close()
	end
end

function fdSend.processId()
	return k32.GetCurrentProcessId()
end

local PROCESS_ALL_ACCESS = 0x001F0FFF
local duplicateHandleOpts = 3 -- C.DUPLICATE_CLOSE_SOURCE	| C.DUPLICATE_SAME_ACCESS
local function convertProcessSocket(oldSocket, sourceProcessId)
	local sourceHandle = C.OpenProcess(PROCESS_ALL_ACCESS, false, sourceProcessId)
	local newHandle = ffi.new("HANDLE[1]")
	local newHandle = C.DuplicateHandle(sourceHandle, ffi.cast("HANDLE", oldSocket), k32.GetCurrentProcess(), newHandle, 0, false, duplicateHandleOpts)
	C.CloseHandle(sourceHandle)
	return ffi.cast("SOCKET", newHandle[0])
end

function fdSend.sendFd(cSockFd, fd, printNum)
	if type(cSockFd) == "table" then
		cSockFd = cSockFd.socket
	end
	if cSockFd:send(fd) < 0 then
		util.printWarning("%d. failed to send file descriptor (fd = %d)", printNum or 0, fd)
	elseif printNum then
		util.print("%d. file descriptor sent (fd = %d)", printNum, fd)
	end
end

local receiveFd = ffi.newAnchor("int[1]")
local dataLen = 10
function fdSend.receiveFd(cSockFd, print)
	local ret, err, retLen = cSockFd:receive(dataLen) -- true == raw data
	if retLen > 0 then
		receiveFd[0] = tonumber(ret)
	end
	if retLen <= 0 then
		util.printWarning("%d. failed to receive file descriptor (receiveFd = %d)", print or 0, receiveFd[0])
		receiveFd[0] = -1
	elseif print then
		util.print("%d. file descriptor received (receiveFd = %d)", print, receiveFd[0])
	end
	local fdRead = socket.new({socket = cSockFd, ai_family = C.AF_INET, ai_socktype = C.SOCK_STREAM, ai_protocol = 0})
	return fdRead.socket
end

return fdSend
