--- lib/net/fd-send.lua
local fdSend = {}

local util = require "util"
if util.from4d() then
	return fdSend
end
if util.isWin() then
	return require "net/fd-send-win"
end

local ffi = require "mffi"
local C = ffi.C
local lib = util.loadDll("fd-send")
-- local lib = util.loadDll("ancillary")
ffi.cdef [[
// int ancil_recv_fd(int, int *);
// int ancil_send_fd(int, int);
int receive_fd_using_sockfd(int *fd, int sockfd);
int send_fd_using_sockfd(int fd, int sockfd);
]]

local serverName = "/tmp/.nc-fd-server"
fdSend.serverName = serverName

function fdSend.setupFdServer()
	local server_unix_addr_s = ffi.newAnchor("struct sockaddr_un[1]")
	local server_unix_addr_ptr = ffi.cast("struct sockaddr *", server_unix_addr_s)
	local server_unix_addr = server_unix_addr_s[0]
	local sockfd = C.socket(C.AF_UNIX, C.SOCK_STREAM, 0)
	if sockfd < 0 then
		util.printError("socket")
		return sockfd
	end
	C.unlink(serverName)
	-- C.bzero(ffi.cast("char *", server_unix_addr)ffi.sizeof("sockaddr_un")) -- ffi.newAnchor() sets all to zero
	server_unix_addr.sun_family = C.AF_UNIX
	ffi.copy(server_unix_addr.sun_path, serverName) -- C.strcpy(server_unix_addr.sun_path, serverName)
	local len = ffi.sizeof("sa_family_t") -- ffi.sizeof(server_unix_addr.sun_family)
	len = len + #serverName + 1
	if C.bind(sockfd, server_unix_addr_ptr, len) < 0 then
		C.close(sockfd)
		return -1
	end
	-- local client_unix_addr_s = ffi.newAnchor("struct sockaddr_un[1]")
	-- local client_unix_addr_ptr = ffi.cast("struct sockaddr *", client_unix_addr_s)
	-- local structLen = ffi.newAnchor("unsigned int[1]")
	-- structLen[0] = ffi.sizeof("struct sockaddr_un")
	local backlog = 0
	local ret = C.listen(sockfd, backlog)
	if ret < 0 then
		util.print("fd-send C.listen() failed with error: " .. ret)
		return nil
	else
		util.printOk("fd-server waiting on: '%s'", serverName)
	end
	return sockfd -- , client_unix_addr_ptr, structLen
end

function fdSend.processId()
	return tonumber(C.getpid())
end

function fdSend.close(fd)
	return C.close(fd)
end

function fdSend.acceptFd(sockfd, printFd)
	-- local clientUnixAddrPtr, structLen
	local csockfd
	csockfd = C.accept(sockfd, nil, nil) --  clientUnixAddrPtr, structLen)
	if csockfd < 0 then
		util.printError("accept failed")
		C.close(sockfd)
		return nil
	end
	return csockfd
end

function fdSend.connectToUnixServer(name, sockfd)
	name = name or serverName
	local server_unix_addr_s = ffi.newAnchor("struct sockaddr_un[1]")
	local server_unix_addr_ptr = ffi.cast("struct sockaddr *", server_unix_addr_s)
	local server_unix_addr = server_unix_addr_s[0]
	sockfd = sockfd or C.socket(C.AF_UNIX, C.SOCK_STREAM, 0)
	if sockfd < 0 then
		util.printError("unix domain socket creation failed")
		return sockfd
	end
	server_unix_addr.sun_family = C.AF_UNIX
	ffi.copy(server_unix_addr.sun_path, name)
	local len = ffi.sizeof("sa_family_t")
	len = len + #name + 1
	if C.connect(sockfd, server_unix_addr_ptr, len) < 0 then
		C.close(sockfd)
		return -1
	end
	return sockfd
end

function fdSend.sendFd(csockfd, fd, printNum)
	if type(csockfd) == "table" then
		csockfd = csockfd.socket
	end
	if lib.send_fd_using_sockfd(fd, csockfd) < 0 then
		-- if lib.ancil_send_fd(csockfd, fd) < 0 then
		util.printWarning("%d. failed to send file descriptor (fd = %d)", printNum or 0, fd)
	elseif printNum then
		util.print("%d. file descriptor sent (fd = %d)", printNum, fd)
	end
end

local receiveFd = ffi.newAnchor("int[1]")
function fdSend.receiveFd(csockfd, print)
	if type(csockfd) == "table" then
		csockfd = csockfd.socket
	end
	if lib.receive_fd_using_sockfd(receiveFd, csockfd) < 0 then
		-- if lib.ancil_recv_fd(csockfd, receiveFd) < 0 then
		util.printWarning("%d. failed to receive file descriptor (receiveFd = %d)", print or 0, receiveFd[0])
		receiveFd[0] = -1
	elseif print then
		util.print("%d. file descriptor received (receiveFd = %d)", print, receiveFd[0])
	end
	return receiveFd[0];
end

return fdSend
