--- lib/net/http3-lsquic-client.lua
-- https://lsquic.readthedocs.io/en/latest/tutorial.html
-- /Users/pasi/installed/C/tls/lsquic/examples/http3-client.c
--[[
cd ~/installed/C/tls/lsquic/build
./echo_server -c foo.localhost,/tmp/foo.localhost/cert.pem,/tmp/foo.localhost/key.pem -s 0.0.0.0:4433
./echo_client -H foo.localhost -s 127.0.0.1:4433
]]

package.path = "lib/?.lua;lib/?.lx;" .. package.path
package.path = "../lib/?.lua;../lib/?.lx;" .. package.path
package.path = "../../lib/?.lua;../../lib/?.lx;" .. package.path
require "start"

local ffi = require "mffi"
local C = ffi.C
local util = require "util"
local lsquic = require "net/lsquic"
local program = require "net/http3-lsquic-program"
lsquic = lsquic.lib

-- applicattion definitions
ffi.cdef[[
	struct lsquic_conn_ctx;

	struct echo_client_ctx {
			struct lsquic_conn_ctx  *conn_h;
			uint32_t *prog;
			// struct prog                 *prog;
	};

	struct lsquic_conn_ctx {
			lsquic_conn_t       *conn;
			struct echo_client_ctx   *client_ctx;
	};
]]

--[[
local recvBufLen = 65535
local recvBuf = C.malloc(recvBufLen)
local sendFlags = 0
local receiveFlags = 0
if util.isLinux() then
	sendFlags = C.MSG_NOSIGNAL
	receiveFlags = C.MSG_NOSIGNAL
end
local callTimeout = 0.8 --seconds
local sleepMillisec = 100
local loopCount = 0
local out = ffi.newAnchor("uint8_t[?]", MAX_DATAGRAM_SIZE)
]]

local function echo_client_on_new_conn(stream_if_ctx, conn)
	local client_ctx = ffi.cast("struct echo_client_ctx *", stream_if_ctx)
  local conn_h1 = C.malloc(ffi.sizeof("struct lsquic_conn_ctx"))
	local conn_h = ffi.cast("lsquic_conn_ctx_t*", conn_h1)
  conn_h.conn = conn
  conn_h.client_ctx = client_ctx
  client_ctx.conn_h = conn_h
  lsquic.lsquic_conn_make_stream(conn)
  util.printInfo("New connection")
  return conn_h
end

	--[[
local function echo_server_on_conn_closed(conn)
  local conn_h = lsquic.lsquic_conn_get_ctx(conn)
	if conn_h.server_ctx.n_conn > 0 then
		conn_h.server_ctx.n_conn = conn_h.server_ctx.n_conn - 1
		util.printInfo("Connection closed, remaining: %d", conn_h.server_ctx.n_conn)
		if conn_h.server_ctx.n_conn == 0 then
			program.prog_stop(conn_h.client_ctx.prog)
		end
	else
		util.printInfo("Connection closed")
		-- TAILQ_REMOVE(conn_h.server_ctx.conn_ctxs, conn_h, next_connh)
	end
  C.free(conn_h[0])
end
]]

local function echo_client_on_conn_closed(conn)
  local conn_h = lsquic.lsquic_conn_get_ctx(conn)
	util.printInfo("Connection closed")
  C.free(conn_h)
end

local function read_stdin(fd, what, ctx)
	local st_h = ffi.cast("lsquic_stream_ctx_t *", ctx)
	--[[
	local nr = Read(fd, st_h.buf + st_h.buf_off++, 1)
	util.printOk("read %zd bytes from stdin", nr) ]]
	local nr = io.read()
	if 0 == #nr then
		lsquic.lsquic.lsquic_stream_shutdown(st_h.stream, 2)
	elseif '\n' == nr:sub(-1) then
		util.printOk("read newline: wantwrite")
		lsquic.lsquic.lsquic_stream_wantwrite(st_h.stream, 1)
		lsquic.lsquic_engine_process_conns(st_h.client_ctx.prog.prog_engine)
	-- elseif st_h.buf_off == sizeof(st_h.buf) then
		-- util.printInfo("line too long")
	else
		program.event_add(st_h.read_stdin_ev, nil)
	end
end


local function echo_client_on_new_stream(stream_if_ctx, stream)
	--[[ lsquic_stream_ctx_t *st_h = calloc(1, sizeof(*st_h))
	st_h.stream = stream
	st_h.client_ctx = stream_if_ctx
	st_h.buf_off = 0
	st_h.read_stdin_ev = -- event_new(program.prog_eb(st_h.client_ctx.prog), C.STDIN_FILENO, C.EV_READ, read_stdin, st_h)
	program.event_add(st_h.read_stdin_ev, nil)
	]]
	return st_h
end


local function echo_client_on_read(stream, st_h)
	local c = ffi.newAnchor("char[1]")
	local nr = lsquic.lsquic_stream_read(stream, c, 1)
	if 0 == nr then
		lsquic.lsquic_stream_shutdown(stream, 2)
		return
	end
	util.print("%c", c[0])
	if '\n' == c[0] then
			program.event_add(st_h.read_stdin_ev, nil)
			lsquic.lsquic_stream_wantread(stream, 0)
	end
end


local function echo_client_on_write(stream, st_h)
	--[[ Here we make an assumption that we can write the whole buffer.
		* Don't do it in a real program.
		--]]
	lsquic.lsquic_stream_write(stream, st_h.buf, st_h.buf_off)
	st_h.buf_off = 0
	lsquic.lsquic_stream_flush(stream)
	lsquic.lsquic_stream_wantwrite(stream, 0)
	lsquic.lsquic_stream_wantread(stream, 1)
end


local function echo_client_on_close(stream, st_h)
	util.printInfo("%s called", "echo_client_on_close")
	if st_h.read_stdin_ev then
		-- event_del(st_h.read_stdin_ev)
		-- event_free(st_h.read_stdin_ev)
	end
	C.free(st_h)
	lsquic.lsquic_conn_close(lsquic.lsquic_stream_conn(stream))
end

local function main(arg)
  local sports = {} -- service ports
  local prog = program.proc_new()
  local client_ctx = ffi.newAnchor("struct echo_client_ctx")
  client_ctx.prog = prog.id

	local client_echo_stream_if = ffi.newAnchor("const struct lsquic_stream_if", {
		on_new_conn      = ffi.cast("lsquic_conn_ctx_t* (*)(void *stream_if_ctx, lsquic_conn_t *c)", echo_client_on_new_conn),
		on_conn_closed     = ffi.cast("void (*)(lsquic_conn_t *c)", echo_client_on_conn_closed),
		on_new_stream      = ffi.cast("lsquic_stream_ctx_t* (*)(void *stream_if_ctx, lsquic_stream_t *s)", echo_client_on_new_stream),
		on_read        = ffi.cast("void (*)(lsquic_stream_t *s, lsquic_stream_ctx_t *h)", echo_client_on_read),
		on_write         = ffi.cast("void (*)(lsquic_stream_t *s, lsquic_stream_ctx_t *h)", echo_client_on_write),
		on_close         = ffi.cast("void (*)(lsquic_stream_t *s, lsquic_stream_ctx_t *h)", echo_client_on_close),
	})

  -- TAILQ_INIT(sports)
  program.prog_init(prog, 0, sports, client_echo_stream_if, client_ctx)
	if 0 ~= program.prog_set_opt(prog, arg) then
		return
	end
--[[ #ifndef WIN32
  int flags = fcntl(STDIN_FILENO, F_GETFL)
  flags |= O_NONBLOCK
  if 0 ~= fcntl(STDIN_FILENO, F_SETFL, flags) then
    perror("fcntl")
    exit(1)
  end
#else then
    u_long on = 1
    ioctlsocket(STDIN_FILENO, FIONBIO, &on)
  end
#endif ]]
  if 0 ~= program.prog_prep(prog) then
    util.printError("could not preparate program")
    return -1
  end
  if 0 ~= program.prog_connect(prog, nil, 0) then
    util.printError("could not connect")
    return -1
  end
  util.printOk("entering event loop")
  local s = program.prog_run(prog)
  program.prog_cleanup(prog)
  return s
end


util.printInfo("* lsquic start")
main({...})
