-- lib/net/lsquic-echo-client.lua

--[=[ -- commented because of syntax errors
local function echo_client_on_new_conn (void *stream_if_ctx, lsquic_conn_t *conn)
  struct echo_client_ctx *client_ctx = stream_if_ctx
  lsquic_conn_ctx_t *conn_h = malloc(sizeof(*conn_h))
  conn_h.conn = conn
  conn_h.client_ctx = client_ctx
  client_ctx.conn_h = conn_h
  lsquic_conn_make_stream(conn)
  return conn_h
end

local function echo_client_on_conn_closed (lsquic_conn_t *conn)
  lsquic_conn_ctx_t *conn_h = lsquic_conn_get_ctx(conn)
  util.printInfo("Connection closed")
  prog_stop(conn_h.client_ctx.prog)
  free(conn_h)
end

local function read_stdin (evutil_socket_t fd, short what, void *ctx)
	ssize_t nr
	lsquic_stream_ctx_t *st_h = ctx

	nr = Read(fd, st_h.buf + st_h.buf_off++, 1)
	util.printOk("read %zd bytes from stdin", nr)
	if 0 == nr then
			lsquic_stream_shutdown(st_h.stream, 2)
	elseif -1 == nr then
			perror("read")
			exit(1)
	elseif '\n' == st_h.buf[ st_h.buf_off - 1 ] then
			util.printOk("read newline: wantwrite")
			lsquic_stream_wantwrite(st_h.stream, 1)
			lsquic_engine_process_conns(st_h.client_ctx.prog.prog_engine)
	elseif st_h.buf_off == sizeof(st_h.buf) then
			util.printInfo("line too long")
			exit(2)
	else
			event_add(st_h.read_stdin_ev, nil)
	end
end


local function echo_client_on_new_stream (void *stream_if_ctx, lsquic_stream_t *stream)
	lsquic_stream_ctx_t *st_h = calloc(1, sizeof(*st_h))
	st_h.stream = stream
	st_h.client_ctx = stream_if_ctx
	st_h.buf_off = 0
	st_h.read_stdin_ev = event_new(prog_eb(st_h.client_ctx.prog),
																	STDIN_FILENO, EV_READ, read_stdin, st_h)
	event_add(st_h.read_stdin_ev, nil)
	return st_h
end


local function echo_client_on_read (lsquic_stream_t *stream, lsquic_stream_ctx_t *st_h)
	char c
	size_t nr

	nr = lsquic_stream_read(stream, &c, 1)
	if 0 == nr then
			lsquic_stream_shutdown(stream, 2)
			return
	end
	printf("%c", c)
	fflush(stdout)
	if '\n' == c then
			event_add(st_h.read_stdin_ev, nil)
			lsquic_stream_wantread(stream, 0)
	end
end


local function echo_client_on_write (lsquic_stream_t *stream, lsquic_stream_ctx_t *st_h)
	--[[ Here we make an assumption that we can write the whole buffer.
		* Don't do it in a real program.
		--]]
	lsquic_stream_write(stream, st_h.buf, st_h.buf_off)
	st_h.buf_off = 0

	lsquic_stream_flush(stream)
	lsquic_stream_wantwrite(stream, 0)
	lsquic_stream_wantread(stream, 1)
end


local function echo_client_on_close (lsquic_stream_t *stream, lsquic_stream_ctx_t *st_h)
	util.printInfo("%s called", __func__)
	if st_h.read_stdin_ev then
		event_del(st_h.read_stdin_ev)
		event_free(st_h.read_stdin_ev)
	end
	free(st_h)
	lsquic_conn_close(lsquic_stream_conn(stream))
end


const struct lsquic_stream_if client_echo_stream_if = {
  .on_new_conn      = echo_client_on_new_conn,
  .on_conn_closed     = echo_client_on_conn_closed,
  .on_new_stream      = echo_client_on_new_stream,
  .on_read        = echo_client_on_read,
  .on_write         = echo_client_on_write,
  .on_close         = echo_client_on_close,
}

local function main(arg)
  local opt, s
  local sports = ffi.newAnchor("struct sport_head[1]")
  local prog = ffi.newAnchor("struct prog[1]")
  local client_ctx = ffi.newAnchor("struct echo_client_ctx[1]")
  client_ctx.prog = prog

  -- TAILQ_INIT(sports)
  prog_init(prog, 0, sports, client_echo_stream_if, client_ctx)
	--[[ if 0 != prog_set_opt(prog, arg) then
		return
	end ]]
--[[ #ifndef WIN32
  int flags = fcntl(STDIN_FILENO, F_GETFL)
  flags |= O_NONBLOCK
  if 0 != fcntl(STDIN_FILENO, F_SETFL, flags) then
    perror("fcntl")
    exit(1)
  end
#else then
    u_long on = 1
    ioctlsocket(STDIN_FILENO, FIONBIO, &on)
  end
#endif ]]
  if 0 != prog_prep(prog) then
    util.printError("could not prep")
    exit(EXIT_FAILURE)
  end
  if 0 != prog_connect(prog, nil, 0) then
    util.printError("could not connect")
    exit(EXIT_FAILURE)
  end
  util.printOk("entering event loop")
  s = prog_run(prog)
  prog_cleanup(prog)
  return s
end
]=]