--- net/lsquic.lua
-- https://github.com/cloudflare/lsquic/blob/master/include/lsquic.h
-- @module net
local lsquic = {}

local ffi = require "mffi"
local util = require "util"
require "net/lsquic_h"

if util.isWin() then
	if ffi.arch == "x64" then
		util.loadDll("zlib.dll")
	else
		util.loadDll("graphics/libgcc_s_dw2-1.dll")
		util.loadDll("graphics/zlib1.dll")
	end
elseif util.isLinux() then
	util.loadDll("boringssl/crypto")
	util.loadDll("boringssl/ssl")
end
lsquic.lib = util.loadDll("lsquic")

return lsquic
