-- lib/start_pllua.lua

print([=[

-- example of creating and running pllua extension to postgre database like 'fi_demo'

DROP FUNCTION IF EXISTS hello;
DROP EXTENSION IF EXISTS pllua CASCADE;
DROP EXTENSION IF EXISTS plluau CASCADE;
CREATE EXTENSION pllua;
CREATE EXTENSION plluau;

DROP FUNCTION IF EXISTS hello;
CREATE FUNCTION hello(name text) RETURNS text AS $$
	local cpath = "/Users/pasi/nc/bin/bin_osx_x64/"
	package.cpath = cpath.."?.dylib;"..cpath.."?.so;"
	local path = "/Users/pasi/nc/nc-server/"
	package.path = path.."lib/?.lua;"..path.."lib/?.lx;"
	local start = require "start"
	start.setFilePath(path)
	local fs = require "fs"
	local ffi = require "ffi"
	return string.format("Hello, %s! path: %s, ffi: %s - jit: %s - path: %s", name, start.startPath, ffi.os.." "..ffi.arch, jit.version, fs.currentPath())
$$ LANGUAGE plluau;
SELECT hello('PostgreSQL');

=> Hello, PostgreSQL! path: /Users/pasi/Library/Application Support/Postgres/var-10, ffi: OSX x64 - jit: LuaJIT 2.1.0-beta3 - path: /Users/pasi/Library/Application Support/Postgres/var-10/
]=])