-- lib/podofo.lua

local ffi = require "mffi"
local util = require "util"

if util.isWin() then
	util.loadDll("graphics/libwinpthread-1.dll")
	if ffi.arch == "x64" then
		util.loadDll("graphics/libgcc_s_seh-1.dll") -- x64
		util.loadDll("graphics/libjpeg-62.dll")
	else
		util.loadDll("graphics/libgcc_s_sjlj-1.dll")
		util.loadDll("graphics/libgcc_s_dw2-1.dll")
	end
	util.loadDll("graphics/libstdc++-6.dll")
	util.loadDll("graphics/libiconv-2.dll") -- x64
	util.loadDll("graphics/libeay32.dll")
	util.loadDll("graphics/zlib1.dll")
	util.loadDll("graphics/liblzma-5.dll")
	util.loadDll("graphics/libjpeg-8.dll")
	util.loadDll("graphics/libpng16-16.dll")
	util.loadDll("graphics/libtiff-5.dll")
	util.loadDll("graphics/libfreetype-6.dll")

	util.loadDll("graphics/libintl-8.dll")
	util.loadDll("graphics/libidn-11.dll")

	util.loadDll("graphics/libpodofo.dll")
end
local podofo = util.loadDll("graphics/libpodofoencrypt")

ffi.cdef [[
	int pdfEncrypt(int argc, char* argv[]);
	int libIdn();
]]

return podofo
