--- result_cache.lua
--
-- @module result_cache
local dschema = require "dschema"
local dqry = require "dqry"
local dload = require "dload"
local dsave = require "dsave"
local dsql = require "dsql"
local util = require "util"
local json = require "json"
local dt = require "dt"

local function saveResultCacheRecord(savedRecName, tbl, addTimestamp, saveCount)

	local nameStart = savedRecName
	if addTimestamp == true then
		savedRecName = savedRecName .. "_" .. dt.currentString()
	end
	local rec = {
		rc = {
			name_id = savedRecName,
			json_data = json.toJsonRaw(tbl) -- json.escapeJson(json.toJsonRaw(tbl)),
		}
	}
	dqry.query("", "rc.name_id", "=", savedRecName)
	-- local oldRec = dload.selectionToRecordArray({"rc.name_id"})
	local _, err = dsave.saveToDatabase({rec}, {table = "result_cache", record_type = ""})
	if addTimestamp == true and type(saveCount) == "number" then
		if type(nameStart) == "string" and #nameStart > 0 then
			dqry.query("", "rc.name_id", "like", nameStart .. "%")
			-- do this: (json_data->>'internal_name')::text = nameStart
			-- do this: o not delete big total_time -records: AND (json_data->>'total_time')::float  < 45
			dqry.orderBy("rc.modify_time", "<") -- "rc.name_id"
			dsql.offset(saveCount - 1) -- this is the one we want to leave to database
			dsql.limit(1)
			local sel = dload.selectionToRecordArray({"rc.name_id", "rc.modify_time"})
			if sel and #sel == 1 then
				local time = dt.dateTimeParse(sel[1].modify_time)
				print("**************** nameStart: ", savedRecName, sel[1].modify_time, time, dt.toString(time))
				dqry.query("", "rc.name_id", "like", nameStart .. "%")
				dqry.query("and", "rc.modify_id", "<", time)
				dsave.deleteSelection("result_cache")
			end
		end
	end
	return err
end

local function loadResultCache(savedRecName, jsonTagName)
	local rec
	dqry.query("", "rc.name_id", "=", savedRecName)
	rec = dload.selectionToRecordArray({"rc.json_data"})
	if rec ~= nil and rec[1] and rec[1].json_data then
		rec = json.fromJson(rec[1].json_data)
	end
	if jsonTagName ~= nil then
		if rec == nil or rec[jsonTagName] == nil then
			rec = nil
		else
			rec = rec[jsonTagName]
		end
	end
	if rec == nil or type(rec) == "table" and util.tableIsEmpty(rec) then
		return nil
	end
	return rec
end

return {saveResultCacheRecord = saveResultCacheRecord, loadResultCache = loadResultCache}
