--- lib/scanner/scanner_osx.lua
package.path = "lib/?.lua;lib/?.lx;" .. package.path
package.path = "../lib/?.lua;../lib/?.lx;" .. package.path
require "start"

local scanner = {}

local tesseract = require "scanner/tesseract" -- run tesseract
local util = require "util"
local fs = require "fs"
local dt = require "dt"
local print = util.print

local function waitForNewFile(dir, filePrefix, prevStartTime, waitTimeout, waitSleep, sizeSleep)
	local newFile
	local loopCount = 0
	local maxLoopCount = math.floor(waitTimeout / waitSleep)
	repeat -- loop max 30 * 0.1 seconds = 3 seconds
		loopCount = loopCount + 1
		if fs.dirExists(dir) then -- first time directory may not have been created
			for fileName, attr in fs.dirTreeIter(dir, {depth = 0, suffix = filePrefix}) do
				local time = attr.modification
				if time and time >= prevStartTime then
					newFile = dir .. fileName
				end
				-- print(l(" - waitForFile loopCount %d, %s, %s, %s, %s", loopCount, tostring(time), tostring(prevStartTime), fileName, tostring(newFile)))
				if newFile then
					break
				end
			end
		end
		if newFile == nil then
			util.sleep(waitSleep * 1000) -- sleep 0.1 seconds
		end
	until newFile or loopCount > maxLoopCount

	local newSize
	if newFile then
		repeat -- wait until file does not grow any more
			local prevSize = fs.fileSize(newFile)
			util.sleep(sizeSleep * 1000)
			newSize = fs.fileSize(newFile)
			util.printInfo(" - waitForFile, prevSize / newSize: %s / %s", tostring(prevSize), tostring(newSize))
		until newSize == prevSize
	end
	return newFile
end

local function readFileList(path, filePrefix)
	local fileList = {}
	for fileName, attr in fs.dirTreeIter(path, {depth = 0, suffix = filePrefix}) do
		fileList[#fileList + 1] = fileName
	end
	return fileList
end

function scanner.scanOsaScript()
	local pictDirPath = "~/Pictures/"
	local filePrefix = {".jpg", ".jpeg"}

	local appleScript, ret, ret2
	local prevStartTime = os.time()
	local waitTimeout = 35
	local waitSleep = 1
	local sizeSleep = 0.1

	appleScript = [[
	osascript -e '
	tell application "Image Capture"
		activate
	end tell'
	]]
	ret, ret2 = os.execute(appleScript)
	print(ret, ret2)
	util.sleep(0.1 * 1000) -- wait scanner to warn up

	-- wait scanner to warn up and "Scan" -button to become enabled
	appleScript = [[
	osascript -e '
	set isactive to ""
	tell application "System Events"
		set input to properties of UI element "Scan" of group 2 of splitter group 1 of window "Image Capture" of application process "Image Capture"
		set isactive to get enabled of input
	end tell
	return isactive as string '
	]]
	ret2 = 0
	local sleepSecs = 0.2
	repeat
		ret2 = ret2 + 1
		local handle = io.popen(appleScript)
		ret = handle:read("*a")
		handle:close()
		ret = ret:sub(1, 4) -- \n at the end
		if ret ~= "true" then
			util.sleep(sleepSecs * 1000)
		end
	until ret == "true" or sleepSecs == 20
	-- ret, ret2 = os.execute(appleScript)
	print("Scan button is active:", ret, ret2)

	-- local oldFiles = readFileList(pictDirPath, filePrefix)
	-- util.sleep(8 * 1000)
	if ret == "true" then
		appleScript = [[
		osascript -e '
		tell application "System Events"
			click UI Element "Scan" of group 2 of splitter group 1 of window "Image Capture" of application process "Image Capture"
		end tell
		return "" '
		]]
		ret, ret2 = os.execute(appleScript)
		print(ret, ret2)
		local newFile = waitForNewFile(pictDirPath, filePrefix, prevStartTime, waitTimeout, waitSleep, sizeSleep)
		util.printInfo("newFile: '%s'", tostring(newFile))

		appleScript = [[
		osascript -e '
		tell application "System Events"
			click menu item "Quit Image Capture" of menu 1 of menu bar item "Image Capture" of menu bar 1 of application process "Image Capture"
		end tell
		return "" '
		]] -- keystroke "q" using command down
		util.sleep(2 * 1000)
		ret, ret2 = os.execute(appleScript)
		print(ret, ret2)
		if newFile then
			fs.openFile(newFile)
		end
	end
end

function scanner.scanScanline()
	local scannerName = "CanoScan LiDE 120"
	local scanPath = "nc-scan" -- = scannerName
	local fileName = "scan"
	local dir = fs.filePathFix("~/Documents/scanner/" .. scanPath .. "/" .. dt.currentYear() .. "/")
	fs.createPath(dir)
	local scannedFilePath = dir .. fileName .. ".jpg"
	if fs.fileExists(scannedFilePath) then
		fs.deleteFile(scannedFilePath)
	end
	-- -mono == black and white,  -a4
	local options = ' -resolution 600 -browsesecs 2 -flatbed -jpeg -a4 -dir "' .. dir .. '" -name "' .. fileName .. '"' -- jpeg or pdf
	local cmd = util.pathBin() .. "scanline" .. options
	print("* scanning: " .. cmd)
	local scanOk, ret2 = os.execute(cmd)
	print("* scanner.scanScanline() return:", scanOk, ret2)
	return scanOk, scannedFilePath
end

if not ... then
	local scanOk, scannedFilePath = scanner.scanScanline() -- true, "/Users/pasi/Documents/scanner/nc-scan/2019/scan.jpg" -- or scanner.scanOsaScript()
	if scanOk then
		if fs.fileExists(scannedFilePath) then
			-- fs.copyFile(scannedFilePath, util.mainPath().."test/lib/scanner/") -- or fs.move()
			tesseract.debug("barcode", scannedFilePath, "fin")
		end
	end
end

return scanner

--[[
on run {input, parameters}
	tell application "Image Capture"
		activate
	end tell
	-- Click the “Scan” button.
	delay 1
	set timeoutSeconds to 25.0
	set uiScript to "click UI Element \"Scan\" of group 2 of splitter group 1 of window \"Image Capture\" of application process \"Image Capture\""
	my doWithTimeout(uiScript, timeoutSeconds)
	set timeoutSeconds to 1.0
	set uiScript to "click menu item \"Quit Image Capture\" of menu 1 of menu bar item \"Image Capture\" of menu bar 1 of application process \"Image Capture\""
	my doWithTimeout(uiScript, timeoutSeconds)
	return input
end run

on doWithTimeout(uiScript, timeoutSeconds)
	set endDate to (current date) + timeoutSeconds
	repeat
		try
			run script "tell application \"System Events\"
" & uiScript & "
end tell"
			exit repeat
		on error errorMessage
			if ((current date) > endDate) then
				error "Can not " & uiScript
			end if
		end try
	end repeat
end doWithTimeout
]]
