--- lib/scanner/scanner_win.lua
package.path = "lib/?.lua;lib/?.lx;" .. package.path
package.path = "../lib/?.lua;../lib/?.lx;" .. package.path
require "start"

local ffi = require "mffi"
local C = ffi.C
local util = require "util"
local bit = require "bit"
local tesseract = require "scanner/tesseract" -- run tesseract
local vips = require "vips"
local twain = require"scanner/scanner_twain_h".dll

-- local version = twain.TWAIN_EasyVersion() / 100 -- Returns the version number of EZTWAIN.DLL, multiplied by 100. So e.g. version 2.01 will return 201 from this call.
-- print("EZTWAIN version: "..tostring(version))
local ret = twain.TWAIN_IsAvailable() -- 1 is avaiable
if ret == 0 then
	util.printWarning("TWAIN is not available")
	return
end
-- local fileName = "C:/prog/scan.bmp"
local fileName2 = util.mainPath() .. "test/lib/scanner/scan.jpg" -- fileName:sub(1, -5).."_vips.jpg"
-- local fh = C._open(fileName, C.OF_CREATE)
-- local scanOk = false
local scanOk = false
local hwnd = ffi.cast("void *", 0)
local state = 0
ret = 1 -- twain.TWAIN_SelectImageSource(hwnd)
if ret ~= 0 then
	state = twain.TWAIN_State()
	ret = twain.TWAIN_LoadSourceManager() -- state -> 2
	state = twain.TWAIN_State()
	ret = twain.TWAIN_OpenSourceManager(hwnd) -- state -> 3
	state = twain.TWAIN_State()
	ret = twain.TWAIN_OpenDefaultSource() -- state -> 4
	state = twain.TWAIN_State()
end
if state ~= 4 then
	util.printWarning("scanner is not available")
else
	-- ret = twain.TWAIN_GetCurrentResolution()
	local resolution = twain.TWAIN_GetYResolution() -- TWAIN_GetCurrentResolution()
	local bitDepth = twain.TWAIN_GetBitDepth()
	util.printInfo("default scanner resolution: %d, bit depth: %d", resolution, bitDepth)
	ret = twain.TWAIN_SetCurrentResolution(600) -- must be in state 4
	resolution = twain.TWAIN_GetYResolution() -- TWAIN_GetCurrentResolution()
	bitDepth = twain.TWAIN_GetBitDepth()
	util.printInfo("current scanner resolution: %d, bit depth: %d", resolution, bitDepth)
	-- ret = twain.TWAIN_GetYResolution()
	-- ret = twain.TWAIN_NegotiatePixelTypes(1)
	-- ret = twain.TWAIN_SetBitDepth(1)
	-- twain.TWAIN_SetHideUI(1)
	-- ret = twain.TWAIN_EnableSource(hwnd)
	-- state = twain.TWAIN_State()
	if not util.fromEditor() then
		twain.TWAIN_SetHideUI(1)
	end
	local hdib = twain.TWAIN_AcquireNative(hwnd, C.TWAIN_ANYTYPE) -- state -> 1
	if ffi.isNotNull(hdib) then
		scanOk = true
		state = twain.TWAIN_State()
		-- ret = twain.TWAIN_WriteNativeToFilename(hdib, fileName)
		-- local palette = twain.TWAIN_CreateDibPalette(hdib)
		-- local numColors = twain.TWAIN_DibNumColors(hdib) --  Number of colors in color table of DIB
		local depth = twain.TWAIN_DibDepth(hdib) --  Depth of DIB, in bits i.e. bits per pixel.
		local width = twain.TWAIN_DibWidth(hdib) -- Width of DIB, in pixels (columns)
		local height = twain.TWAIN_DibHeight(hdib) -- Height of DIB, in lines (rows)
		local rowBytes = twain.DIB_RowBytes(hdib) -- Number of bytes needed to store one row of the DIB.
		local byteDepth = depth / (ffi.sizeof("unsigned char") * 8)
		local byteCount = width * byteDepth
		util.printInfo("used scanner width: %d, height: %d, bit depth: %d, rowBytes: %d, twain state: %d", width, height, depth, rowBytes, state)
		local dst = ffi.newNoAnchor("unsigned char[?]", rowBytes)
		local data
		if byteDepth >= 1 then -- grayscale or color
			data = ffi.newNoAnchor("unsigned char[?]", height * byteCount) -- unsigned char[?] == BYTE[?]
			for y = 0, height - 1 do
				twain.DIB_ReadRow(hdib, y, dst) -- Read row n of the given DIB into buffer at dst
				for x = 0, width - 1 do
					for z = 0, byteDepth - 1 do
						data[(y * byteCount) + (x * byteDepth) + z] = dst[(x * byteDepth) + z]
					end
				end
			end
		else -- less than 8 bytes per pixel
			local pixelsPerByte = math.floor(8 / depth)
			byteDepth = 1 -- vips image can't have less than 1 pixel per byte
			if math.floor(byteCount) < byteCount then
				byteCount = math.floor(byteCount) + 1
			end
			data = ffi.newNoAnchor("unsigned char[?]", height * width)
			for y = 0, height - 1 do
				twain.DIB_ReadRow(hdib, y, dst) -- Read row n of the given DIB into buffer at dst
				for x = 0, byteCount - 1 do
					for z = 0, pixelsPerByte - 1 do
						--[[ -- long version
						if dst[x] > 0 and dst[x] < 255 then
							opt = bit.lshift(1, pixelsPerByte - z - 1)
							val = bit.band(dst[x], opt)
							val = val > 0 and 255 or 0
						else
							val = dst[x]
						end --]]
						if (x * pixelsPerByte) + z < width then
							data[(y * width) + (x * pixelsPerByte) + z] = bit.band(dst[x], bit.lshift(1, pixelsPerByte - z - 1)) > 0 and 255 or 0
						end
					end
				end
			end
		end
		twain.TWAIN_FreeNative(hdib)
		local image = vips.Image.new_from_memory(data, width, height, byteDepth, "uchar")
		image:write_to_file(fileName2)
		util.printInfo("wrote file: '%s'", fileName2)
		if not util.isWine() then
			util.openFile(fileName2)
		end
	end
end
ret = twain.TWAIN_DisableSource()
ret = twain.TWAIN_CloseSource()
ret = twain.TWAIN_CloseSourceManager(hwnd)
ret = twain.TWAIN_UnloadSourceManager()
print("* twain end\n")

if scanOk then
	tesseract.debug("barcode")
end
