--- lib/scanner/tesseract_h.lua

local ffi = require "mffi"
local C = ffi.C
local util = require "util"

local tessh = {}
tessh.version = 4

if util.isWin() then
	util.loadDll("graphics/libwinpthread-1.dll")
	util.loadDll("graphics/libgcc_s_sjlj-1.dll")
	util.loadDll("graphics/libgcc_s_dw2-1.dll")
	if tessh.version == 3 then
		util.loadDll("libstdc++-6.dll")
	else
		util.loadDll("graphics/libstdc++-6.dll")
	end
	util.loadDll("graphics/libgomp-1.dll")
	util.loadDll("graphics/zlib1.dll")
	util.loadDll("graphics/libjpeg-8.dll")
	util.loadDll("graphics/liblzma-5.dll")
	util.loadDll("graphics/libtiff-5.dll")
	util.loadDll("graphics/libpng16-16.dll")
	util.loadDll("graphics/libgif-7.dll")
	util.loadDll("graphics/libopenjp2-7.dll")
	util.loadDll("graphics/libwebp-7.dll")
	-- util.loadDll("graphics/libjbig-2.dll")
	if tessh.version == 3 then
		tessh.lept = util.loadDll("graphics/liblept-5.dll")
		tessh.tess = util.loadDll("graphics/libtesseract-3.dll")
	else
		tessh.lept = util.loadDll("graphics/liblept-5.dll")
		tessh.tess = util.loadDll("graphics/libtesseract-4.dll")
	end
elseif util.isMac() then
	if tessh.version == 5 then
		tessh.tess = util.loadDll("graphics/tesseract.5")
	else
		tessh.tess = util.loadDll("graphics/tesseract.4")
	end
	tessh.lept = tessh.tess
elseif util.isLinux() then
	-- if tessh.version == 3 then
	-- util.loadDll("graphics/libopenjp2.so.7")
	-- util.loadDll("graphics/liblept.so.5")
	-- tessh.tess = util.loadDll("graphics/libtesseract.so.3")
	-- tessh.tess = util.loadDll("graphics/libtesseract.so.4")
	-- end
	local ok, lib = pcall(ffi.load, "libtesseract.so.4")
	if not ok then
		util.printRed("loading libtesseract failed: install it using 'sudo apt-get install libtesseract4'")
		tessh.tess = nil
	else
		tessh.tess = lib
	end
	tessh.lept = tessh.tess
end

ffi.cdef [[ // leptonica
// https://tpgit.github.io/Leptonica/pix_8h_source.html

struct PixColormap
{
	void            *array;     /* colormap table (array of RGBA_QUAD)     */
	int32_t          depth;     /* of pix (1, 2, 4 or 8 bpp)               */
	int32_t          nalloc;    /* number of color entries allocated       */
	int32_t          n;         /* number of color entries used            */
};
typedef struct PixColormap  PIXCMAP;

struct Pix
{
	uint32_t             w;           /* width in pixels                   */
	uint32_t             h;           /* height in pixels                  */
	uint32_t             d;           /* depth in bits                     */
	uint32_t             wpl;         /* 32-bit words/line                 */
	uint32_t             refcount;    /* reference count (1 if no clones)  */
	int32_t              xres;        /* image res (ppi) in x direction    */
																	 /* (use 0 if unknown)                */
	int32_t              yres;        /* image res (ppi) in y direction    */
																	 /* (use 0 if unknown)                */
	int32_t              informat;    /* input file format, IFF_*          */
	char                *text;        /* text string associated with pix   */
	struct PixColormap  *colormap;    /* colormap (may be null)            */
	uint32_t            *data;        /* the image data                    */
};
typedef struct Pix PIX;

char *getLeptonicaVersion();
PIX *pixRead(const char *filename);
void pixDestroy(PIX **ppix);
]]

ffi.cdef [[ // tesseract
typedef int BOOL;
static const int TRUE = 1;
static const int FALSE = 0;
typedef struct ETEXT_DESC ETEXT_DESC;
typedef struct TessBaseAPI TessBaseAPI;
typedef struct TessResultRenderer TessResultRenderer;
typedef struct TessPageIterator TessPageIterator;
typedef struct ETEXT_DESC ETEXT_DESC;
typedef enum TessOcrEngineMode { OEM_TESSERACT_ONLY, OEM_LSTM_ONLY, OEM_TESSERACT_LSTM_COMBINED, OEM_DEFAULT } TessOcrEngineMode;
typedef enum TessPageSegMode       { PSM_OSD_ONLY, PSM_AUTO_OSD, PSM_AUTO_ONLY, PSM_AUTO, PSM_SINGLE_COLUMN, PSM_SINGLE_BLOCK_VERT_TEXT,
                                     PSM_SINGLE_BLOCK, PSM_SINGLE_LINE, PSM_SINGLE_WORD, PSM_CIRCLE_WORD, PSM_SINGLE_CHAR, PSM_SPARSE_TEXT,
                                     PSM_SPARSE_TEXT_OSD, PSM_COUNT } TessPageSegMode;
																		typedef enum TessPageIteratorLevel { RIL_BLOCK, RIL_PARA, RIL_TEXTLINE, RIL_WORD, RIL_SYMBOL} TessPageIteratorLevel;
typedef enum TessPolyBlockType     { PT_UNKNOWN, PT_FLOWING_TEXT, PT_HEADING_TEXT, PT_PULLOUT_TEXT, PT_EQUATION, PT_INLINE_EQUATION,
                                     PT_TABLE, PT_VERTICAL_TEXT, PT_CAPTION_TEXT, PT_FLOWING_IMAGE, PT_HEADING_IMAGE,
                                     PT_PULLOUT_IMAGE, PT_HORZ_LINE, PT_VERT_LINE, PT_NOISE, PT_COUNT } TessPolyBlockType;
typedef enum TessOrientation       { ORIENTATION_PAGE_UP, ORIENTATION_PAGE_RIGHT, ORIENTATION_PAGE_DOWN, ORIENTATION_PAGE_LEFT } TessOrientation;
typedef enum TessParagraphJustification { JUSTIFICATION_UNKNOWN, JUSTIFICATION_LEFT, JUSTIFICATION_CENTER, JUSTIFICATION_RIGHT } TessParagraphJustification;
typedef enum TessWritingDirection  { WRITING_DIRECTION_LEFT_TO_RIGHT, WRITING_DIRECTION_RIGHT_TO_LEFT, WRITING_DIRECTION_TOP_TO_BOTTOM } TessWritingDirection;
typedef enum TessTextlineOrder     { TEXTLINE_ORDER_LEFT_TO_RIGHT, TEXTLINE_ORDER_RIGHT_TO_LEFT, TEXTLINE_ORDER_TOP_TO_BOTTOM } TessTextlineOrder;

const char* TessVersion();
TessBaseAPI* TessBaseAPICreate();
void TessBaseAPIDelete(TessBaseAPI* api);
int TessBaseAPIInit3(TessBaseAPI* api, const char* datapath, const char* language);
int TessBaseAPIInit4(TessBaseAPI* api, const char* datapath, const char* language, TessOcrEngineMode mode,
    char** configs, int configs_size,
    char** vars_vec, char** vars_values, size_t vars_vec_size,
    BOOL set_only_non_debug_params);
void TessBaseAPISetImage2(TessBaseAPI* api, struct Pix* pix);
void TessDeleteText(char* text);
void TessBaseAPIClear(TessBaseAPI* api);
void TessBaseAPIEnd(TessBaseAPI* api);
void TessBaseAPISetSourceResolution(TessBaseAPI* handle, int ppi);

int  TessBaseAPIRecognize(TessBaseAPI* api, ETEXT_DESC* monitor);
char* TessBaseAPIGetUTF8Text(TessBaseAPI* api);
char* TessBaseAPIGetHOCRText(TessBaseAPI* handle, int page_number);
BOOL TessBaseAPIDetectOrientationScript(TessBaseAPI* api, int* orient_deg, float* orient_conf,
																			 const char** script_name, float* script_conf);
BOOL TessBaseAPIProcessPages(TessBaseAPI* api, const char* filename, const char* retry_config,
                    int timeout_millisec, TessResultRenderer* renderer);
TessResultRenderer* TessPDFRendererCreate(const char* outputbase, const char* datadir, BOOL textonly);
void TessBaseAPISetPageSegMode(TessBaseAPI* handle, TessPageSegMode mode);
TessPageSegMode TessBaseAPIGetPageSegMode(const TessBaseAPI* handle);
// TessResultIterator* TessBaseAPIGetIterator(TessBaseAPI* handle);
TessPageIterator* TessBaseAPIAnalyseLayout(TessBaseAPI* handle);
void TessPageIteratorOrientation(TessPageIterator* handle, TessOrientation* orientation, TessWritingDirection* writing_direction, TessTextlineOrder* textline_order, float* deskew_angle);

typedef bool (*TessCancelFunc)(void* cancel_this, int words);
typedef bool (*TessProgressFunc)(ETEXT_DESC* ths, int left, int right, int top, int bottom);
ETEXT_DESC* TessMonitorCreate();
void TessMonitorDelete(ETEXT_DESC* monitor);
void TessMonitorSetCancelFunc(ETEXT_DESC* monitor, TessCancelFunc cancelFunc);
void TessMonitorSetCancelThis(ETEXT_DESC* monitor, void* cancelThis);
void* TessMonitorGetCancelThis(ETEXT_DESC* monitor);
void TessMonitorSetProgressFunc(ETEXT_DESC* monitor, TessProgressFunc progressFunc);
int TessMonitorGetProgress(ETEXT_DESC* monitor);
void TessMonitorSetDeadlineMSecs(ETEXT_DESC* monitor, int deadline);

]]

return tessh
