--- lib/scanner/tesseract_resize_pdf.lua
-- https://stackoverflow.com/questions/7446552/resizing-a-pdf-using-ghostscript
-- https://github.com/tavinus/pdfScale/blob/master/pdfScale.sh
-- https://ghostscript.com/doc/Readme.htm
package.path = "lib/?.lua;lib/?.lx;" .. package.path
package.path = "../lib/?.lua;../lib/?.lx;" .. package.path
package.path = "../../lib/?.lua;../../lib/?.lx;" .. package.path
require "start"

local tesseract = {}

local util = require "util"
local peg = require "peg"
local fs = require "fs"

-- -dPDFSETTINGS="/printer" or "/ebook", /printer is better but makes much larger files
-- ebook seems to be about 200 dpi
-- -dAutoRotatePages='/PageByPage' \ -- windows version of gs does not support this
local gsCommand = [[
-q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -dSAFER \
-dCompatibilityLevel="1.7" -dPDFSETTINGS="/ebook" \
-dColorConversionStrategy=/LeaveColorUnchanged \
-sPAPERSIZE=a4 \
-dFIXEDMEDIA -dPDFFitPage \
-I {{initpath}} \
-sOutputFile='{{outfile}}' \
-f '{{infile}}'
]]

function tesseract.resizePdf(inputPdf)
	if util.isWine() then
		inputPdf = "Z:" .. inputPdf
	elseif util.isLinux() then
		inputPdf = peg.replace(inputPdf, "/Users/pasi/ma-git/", "/media/psf/Home/nc/")
	end
	local ext = peg.parseLast(inputPdf, ".")
	local name = peg.parseBeforeLast(inputPdf, ".")
	util.printInfo("* resizing pdf '%s'", inputPdf)
	local outputPdf = name .. "_small.pdf" -- ..ext
	util.printInfo("* writing file '%s'", outputPdf)
	local exe = util.pathBin() .. "gs "
	local initPathStart = fs.upperPath(util.pathBin()) .. "bin_data/ghostscript/" -- paths switch usage: "-I path1:path2:path3:"
	local initPath = initPathStart .. "Resource/Init:"
	initPath = initPath .. initPathStart .. "iccprofiles:"
	-- initPath = initPath..initPathStart.."Resource/Font:"
	-- initPath = initPath..initPathStart.."lib:"
	-- initPath = initPath..initPathStart.."fonts:"
	local cmd = peg.replace(gsCommand, "{{initpath}}", initPath)
	cmd = peg.replace(cmd, "{{outfile}}", outputPdf)
	cmd = peg.replace(cmd, "{{infile}}", inputPdf)
	local time = util.seconds()
	local ret = util.runCommandLine(exe .. cmd)
	time = util.seconds(time)
	if ret ~= "" then
		util.printError("ghostscript error '%s', command:\n%s", ret, exe .. cmd)
		return
	end
	util.print(exe .. cmd)
	local inputSize = fs.fileSize(inputPdf)
	local outputSize = fs.fileSize(outputPdf)
	if inputSize == nil then
		util.printWarning("input file '%s', was not found", inputPdf)
		return
	elseif outputSize == nil then
		util.printWarning("output file '%s', was not found", outputPdf)
		return
	end
	inputSize = util.fileSize(fs.fileSize(inputPdf), 2)
	outputSize = util.fileSize(fs.fileSize(outputPdf), 1)
	util.printInfo("* done file '%s', time %.2f seconds, input size %s, output size %s", outputPdf, time, inputSize, outputSize)
	fs.openFile(outputPdf)
	return outputPdf
end

if not ... then
	tesseract.resizePdf("/Users/pasi/nc/nc-server/test/lib/scanner/scanout.pdf")
else
	local arg = {...}
	tesseract.resizePdf(arg[1])
end

return tesseract
