--- search.lua
--
-- @module search

local search = {}

local default_fcompval = function( value ) return value end

local table_fcompval = function(key)
	return function(rec)  
		return rec[key]
	end
end

local fcompf = function( a,b ) return a < b end
local fcompr = function( a,b ) return a > b end
	 
function search.binaryArray(t, value, reverse, fcompval, nearest)
	-- http://lua-users.org/wiki/BinarySearch
	-- Avoid heap allocs for performance
	-- Initialise functions
	fcompval = fcompval or default_fcompval
	local fcomp = reverse and fcompr or fcompf
	--  Initialise numbers
	local iStart, iEnd, iMid = 1, #t, 0
	-- Binary Search
	while iStart <= iEnd do
		 -- calculate middle
		 iMid = math.floor((iStart + iEnd) / 2)
		 -- get compare value
		 local value2 = fcompval(t[iMid])
		 -- get all values that match
		 if value == value2 then
				local tfound,num = { iMid,iMid },iMid - 1
				while value == fcompval( t[num] ) do
					 tfound[1],num = num,num - 1
				end
				num = iMid + 1
				while value == fcompval( t[num] ) do
					 tfound[2],num = num,num + 1
				end
				return tfound
		 -- keep searching
		 elseif fcomp( value,value2 ) then
				iEnd = iMid - 1
		 else
				iStart = iMid + 1
		 end
	end
end

	
function search.binaryRecord(t, key, value, reverse, nearest)
	return search.binaryArray(t, value, reverse, table_fcompval(key))
end

	-- http://lua-users.org/wiki/InterpolatingSearch
	-- Avoid heap allocs for performance
 function search.interpolating( t, value, fcompval )
		-- Initialise functions
		local fcompval = fcompval or default_fcompval
		-- Inistialise numbers
		local ilow,ihigh = 1,#t
		-- return on empty table
		if not t[ilow] then return end
		-- get values of indices
		local _ilow,_ihigh = fcompval( t[ilow] ),fcompval( t[ihigh] )
		-- make sure slope cannot become 0
		while _ilow and _ilow < _ihigh do
			 -- get interpolated position
			 local pos = math.floor( (value-_ilow)*(ihigh-ilow)/(_ihigh-_ilow) ) + ilow
			 -- check for out of range
			 if pos < ilow or pos > ihigh then return end
			 -- get compare value
			 local compval = fcompval( t[pos] )
			 if value == compval then
					-- insert found position
					local tfound,num = { pos,pos },pos-1
					-- get all values that match
					while value == fcompval( t[num] ) do
						 tfound[1],num = num,num-1
					end
					num = pos+1
					while value == fcompval( t[num] ) do
						 tfound[2],num = num,num+1
					end
					return tfound
			 -- keep searching,
			 -- left part of the table
			 elseif value < compval then
					ihigh = pos-1
			 else
					ilow = pos+1
			 end
			 _ilow,_ihigh = fcompval( t[ilow] ),fcompval( t[ihigh] )
		end
		if value == fcompval( t[ilow] ) then
			 -- only add values --> of ilow
			 local tfound,num = { ilow,ilow },ilow+1
			 while value == fcompval( t[num] ) do
					tfound[2],num = num,num+1
			 end
			 return tfound         
		end
   end
 
 -- Interpolated search on a reverse table
 function intsearchrev( t,value,fcompval )
		-- Initialise functions
		local fcompval = fcompval or default_fcompval
		-- Inistialise numbers
		local ilow,ihigh = 1,#t
		if not t[ilow] then return end
		local _ilow,_ihigh = fcompval( t[ilow] ),fcompval( t[ihigh] )
		while _ilow and _ilow > _ihigh do
			 -- get interpolated position
			 local pos = math.floor( (_ihigh-value)*(ihigh-ilow)/(_ihigh-_ilow) ) + ilow
			 -- check for out of range
			 if pos < ilow or pos > ihigh then return end
			 local compval = fcompval( t[pos] )
			 if value == compval then
					-- insert found position
					local tfound,num = { pos,pos },pos-1
					-- get all values that match
					while value == fcompval( t[num] ) do
						 tfound[1],num = num,num-1
					end
					num = pos+1
					while value == fcompval( t[num] ) do
						 tfound[2],num = num,num+1
					end
					return tfound
					-- keep searching,
					-- left part of the table
			 elseif value > compval then
					ihigh = pos-1
			 else
					ilow = pos+1
			 end
			 _ilow,_ihigh = fcompval( t[ilow] ),fcompval( t[ihigh] )
		end
		if value == fcompval( t[ilow] ) then
			 -- only add values --> of ilow
			 local tfound,num = { ilow,ilow },ilow+1
			 while value == fcompval( t[num] ) do
					tfound[2],num = num,num+1
			 end
			 return tfound         
		end
 end

return search

